#!/usr/bin/env perl
use 5.010001;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
  NAME         => 'Mojolicious::Plugin::PubSubHubbub',
  AUTHOR       => 'Nils Diewald',
  ABSTRACT     => 'Publish and Subscribe with PubSubHubbub',
  VERSION_FROM => 'lib/Mojolicious/Plugin/PubSubHubbub.pm',
  BUILD_REQUIRES => {
    'Test::More' => 0
  },
  PREREQ_PM => {
    'Mojolicious' => 3.93,
    'Mojolicious::Plugin::Util::Endpoint' => 0.14,
    'Mojolicious::Plugin::Util::Callback' => 0.02
  },
  LICENSE      => 'perl',
  META_MERGE   => {
    requires  => {perl => '5.010001'},
    resources => {
      license     => 'http://www.opensource.org/licenses/artistic-license-2.0',
      repository  => 'https://github.com/Akron/Mojolicious-Plugin-PubSubHubbub'
    }
  },
  MIN_PERL_VERSION => '5.010001',
  test => {TESTS => 't/*.t t/examples/*.t'}
);
