/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Untyped;

public class StreamWriterToReceiver
implements XMLStreamWriter {
    private Receiver receiver;
    private NamePool namePool;
    private NameChecker nameChecker;
    private boolean isChecking = false;
    private int depth = -1;
    private boolean inStartTag;
    private boolean isEmptyElement;
    private boolean inventPrefixes = true;
    private NamespaceReducer inScopeNamespaces;
    private Map<String, String> declaredNamespaces = new HashMap<String, String>(10);
    private NamespaceContext rootNamespaceContext = null;

    public StreamWriterToReceiver(Receiver receiver) {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        this.inScopeNamespaces = new NamespaceReducer(receiver);
        this.receiver = this.inScopeNamespaces;
        this.nameChecker = pipe.getConfiguration().getNameChecker();
        this.namePool = pipe.getConfiguration().getNamePool();
    }

    public void setInventPrefixes(boolean invent) {
        this.inventPrefixes = invent;
    }

    public boolean isInventPrefixes() {
        return this.inventPrefixes;
    }

    public void setCheckValues(boolean check) {
        this.isChecking = check;
    }

    public boolean isCheckValues() {
        return this.isChecking;
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        String uri = this.inScopeNamespaces.getURIForPrefix("", true);
        assert (uri != null);
        this.writeStartElement("", localName, uri);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        boolean isDeclared;
        String prefix = this.getPrefix(namespaceURI);
        boolean bl = isDeclared = prefix != null;
        if (!isDeclared) {
            if (this.inventPrefixes) {
                prefix = this.inventPrefix(namespaceURI);
            } else {
                throw new XMLStreamException("namespace " + namespaceURI + " has not been declared");
            }
        }
        this.writeStartElement(prefix, localName, namespaceURI);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.depth == -1) {
            this.writeStartDocument();
        }
        try {
            if (!this.isValidURI(namespaceURI)) {
                throw new IllegalArgumentException("Invalid namespace URI: " + namespaceURI);
            }
            if (!this.isValidNCName(prefix)) {
                throw new IllegalArgumentException("Invalid prefix: " + prefix);
            }
            if (!this.isValidNCName(localName)) {
                throw new IllegalArgumentException("Invalid local name: " + localName);
            }
            this.startContent();
            this.inStartTag = true;
            ++this.depth;
            NodeName nc = namespaceURI.length() == 0 ? new NoNamespaceName(localName) : new FingerprintedQName(prefix, namespaceURI, localName);
            this.receiver.startElement(nc, Untyped.getInstance(), 0, 0);
            this.inStartTag = true;
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    private String inventPrefix(String uri) {
        String prefix = this.getPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.namePool.suggestPrefixForURI(uri);
        if (prefix != null) {
            return prefix;
        }
        int count = 0;
        while (true) {
            if (this.inScopeNamespaces.getURIForPrefix(prefix = "ns" + count, false) == null) {
                this.setPrefix(prefix, uri);
                return prefix;
            }
            ++count;
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName);
        this.isEmptyElement = true;
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.isEmptyElement = true;
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.isEmptyElement = true;
    }

    private void startContent() throws XMLStreamException {
        if (this.inStartTag) {
            try {
                this.receiver.startContent();
            }
            catch (XPathException err) {
                throw new XMLStreamException(err);
            }
            this.inStartTag = false;
            if (this.isEmptyElement) {
                this.isEmptyElement = false;
                this.writeEndElement();
            }
        }
    }

    public void writeEndElement() throws XMLStreamException {
        if (this.depth <= 0) {
            throw new IllegalStateException("writeEndElement with no matching writeStartElement");
        }
        try {
            this.startContent();
            this.receiver.endElement();
            --this.depth;
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        if (this.depth == -1) {
            throw new IllegalStateException("writeEndDocument with no matching writeStartDocument");
        }
        try {
            if (this.isEmptyElement) {
                this.startContent();
            }
            while (this.depth > 0) {
                this.writeEndElement();
            }
            this.receiver.endDocument();
            this.depth = -1;
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void close() throws XMLStreamException {
        if (this.depth >= 0) {
            this.writeEndDocument();
        }
        try {
            this.receiver.close();
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void flush() throws XMLStreamException {
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute("", "", localName, value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (!this.inStartTag) {
            throw new IllegalStateException("Cannot write attribute when not in a start tag");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (namespaceURI.length() != 0 && !this.isValidURI(namespaceURI)) {
            throw new IllegalArgumentException("Invalid attribute namespace URI: " + namespaceURI);
        }
        if (prefix.length() != 0 && !this.isValidNCName(prefix)) {
            throw new IllegalArgumentException("Invalid attribute prefix: " + prefix);
        }
        if (!this.isValidNCName(localName)) {
            throw new IllegalArgumentException("Invalid attribute local name: " + localName);
        }
        if (!this.isValidChars(value)) {
            throw new IllegalArgumentException("Invalid characters in attribute content: " + value);
        }
        try {
            FingerprintedQName nn = new FingerprintedQName(prefix, namespaceURI, localName);
            this.receiver.attribute(nn, BuiltInAtomicType.UNTYPED_ATOMIC, value, -1, 0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        String prefix = this.getPrefix(namespaceURI);
        if (prefix == null) {
            if (this.inventPrefixes) {
                prefix = this.inventPrefix(namespaceURI);
            } else {
                throw new XMLStreamException("Namespace " + namespaceURI + " has not been declared");
            }
        }
        this.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (!this.inStartTag) {
            throw new IllegalStateException("Cannot write namespace when not in a start tag");
        }
        if (prefix == null || "".equals(prefix) || "xmlns".equals(prefix)) {
            this.writeDefaultNamespace(namespaceURI);
            return;
        }
        if (!this.isValidURI(namespaceURI)) {
            throw new IllegalArgumentException("Invalid namespace URI: " + namespaceURI);
        }
        if (!this.isValidNCName(prefix)) {
            throw new IllegalArgumentException("Invalid namespace prefix: " + prefix);
        }
        this.outputNamespaceDeclaration(prefix, namespaceURI);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (!this.inStartTag) {
            throw new IllegalStateException();
        }
        if (!this.isValidURI(namespaceURI)) {
            throw new IllegalArgumentException("Invalid namespace URI: " + namespaceURI);
        }
        this.outputNamespaceDeclaration("", namespaceURI);
    }

    private void outputNamespaceDeclaration(String prefix, String namespaceURI) throws XMLStreamException {
        try {
            if (prefix == null) {
                prefix = "";
            }
            this.receiver.namespace(new NamespaceBinding(prefix, namespaceURI), 0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeComment(String data) throws XMLStreamException {
        if (data == null) {
            data = "";
        }
        try {
            if (!this.isValidChars(data)) {
                throw new IllegalArgumentException("Invalid XML character in comment: " + data);
            }
            if (this.isChecking && data.contains("--")) {
                throw new IllegalArgumentException("Comment contains '--'");
            }
            this.startContent();
            this.receiver.comment(data, 0, 0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, "");
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        try {
            if (this.isChecking) {
                if (!this.isValidNCName(target) || "xml".equalsIgnoreCase(target)) {
                    throw new IllegalArgumentException("Invalid PITarget: " + target);
                }
                if (!this.isValidChars(data)) {
                    throw new IllegalArgumentException("Invalid character in PI data: " + data);
                }
            }
            this.startContent();
            this.receiver.processingInstruction(target, data, 0, 0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeCData(String data) throws XMLStreamException {
        this.writeCharacters(data);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("writeEntityRef");
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(null, null);
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(null, version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if ("1.1".equals(version)) {
            this.nameChecker = Name11Checker.getInstance();
        }
        if (this.depth != -1) {
            throw new IllegalStateException("writeStartDocument must be the first call");
        }
        try {
            this.receiver.startDocument(0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
        this.depth = 0;
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if (text != null) {
            if (!this.isValidChars(text)) {
                throw new IllegalArgumentException("illegal XML character: " + text);
            }
            this.startContent();
            try {
                this.receiver.characters(text, 0, 0);
            }
            catch (XPathException err) {
                throw new XMLStreamException(err);
            }
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    public String getPrefix(String uri) {
        String prefix = this.declaredNamespaces.get(uri);
        if (prefix == null && this.rootNamespaceContext != null) {
            prefix = this.rootNamespaceContext.getPrefix(uri);
        }
        return prefix;
    }

    public void setPrefix(String prefix, String uri) {
        if (!this.isValidURI(uri)) {
            throw new IllegalArgumentException("Invalid namespace URI: " + uri);
        }
        if (!"".equals(prefix) && !this.isValidNCName(prefix)) {
            throw new IllegalArgumentException("Invalid namespace prefix: " + prefix);
        }
        this.declaredNamespaces.put(uri, prefix);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.setPrefix("", uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (this.depth > 0) {
            throw new IllegalStateException("setNamespaceContext may only be called at the start of the document");
        }
        this.rootNamespaceContext = context;
    }

    public NamespaceContext getNamespaceContext() {
        return this.rootNamespaceContext;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    private boolean isValidNCName(String name) {
        return !this.isChecking || this.nameChecker.isValidNCName(name);
    }

    private boolean isValidChars(String text) {
        return !this.isChecking || this.nameChecker.firstInvalidChar(text) == -1;
    }

    private boolean isValidURI(String uri) {
        return !this.isChecking || StandardURIChecker.getInstance().isValidURI(uri);
    }
}

