#########################################################################################
# Package        HiPi::Graphics::BitmapFont::MonoEPD50
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::MonoEPD50;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 50;
my $line_spacing = 0;
my $name = 'Mono 50';
my $space_width = 26;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 4, 
        'xoffset'  => 11, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 12, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 26, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1C, 0x1C, 0x00, ##             000     000    
            0x00, 0x1C, 0x1C, 0x00, ##             000     000    
            0x00, 0x1C, 0x1C, 0x00, ##             000     000    
            0x00, 0x3C, 0x3C, 0x00, ##            0000    0000    
            0x00, 0x38, 0x38, 0x00, ##            000     000     
            0x00, 0x38, 0x38, 0x00, ##            000     000     
            0x00, 0x38, 0x38, 0x00, ##            000     000     
            0x00, 0x78, 0x38, 0x00, ##           0000     000     
            0x00, 0x70, 0x78, 0x00, ##           000     0000     
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000
            0x00, 0xE0, 0xF0, 0x00, ##          000     0000      
            0x00, 0xE0, 0xE0, 0x00, ##          000     000       
            0x00, 0xE0, 0xE0, 0x00, ##          000     000       
            0x01, 0xE0, 0xE0, 0x00, ##         0000     000       
            0x01, 0xC1, 0xE0, 0x00, ##         000     0000       
            0x01, 0xC1, 0xC0, 0x00, ##         000     000        
            0x01, 0xC1, 0xC0, 0x00, ##         000     000        
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000   
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000   
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000   
            0x03, 0x83, 0x80, 0x00, ##        000     000         
            0x03, 0x83, 0x80, 0x00, ##        000     000         
            0x07, 0x07, 0x80, 0x00, ##       000     0000         
            0x07, 0x07, 0x00, 0x00, ##       000     000          
            0x07, 0x07, 0x00, 0x00, ##       000     000          
            0x07, 0x07, 0x00, 0x00, ##       000     000          
            0x0F, 0x0F, 0x00, 0x00, ##      0000    0000          
            0x0E, 0x0E, 0x00, 0x00, ##      000     000           
            0x0E, 0x0E, 0x00, 0x00, ##      000     000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x03, 0xFC, 0x00, ##        00000000     
            0x1F, 0xFF, 0x80, ##     00000000000000  
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x7C, 0x63, 0x80, ##   00000   00   000  
            0x78, 0x60, 0x80, ##   0000    00     0  
            0xF0, 0x60, 0x00, ##  0000     00        
            0xF0, 0x60, 0x00, ##  0000     00        
            0xF0, 0x60, 0x00, ##  0000     00        
            0xF0, 0x60, 0x00, ##  0000     00        
            0xF8, 0x60, 0x00, ##  00000    00        
            0x78, 0x60, 0x00, ##   0000    00        
            0x7F, 0x60, 0x00, ##   0000000 00        
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x07, 0xFF, 0x00, ##       00000000000   
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0x67, 0xC0, ##           00  00000 
            0x00, 0x63, 0xE0, ##           00   00000
            0x00, 0x61, 0xE0, ##           00    0000
            0x00, 0x61, 0xE0, ##           00    0000
            0x00, 0x61, 0xE0, ##           00    0000
            0x00, 0x61, 0xE0, ##           00    0000
            0x00, 0x61, 0xE0, ##           00    0000
            0xC0, 0x63, 0xC0, ##  00       00   0000 
            0xF8, 0x67, 0xC0, ##  00000    00  00000 
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0x7F, 0xFF, 0x00, ##   000000000000000   
            0x0F, 0xFC, 0x00, ##      0000000000     
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 25, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x3F, 0xE0, 0x00, 0x00, ##    000000000              
            0x7F, 0xE0, 0x00, 0x00, ##   0000000000              
            0x78, 0xF0, 0x00, 0x00, ##   0000   0000             
            0xF0, 0x78, 0x00, 0x00, ##  0000     0000            
            0xE0, 0x38, 0x00, 0x00, ##  000       000            
            0xE0, 0x38, 0x00, 0x00, ##  000       000            
            0xE0, 0x38, 0x00, 0x00, ##  000       000            
            0xE0, 0x38, 0x00, 0x00, ##  000       000            
            0xF0, 0x78, 0x00, 0x00, ##  0000     0000            
            0x78, 0xF0, 0x03, 0x00, ##   0000   0000          00 
            0x7F, 0xF0, 0x1F, 0x00, ##   00000000000       00000 
            0x3F, 0xE0, 0x7E, 0x00, ##    000000000      000000  
            0x0F, 0x83, 0xF0, 0x00, ##      00000     000000     
            0x00, 0x0F, 0xC0, 0x00, ##              000000       
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x01, 0xF8, 0x00, 0x00, ##         000000            
            0x0F, 0xC1, 0xF8, 0x00, ##      000000     000000    
            0x3F, 0x07, 0xFC, 0x00, ##    000000     000000000   
            0x78, 0x0F, 0xFE, 0x00, ##   0000       00000000000  
            0x20, 0x0F, 0x0F, 0x00, ##    0         0000    0000 
            0x00, 0x1E, 0x07, 0x80, ##             0000      0000
            0x00, 0x1C, 0x03, 0x80, ##             000        000
            0x00, 0x1C, 0x03, 0x80, ##             000        000
            0x00, 0x1C, 0x03, 0x80, ##             000        000
            0x00, 0x1E, 0x07, 0x80, ##             0000      0000
            0x00, 0x0F, 0x0F, 0x00, ##              0000    0000 
            0x00, 0x0F, 0xFF, 0x00, ##              000000000000 
            0x00, 0x07, 0xFE, 0x00, ##               0000000000  
            0x00, 0x01, 0xF8, 0x00, ##                 000000    
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x10, 0x00, ##             0            
            0x01, 0xFF, 0x80, ##         0000000000       
            0x03, 0xFF, 0x80, ##        00000000000       
            0x07, 0xFF, 0x80, ##       000000000000       
            0x0F, 0x80, 0x80, ##      00000       0       
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x80, 0x00, ##      00000               
            0x07, 0x80, 0x00, ##       0000               
            0x07, 0xC0, 0x00, ##       00000              
            0x03, 0xC0, 0x00, ##        0000              
            0x07, 0xE0, 0x00, ##       000000             
            0x0F, 0xF0, 0x00, ##      00000000            
            0x1E, 0xF0, 0x00, ##     0000 0000            
            0x3C, 0x78, 0x0F, ##    0000   0000       0000
            0x7C, 0x7C, 0x0F, ##   00000   00000      0000
            0x78, 0x3C, 0x0F, ##   0000     0000      0000
            0xF0, 0x1E, 0x0F, ##  0000       0000     0000
            0xF0, 0x1F, 0x0F, ##  0000       00000    0000
            0xF0, 0x0F, 0x0E, ##  0000        0000    000 
            0xF0, 0x07, 0x8E, ##  0000         0000   000 
            0xF0, 0x03, 0xDE, ##  0000          0000 0000 
            0xF0, 0x03, 0xDC, ##  0000          0000 000  
            0xF8, 0x01, 0xFC, ##  00000          0000000  
            0x78, 0x00, 0xF8, ##   0000           00000   
            0x7C, 0x00, 0xF8, ##   00000          00000   
            0x3E, 0x01, 0xF8, ##    00000        000000   
            0x1F, 0xFF, 0xFC, ##     0000000000000000000  
            0x0F, 0xFF, 0xBE, ##      0000000000000 00000 
            0x07, 0xFE, 0x1F, ##       0000000000    00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 4, 
        'xoffset'  => 11, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 10, 
        'xoffset'  => 9, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x80, ##        000 
            0x07, 0x80, ##       0000 
            0x07, 0x00, ##       000  
            0x0F, 0x00, ##      0000  
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1C, 0x00, ##     000    
            0x3C, 0x00, ##    0000    
            0x3C, 0x00, ##    0000    
            0x38, 0x00, ##    000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x70, 0x00, ##   000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0x70, 0x00, ##   000      
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x38, 0x00, ##    000     
            0x3C, 0x00, ##    0000    
            0x3C, 0x00, ##    0000    
            0x1C, 0x00, ##     000    
            0x1E, 0x00, ##     0000   
            0x0E, 0x00, ##      000   
            0x0F, 0x00, ##      0000  
            0x07, 0x00, ##       000  
            0x07, 0x80, ##       0000 
            0x03, 0x80, ##        000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 10, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x00, ##   000      
            0x78, 0x00, ##   0000     
            0x38, 0x00, ##    000     
            0x3C, 0x00, ##    0000    
            0x1C, 0x00, ##     000    
            0x1E, 0x00, ##     0000   
            0x0E, 0x00, ##      000   
            0x0F, 0x00, ##      0000  
            0x0F, 0x00, ##      0000  
            0x07, 0x00, ##       000  
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x03, 0x80, ##        000 
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x00, ##       000  
            0x0F, 0x00, ##      0000  
            0x0F, 0x00, ##      0000  
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1C, 0x00, ##     000    
            0x3C, 0x00, ##    0000    
            0x38, 0x00, ##    000     
            0x78, 0x00, ##   0000     
            0x70, 0x00, ##   000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0xE0, 0xC1, 0xC0, ##  000     00     000
            0xF0, 0xC3, 0xC0, ##  0000    00    0000
            0x3C, 0xCF, 0x00, ##    0000  00  0000  
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x07, 0xF8, 0x00, ##       00000000     
            0x01, 0xE0, 0x00, ##         0000       
            0x07, 0xF8, 0x00, ##       00000000     
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x3C, 0xCF, 0x00, ##    0000  00  0000  
            0xF0, 0xC3, 0xC0, ##  0000    00    0000
            0xE0, 0xC1, 0xC0, ##  000     00     000
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 7, 
        'xoffset'  => 9, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3C, ##    0000 
            0x7C, ##   00000 
            0x78, ##   0000  
            0x78, ##   0000  
            0x70, ##   000   
            0xF0, ##  0000   
            0xE0, ##  000    
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 11, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 5, 
        'xoffset'  => 10, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x03, 0xC0, ##                0000   
            0x00, 0x03, 0xC0, ##                0000   
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0xF0, 0x00, ##          0000         
            0x00, 0xF0, 0x00, ##          0000         
            0x01, 0xE0, 0x00, ##         0000          
            0x01, 0xE0, 0x00, ##         0000          
            0x03, 0xE0, 0x00, ##        00000          
            0x03, 0xC0, 0x00, ##        0000           
            0x03, 0xC0, 0x00, ##        0000           
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x1E, 0x00, 0x00, ##     0000              
            0x1E, 0x00, 0x00, ##     0000              
            0x3C, 0x00, 0x00, ##    0000               
            0x3C, 0x00, 0x00, ##    0000               
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0xF0, 0x00, 0x00, ##  0000                 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x03, 0xFC, 0x00, ##        00000000      
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x1E, 0x07, 0x80, ##     0000      0000   
            0x3C, 0x03, 0xC0, ##    0000        0000  
            0x3C, 0x03, 0xC0, ##    0000        0000  
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0xF0, 0xF0, ##  0000    0000    0000
            0xF1, 0xF8, 0xF0, ##  0000   000000   0000
            0xF1, 0xF8, 0xF0, ##  0000   000000   0000
            0xF1, 0xF8, 0xF0, ##  0000   000000   0000
            0xF0, 0xF0, 0xF0, ##  0000    0000    0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x3C, 0x03, 0xC0, ##    0000        0000  
            0x3C, 0x03, 0xC0, ##    0000        0000  
            0x1E, 0x07, 0x80, ##     0000      0000   
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 17, 
        'xoffset'  => 6, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xE0, 0x00, ##       000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xF1, 0xE0, 0x00, ##  0000   0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0x3F, 0xFC, 0x00, ##    000000000000     
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xF0, 0x07, 0xC0, ##  0000         00000 
            0xC0, 0x03, 0xC0, ##  00            0000 
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x0F, 0x80, ##              00000  
            0x00, 0x0F, 0x00, ##              0000   
            0x00, 0x1E, 0x00, ##             0000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x7C, 0x00, ##           00000     
            0x00, 0xF8, 0x00, ##          00000      
            0x01, 0xF0, 0x00, ##         00000       
            0x03, 0xE0, 0x00, ##        00000        
            0x07, 0xC0, 0x00, ##       00000         
            0x0F, 0x80, 0x00, ##      00000          
            0x1F, 0x00, 0x00, ##     00000           
            0x3E, 0x00, 0x00, ##    00000            
            0x7C, 0x00, 0x00, ##   00000             
            0xF8, 0x00, 0x00, ##  00000              
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x3F, 0xFC, 0x00, ##    000000000000      
            0x7F, 0xFF, 0x00, ##   000000000000000    
            0x7F, 0xFF, 0x80, ##   0000000000000000   
            0x60, 0x07, 0xC0, ##   00          00000  
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x07, 0xC0, ##               00000  
            0x00, 0x0F, 0x80, ##              00000   
            0x07, 0xFF, 0x00, ##       00000000000    
            0x07, 0xFC, 0x00, ##       000000000      
            0x07, 0xFF, 0x00, ##       00000000000    
            0x00, 0x0F, 0x80, ##              00000   
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x01, 0xF0, ##                 00000
            0x80, 0x03, 0xE0, ##  0             00000 
            0xE0, 0x07, 0xE0, ##  000          000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0x7F, 0xFE, 0x00, ##   00000000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x1F, 0x80, ##             000000     
            0x00, 0x1F, 0x80, ##             000000     
            0x00, 0x3F, 0x80, ##            0000000     
            0x00, 0x7F, 0x80, ##           00000000     
            0x00, 0x77, 0x80, ##           000 0000     
            0x00, 0xE7, 0x80, ##          000  0000     
            0x01, 0xE7, 0x80, ##         0000  0000     
            0x01, 0xC7, 0x80, ##         000   0000     
            0x03, 0x87, 0x80, ##        000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x07, 0x80, ##       000     0000     
            0x0F, 0x07, 0x80, ##      0000     0000     
            0x1E, 0x07, 0x80, ##     0000      0000     
            0x1C, 0x07, 0x80, ##     000       0000     
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x78, 0x07, 0x80, ##   0000        0000     
            0x78, 0x07, 0x80, ##   0000        0000     
            0xF0, 0x07, 0x80, ##  0000         0000     
            0xE0, 0x07, 0x80, ##  000          0000     
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0x80, ##   0000000000000000  
            0x7F, 0xFF, 0x80, ##   0000000000000000  
            0x7F, 0xFF, 0x80, ##   0000000000000000  
            0x78, 0x00, 0x00, ##   0000              
            0x78, 0x00, 0x00, ##   0000              
            0x78, 0x00, 0x00, ##   0000              
            0x78, 0x00, 0x00, ##   0000              
            0x78, 0x00, 0x00, ##   0000              
            0x78, 0x00, 0x00, ##   0000              
            0x78, 0x00, 0x00, ##   0000              
            0x78, 0x00, 0x00, ##   0000              
            0x7F, 0xF0, 0x00, ##   00000000000       
            0x7F, 0xFE, 0x00, ##   00000000000000    
            0x7F, 0xFF, 0x00, ##   000000000000000   
            0x70, 0x1F, 0x80, ##   000       000000  
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x07, 0xC0, ##               00000 
            0xC0, 0x0F, 0x80, ##  00          00000  
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0xFF, 0xFE, 0x00, ##  000000000000000    
            0xFF, 0xF8, 0x00, ##  0000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x01, 0xFF, 0xC0, ##         00000000000  
            0x07, 0xFF, 0xC0, ##       0000000000000  
            0x0F, 0xFF, 0xC0, ##      00000000000000  
            0x1F, 0x00, 0x40, ##     00000         0  
            0x3E, 0x00, 0x00, ##    00000             
            0x3C, 0x00, 0x00, ##    0000              
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x70, 0x00, 0x00, ##   000                
            0xF0, 0xFC, 0x00, ##  0000    000000      
            0xF3, 0xFF, 0x00, ##  0000  0000000000    
            0xF7, 0xFF, 0x80, ##  0000 000000000000   
            0xFF, 0x07, 0xC0, ##  00000000     00000  
            0xFE, 0x03, 0xE0, ##  0000000       00000 
            0xFC, 0x01, 0xE0, ##  000000         0000 
            0xF8, 0x01, 0xE0, ##  00000          0000 
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0x7C, 0x01, 0xE0, ##   00000         0000 
            0x3C, 0x01, 0xE0, ##    0000         0000 
            0x3E, 0x03, 0xC0, ##    00000       0000  
            0x1F, 0xFF, 0xC0, ##     000000000000000  
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x03, 0xFE, 0x00, ##        000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x07, 0xC0, ##               00000  
            0x00, 0x07, 0x80, ##               0000   
            0x00, 0x07, 0x80, ##               0000   
            0x00, 0x0F, 0x80, ##              00000   
            0x00, 0x0F, 0x00, ##              0000    
            0x00, 0x1F, 0x00, ##             00000    
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x3E, 0x00, ##            00000     
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x7C, 0x00, ##           00000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0xF8, 0x00, ##          00000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF0, 0x00, ##         00000        
            0x01, 0xE0, 0x00, ##         0000         
            0x03, 0xE0, 0x00, ##        00000         
            0x03, 0xC0, 0x00, ##        0000          
            0x03, 0xC0, 0x00, ##        0000          
            0x07, 0xC0, 0x00, ##       00000          
            0x07, 0x80, 0x00, ##       0000           
            0x0F, 0x80, 0x00, ##      00000           
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x20, 0x00, ##            0         
            0x07, 0xFF, 0x00, ##       00000000000    
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x1F, 0xFF, 0xC0, ##     000000000000000  
            0x3E, 0x03, 0xE0, ##    00000       00000 
            0x7C, 0x01, 0xE0, ##   00000         0000 
            0x78, 0x00, 0xF0, ##   0000           0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0x3C, 0x01, 0xE0, ##    0000         0000 
            0x3C, 0x01, 0xE0, ##    0000         0000 
            0x1F, 0x07, 0xC0, ##     00000     00000  
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x01, 0xFE, 0x00, ##         00000000     
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x1E, 0x07, 0xC0, ##     0000      00000  
            0x3C, 0x03, 0xE0, ##    0000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFC, 0x00, ##       000000000      
            0x1F, 0xFF, 0x00, ##     0000000000000    
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x7C, 0x07, 0xC0, ##   00000       00000  
            0x78, 0x03, 0xC0, ##   0000         0000  
            0x78, 0x03, 0xE0, ##   0000         00000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x78, 0x03, 0xF0, ##   0000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x3E, 0x0F, 0xF0, ##    00000     00000000
            0x1F, 0xFE, 0xF0, ##     000000000000 0000
            0x0F, 0xFC, 0xF0, ##      0000000000  0000
            0x03, 0xF0, 0xF0, ##        000000    0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xE0, ##                00000 
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x07, 0xC0, ##               00000  
            0x30, 0x0F, 0x80, ##    00        00000   
            0x3F, 0xFF, 0x00, ##    00000000000000    
            0x3F, 0xFE, 0x00, ##    0000000000000     
            0x3F, 0xF8, 0x00, ##    00000000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 5, 
        'xoffset'  => 10, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 7, 
        'xoffset'  => 8, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3E, ##    00000
            0x3C, ##    0000 
            0x7C, ##   00000 
            0x78, ##   0000  
            0x78, ##   0000  
            0x70, ##   000   
            0x70, ##   000   
            0xE0, ##  000    
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x04, ##                       0
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0xFC, ##                  000000
            0x00, 0x07, 0xFC, ##               000000000
            0x00, 0x1F, 0xF0, ##             000000000  
            0x00, 0xFF, 0xC0, ##          0000000000    
            0x03, 0xFE, 0x00, ##        000000000       
            0x1F, 0xF0, 0x00, ##     000000000          
            0x7F, 0xC0, 0x00, ##   000000000            
            0xFE, 0x00, 0x00, ##  0000000               
            0xF8, 0x00, 0x00, ##  00000                 
            0xFE, 0x00, 0x00, ##  0000000               
            0x7F, 0x80, 0x00, ##   00000000             
            0x1F, 0xF0, 0x00, ##     000000000          
            0x03, 0xFE, 0x00, ##        000000000       
            0x00, 0xFF, 0x80, ##          000000000     
            0x00, 0x1F, 0xF0, ##             000000000  
            0x00, 0x07, 0xFC, ##               000000000
            0x00, 0x00, 0xFC, ##                  000000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x04, ##                       0
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x80, 0x00, 0x00, ##  0                     
            0xF0, 0x00, 0x00, ##  0000                  
            0xFC, 0x00, 0x00, ##  000000                
            0xFF, 0x80, 0x00, ##  000000000             
            0x3F, 0xE0, 0x00, ##    000000000           
            0x0F, 0xFC, 0x00, ##      0000000000        
            0x01, 0xFF, 0x00, ##         000000000      
            0x00, 0x3F, 0xE0, ##            000000000   
            0x00, 0x0F, 0xF8, ##              000000000 
            0x00, 0x01, 0xFC, ##                 0000000
            0x00, 0x00, 0x7C, ##                   00000
            0x00, 0x01, 0xFC, ##                 0000000
            0x00, 0x07, 0xF8, ##               00000000 
            0x00, 0x3F, 0xE0, ##            000000000   
            0x01, 0xFF, 0x00, ##         000000000      
            0x07, 0xFC, 0x00, ##       000000000        
            0x3F, 0xE0, 0x00, ##    000000000           
            0xFF, 0x80, 0x00, ##  000000000             
            0xFC, 0x00, 0x00, ##  000000                
            0xF0, 0x00, 0x00, ##  0000                  
            0x80, 0x00, 0x00, ##  0                     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 16, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##                  
            0x3F, 0xF0, ##    0000000000    
            0xFF, 0xFC, ##  00000000000000  
            0xFF, 0xFE, ##  000000000000000 
            0xE0, 0x3E, ##  000       00000 
            0x80, 0x1F, ##  0          00000
            0x00, 0x0F, ##              0000
            0x00, 0x0F, ##              0000
            0x00, 0x0F, ##              0000
            0x00, 0x0F, ##              0000
            0x00, 0x1E, ##             0000 
            0x00, 0x3E, ##            00000 
            0x00, 0x7C, ##           00000  
            0x00, 0xF8, ##          00000   
            0x01, 0xF0, ##         00000    
            0x01, 0xF0, ##         00000    
            0x03, 0xE0, ##        00000     
            0x07, 0xC0, ##       00000      
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xC0, ##             0000000      
            0x00, 0xFF, 0xF0, ##          000000000000    
            0x03, 0xFF, 0xF8, ##        000000000000000   
            0x07, 0xE0, 0x7C, ##       000000      00000  
            0x0F, 0x80, 0x1E, ##      00000          0000 
            0x1E, 0x00, 0x0E, ##     0000             000 
            0x1C, 0x00, 0x0E, ##     000              000 
            0x3C, 0x00, 0x07, ##    0000               000
            0x38, 0x00, 0x07, ##    000                000
            0x78, 0x07, 0xC7, ##   0000        00000   000
            0x70, 0x1F, 0xF7, ##   000       000000000 000
            0x70, 0x3F, 0xFF, ##   000      00000000000000
            0xF0, 0x7C, 0x3F, ##  0000     00000    000000
            0xE0, 0x78, 0x0F, ##  000      0000       0000
            0xE0, 0x70, 0x0F, ##  000      000        0000
            0xE0, 0xE0, 0x07, ##  000     000          000
            0xE0, 0xE0, 0x07, ##  000     000          000
            0xE0, 0xE0, 0x07, ##  000     000          000
            0xE0, 0xE0, 0x07, ##  000     000          000
            0xE0, 0xE0, 0x07, ##  000     000          000
            0xE0, 0xE0, 0x07, ##  000     000          000
            0xE0, 0x70, 0x0F, ##  000      000        0000
            0xE0, 0x70, 0x0F, ##  000      000        0000
            0x70, 0x7C, 0x3F, ##   000     00000    000000
            0x70, 0x3F, 0xFF, ##   000      00000000000000
            0x70, 0x1F, 0xF7, ##   000       000000000 000
            0x78, 0x07, 0xC7, ##   0000        00000   000
            0x38, 0x00, 0x00, ##    000                   
            0x3C, 0x00, 0x00, ##    0000                  
            0x1E, 0x00, 0x00, ##     0000                 
            0x0F, 0x00, 0x00, ##      0000                
            0x07, 0x80, 0x00, ##       0000               
            0x03, 0xF0, 0x10, ##        000000       0    
            0x01, 0xFF, 0xF8, ##         00000000000000   
            0x00, 0x7F, 0xF8, ##           000000000000   
            0x00, 0x0F, 0xF0, ##              00000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xC7, 0x80, ##        0000   0000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0xC3, 0xC0, ##       00000    0000      
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x01, 0xF0, ##      0000       00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x3F, 0xFF, 0xF8, ##    0000000000000000000   
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3C, ##   00000            0000  
            0x78, 0x00, 0x3E, ##   0000             00000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xF8, 0x00, ##  0000000000000       
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0xF0, 0x0F, 0xC0, ##  0000        000000  
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x0F, 0xC0, ##  0000        000000  
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0xF0, 0x0F, 0xC0, ##  0000        000000  
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x07, 0xE0, ##  0000         000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x01, 0xFF, 0xC0, ##         00000000000  
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x0F, 0xFF, 0xF0, ##      0000000000000000
            0x0F, 0x00, 0x70, ##      0000         000
            0x1E, 0x00, 0x10, ##     0000            0
            0x3C, 0x00, 0x00, ##    0000              
            0x3C, 0x00, 0x00, ##    0000              
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x3C, 0x00, 0x00, ##    0000              
            0x3C, 0x00, 0x00, ##    0000              
            0x1E, 0x00, 0x10, ##     0000            0
            0x1F, 0x00, 0x70, ##     00000         000
            0x0F, 0xFF, 0xF0, ##      0000000000000000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x01, 0xFF, 0xC0, ##         00000000000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, ##  00000000000         
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xFF, 0xFE, 0x00, ##  000000000000000     
            0xF0, 0x3F, 0x00, ##  0000      000000    
            0xF0, 0x0F, 0x80, ##  0000        00000   
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x0F, 0x80, ##  0000        00000   
            0xF0, 0x3F, 0x00, ##  0000      000000    
            0xFF, 0xFE, 0x00, ##  000000000000000     
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xFF, 0xE0, 0x00, ##  00000000000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 19, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x01, 0xFF, 0xC0, ##         00000000000   
            0x03, 0xFF, 0xF0, ##        00000000000000 
            0x0F, 0xFF, 0xF0, ##      0000000000000000 
            0x0F, 0x00, 0x70, ##      0000         000 
            0x1E, 0x00, 0x30, ##     0000           00 
            0x3C, 0x00, 0x00, ##    0000               
            0x3C, 0x00, 0x00, ##    0000               
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x0F, 0xF8, ##  0000        000000000
            0xF0, 0x0F, 0xF8, ##  0000        000000000
            0xF0, 0x0F, 0xF8, ##  0000        000000000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0x78, ##   0000            0000
            0x78, 0x00, 0x78, ##   0000            0000
            0x78, 0x00, 0x78, ##   0000            0000
            0x3C, 0x00, 0x78, ##    0000           0000
            0x3C, 0x00, 0x78, ##    0000           0000
            0x1E, 0x00, 0x78, ##     0000          0000
            0x1F, 0x00, 0xF8, ##     00000        00000
            0x0F, 0xFF, 0xF8, ##      00000000000000000
            0x03, 0xFF, 0xF0, ##        00000000000000 
            0x01, 0xFF, 0xC0, ##         00000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 17, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xFF, 0x80, ##       000000000000
            0x07, 0xFF, 0x80, ##       000000000000
            0x07, 0xFF, 0x80, ##       000000000000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x0F, 0x80, ##              00000
            0x80, 0x0F, 0x00, ##  0           0000 
            0xE0, 0x1F, 0x00, ##  000        00000 
            0xFF, 0xFE, 0x00, ##  000000000000000  
            0xFF, 0xFC, 0x00, ##  00000000000000   
            0x7F, 0xF8, 0x00, ##   000000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 23, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x7C, ##  0000             00000 
            0xF0, 0x00, 0xF8, ##  0000            00000  
            0xF0, 0x01, 0xF0, ##  0000           00000   
            0xF0, 0x03, 0xE0, ##  0000          00000    
            0xF0, 0x07, 0xC0, ##  0000         00000     
            0xF0, 0x0F, 0x80, ##  0000        00000      
            0xF0, 0x1F, 0x00, ##  0000       00000       
            0xF0, 0x3E, 0x00, ##  0000      00000        
            0xF0, 0x7C, 0x00, ##  0000     00000         
            0xF0, 0xF8, 0x00, ##  0000    00000          
            0xF1, 0xF0, 0x00, ##  0000   00000           
            0xF3, 0xE0, 0x00, ##  0000  00000            
            0xF7, 0xC0, 0x00, ##  0000 00000             
            0xFF, 0xE0, 0x00, ##  00000000000            
            0xFF, 0xE0, 0x00, ##  00000000000            
            0xFF, 0xF0, 0x00, ##  000000000000           
            0xFC, 0xF8, 0x00, ##  000000  00000          
            0xF8, 0x78, 0x00, ##  00000    0000          
            0xF0, 0x7C, 0x00, ##  0000     00000         
            0xF0, 0x3E, 0x00, ##  0000      00000        
            0xF0, 0x1E, 0x00, ##  0000       0000        
            0xF0, 0x1F, 0x00, ##  0000       00000       
            0xF0, 0x0F, 0x80, ##  0000        00000      
            0xF0, 0x07, 0x80, ##  0000         0000      
            0xF0, 0x07, 0xC0, ##  0000         00000     
            0xF0, 0x03, 0xE0, ##  0000          00000    
            0xF0, 0x03, 0xE0, ##  0000          00000    
            0xF0, 0x01, 0xF0, ##  0000           00000   
            0xF0, 0x00, 0xF8, ##  0000            00000  
            0xF0, 0x00, 0xFC, ##  0000            000000 
            0xF0, 0x00, 0x7C, ##  0000             00000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 20, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0xFC, ##  000000          000000
            0xFC, 0x00, 0xFC, ##  000000          000000
            0xFE, 0x01, 0xFC, ##  0000000        0000000
            0xFE, 0x01, 0xFC, ##  0000000        0000000
            0xFE, 0x01, 0xFC, ##  0000000        0000000
            0xF7, 0x03, 0xBC, ##  0000 000      000 0000
            0xF7, 0x03, 0xBC, ##  0000 000      000 0000
            0xF7, 0x03, 0xBC, ##  0000 000      000 0000
            0xF3, 0x87, 0x3C, ##  0000  000    000  0000
            0xF3, 0x87, 0x3C, ##  0000  000    000  0000
            0xF3, 0x87, 0x3C, ##  0000  000    000  0000
            0xF1, 0xCE, 0x3C, ##  0000   000  000   0000
            0xF1, 0xCE, 0x3C, ##  0000   000  000   0000
            0xF1, 0xCE, 0x3C, ##  0000   000  000   0000
            0xF0, 0xFC, 0x3C, ##  0000    000000    0000
            0xF0, 0xFC, 0x3C, ##  0000    000000    0000
            0xF0, 0xFC, 0x3C, ##  0000    000000    0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0xF0, ##  000000          0000
            0xFC, 0x00, 0xF0, ##  000000          0000
            0xFC, 0x00, 0xF0, ##  000000          0000
            0xFE, 0x00, 0xF0, ##  0000000         0000
            0xFE, 0x00, 0xF0, ##  0000000         0000
            0xFF, 0x00, 0xF0, ##  00000000        0000
            0xFF, 0x00, 0xF0, ##  00000000        0000
            0xF7, 0x00, 0xF0, ##  0000 000        0000
            0xF7, 0x80, 0xF0, ##  0000 0000       0000
            0xF3, 0x80, 0xF0, ##  0000  000       0000
            0xF3, 0xC0, 0xF0, ##  0000  0000      0000
            0xF1, 0xC0, 0xF0, ##  0000   000      0000
            0xF1, 0xE0, 0xF0, ##  0000   0000     0000
            0xF1, 0xE0, 0xF0, ##  0000   0000     0000
            0xF0, 0xE0, 0xF0, ##  0000    000     0000
            0xF0, 0xF0, 0xF0, ##  0000    0000    0000
            0xF0, 0x70, 0xF0, ##  0000     000    0000
            0xF0, 0x78, 0xF0, ##  0000     0000   0000
            0xF0, 0x78, 0xF0, ##  0000     0000   0000
            0xF0, 0x38, 0xF0, ##  0000      000   0000
            0xF0, 0x3C, 0xF0, ##  0000      0000  0000
            0xF0, 0x1C, 0xF0, ##  0000       000  0000
            0xF0, 0x1E, 0xF0, ##  0000       0000 0000
            0xF0, 0x0E, 0xF0, ##  0000        000 0000
            0xF0, 0x0F, 0xF0, ##  0000        00000000
            0xF0, 0x0F, 0xF0, ##  0000        00000000
            0xF0, 0x07, 0xF0, ##  0000         0000000
            0xF0, 0x07, 0xF0, ##  0000         0000000
            0xF0, 0x03, 0xF0, ##  0000          000000
            0xF0, 0x03, 0xF0, ##  0000          000000
            0xF0, 0x03, 0xF0, ##  0000          000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x20, 0x00, ##            0          
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x7C, 0x01, 0xE0, ##   00000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFE, 0x00, ##        000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xF8, 0x00, ##  0000000000000       
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0xF0, 0x0F, 0xC0, ##  0000        000000  
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x0F, 0xC0, ##  0000        000000  
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xF8, 0x00, ##  0000000000000       
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x20, 0x00, ##            0          
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x3C, 0x01, 0xF0, ##    0000         00000 
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x1E, 0x03, 0xE0, ##     0000       00000  
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFF, 0x00, ##        0000000000     
            0x00, 0x1F, 0x00, ##             00000     
            0x00, 0x0F, 0xC0, ##              000000   
            0x00, 0x07, 0xE0, ##               000000  
            0x00, 0x03, 0xF0, ##                000000 
            0x00, 0x00, 0xC0, ##                  00   
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xF8, 0x00, ##  0000000000000         
            0xFF, 0xFE, 0x00, ##  000000000000000       
            0xFF, 0xFF, 0x00, ##  0000000000000000      
            0xF0, 0x0F, 0x80, ##  0000        00000     
            0xF0, 0x07, 0xC0, ##  0000         00000    
            0xF0, 0x03, 0xC0, ##  0000          0000    
            0xF0, 0x01, 0xE0, ##  0000           0000   
            0xF0, 0x01, 0xE0, ##  0000           0000   
            0xF0, 0x01, 0xE0, ##  0000           0000   
            0xF0, 0x01, 0xE0, ##  0000           0000   
            0xF0, 0x01, 0xE0, ##  0000           0000   
            0xF0, 0x01, 0xE0, ##  0000           0000   
            0xF0, 0x03, 0xC0, ##  0000          0000    
            0xF0, 0x07, 0xC0, ##  0000         00000    
            0xF0, 0x0F, 0x80, ##  0000        00000     
            0xFF, 0xFE, 0x00, ##  000000000000000       
            0xFF, 0xF8, 0x00, ##  0000000000000         
            0xFF, 0xFE, 0x00, ##  000000000000000       
            0xF0, 0x1F, 0x00, ##  0000       00000      
            0xF0, 0x0F, 0x80, ##  0000        00000     
            0xF0, 0x07, 0x80, ##  0000         0000     
            0xF0, 0x07, 0xC0, ##  0000         00000    
            0xF0, 0x03, 0xC0, ##  0000          0000    
            0xF0, 0x03, 0xE0, ##  0000          00000   
            0xF0, 0x01, 0xE0, ##  0000           0000   
            0xF0, 0x01, 0xF0, ##  0000           00000  
            0xF0, 0x00, 0xF0, ##  0000            0000  
            0xF0, 0x00, 0xF8, ##  0000            00000 
            0xF0, 0x00, 0x78, ##  0000             0000 
            0xF0, 0x00, 0x7C, ##  0000             00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFF, 0x80, ##       000000000000   
            0x1F, 0xFF, 0xC0, ##     000000000000000  
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x7C, 0x01, 0xC0, ##   00000         000  
            0x78, 0x00, 0x40, ##   0000            0  
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF8, 0x00, 0x00, ##  00000               
            0xFC, 0x00, 0x00, ##  000000              
            0x7F, 0x80, 0x00, ##   00000000           
            0x7F, 0xF8, 0x00, ##   000000000000       
            0x3F, 0xFE, 0x00, ##    0000000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x03, 0xFF, 0xC0, ##        000000000000  
            0x00, 0x3F, 0xE0, ##            000000000 
            0x00, 0x07, 0xE0, ##               000000 
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x01, 0xF0, ##                 00000
            0xC0, 0x01, 0xE0, ##  00             0000 
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0x3F, 0xFE, 0x00, ##    0000000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x70, 0x00, 0xE0, ##   000            000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3E, 0x00, 0x78, ##    00000          0000   
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1E, 0x00, 0xF8, ##     0000         00000   
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x07, 0x01, 0xE0, ##       000       0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x01, 0xC3, 0x80, ##         000    000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x00, ##         0000  000        
            0x00, 0xE7, 0x00, ##          000  000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 26, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x07, 0xC0, ##  0000                 00000
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x3E, 0x07, 0x00, ##   0000     00000      000  
            0x38, 0x3F, 0x0F, 0x00, ##    000     000000    0000  
            0x3C, 0x3F, 0x0F, 0x00, ##    0000    000000    0000  
            0x3C, 0x3F, 0x0F, 0x00, ##    0000    000000    0000  
            0x3C, 0x3F, 0x0F, 0x00, ##    0000    000000    0000  
            0x3C, 0x7F, 0x0F, 0x00, ##    0000   0000000    0000  
            0x3C, 0x73, 0x8F, 0x00, ##    0000   000  000   0000  
            0x3C, 0x73, 0x8E, 0x00, ##    0000   000  000   000   
            0x1C, 0x73, 0x8E, 0x00, ##     000   000  000   000   
            0x1C, 0x73, 0x8E, 0x00, ##     000   000  000   000   
            0x1C, 0xE1, 0xDE, 0x00, ##     000  000    000 0000   
            0x1E, 0xE1, 0xDE, 0x00, ##     0000 000    000 0000   
            0x1E, 0xE1, 0xDE, 0x00, ##     0000 000    000 0000   
            0x1E, 0xE1, 0xDE, 0x00, ##     0000 000    000 0000   
            0x0F, 0xC1, 0xDC, 0x00, ##      000000     000 000    
            0x0F, 0xC0, 0xFC, 0x00, ##      000000      000000    
            0x0F, 0xC0, 0xFC, 0x00, ##      000000      000000    
            0x0F, 0xC0, 0xFC, 0x00, ##      000000      000000    
            0x0F, 0xC0, 0xFC, 0x00, ##      000000      000000    
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000    
            0x0F, 0x80, 0x78, 0x00, ##      00000        0000     
            0x07, 0x80, 0x78, 0x00, ##       0000        0000     
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 25, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x3E, 0x00, 0x0F, 0x00, ##    00000             0000 
            0x1E, 0x00, 0x1F, 0x00, ##     0000            00000 
            0x1F, 0x00, 0x1E, 0x00, ##     00000           0000  
            0x0F, 0x00, 0x3E, 0x00, ##      0000          00000  
            0x07, 0x80, 0x3C, 0x00, ##       0000         0000   
            0x07, 0xC0, 0x78, 0x00, ##       00000       0000    
            0x03, 0xC0, 0xF8, 0x00, ##        0000      00000    
            0x03, 0xE0, 0xF0, 0x00, ##        00000     0000     
            0x01, 0xE1, 0xE0, 0x00, ##         0000    0000      
            0x00, 0xF1, 0xE0, 0x00, ##          0000   0000      
            0x00, 0xFB, 0xC0, 0x00, ##          00000 0000       
            0x00, 0x7F, 0x80, 0x00, ##           00000000        
            0x00, 0x3F, 0x80, 0x00, ##            0000000        
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x80, 0x00, ##            0000000        
            0x00, 0x7F, 0x80, 0x00, ##           00000000        
            0x00, 0xFB, 0xC0, 0x00, ##          00000 0000       
            0x00, 0xF3, 0xC0, 0x00, ##          0000  0000       
            0x01, 0xE1, 0xE0, 0x00, ##         0000    0000      
            0x03, 0xE1, 0xF0, 0x00, ##        00000    00000     
            0x03, 0xC0, 0xF0, 0x00, ##        0000      0000     
            0x07, 0xC0, 0x78, 0x00, ##       00000       0000    
            0x07, 0x80, 0x7C, 0x00, ##       0000        00000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x1F, 0x00, 0x3E, 0x00, ##     00000          00000  
            0x1E, 0x00, 0x1E, 0x00, ##     0000            0000  
            0x3E, 0x00, 0x0F, 0x00, ##    00000             0000 
            0x7C, 0x00, 0x0F, 0x80, ##   00000              00000
            0x78, 0x00, 0x07, 0x80, ##   0000                0000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xF8, ##   00000000000000000000
            0x7F, 0xFF, 0xF8, ##   00000000000000000000
            0x7F, 0xFF, 0xF8, ##   00000000000000000000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x01, 0xF0, ##                 00000 
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x03, 0xE0, ##                00000  
            0x00, 0x07, 0xC0, ##               00000   
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x0F, 0x80, ##              00000    
            0x00, 0x1F, 0x00, ##             00000     
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x3E, 0x00, ##            00000      
            0x00, 0x7C, 0x00, ##           00000       
            0x00, 0x7C, 0x00, ##           00000       
            0x00, 0xF8, 0x00, ##          00000        
            0x00, 0xF0, 0x00, ##          0000         
            0x01, 0xF0, 0x00, ##         00000         
            0x03, 0xE0, 0x00, ##        00000          
            0x03, 0xC0, 0x00, ##        0000           
            0x07, 0xC0, 0x00, ##       00000           
            0x0F, 0x80, 0x00, ##      00000            
            0x0F, 0x00, 0x00, ##      0000             
            0x1F, 0x00, 0x00, ##     00000             
            0x3E, 0x00, 0x00, ##    00000              
            0x3E, 0x00, 0x00, ##    00000              
            0x7C, 0x00, 0x00, ##   00000               
            0xF8, 0x00, 0x00, ##  00000                
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 9, 
        'xoffset'  => 10, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                 
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0x3C, 0x00, 0x00, ##    0000               
            0x3C, 0x00, 0x00, ##    0000               
            0x1E, 0x00, 0x00, ##     0000              
            0x1E, 0x00, 0x00, ##     0000              
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x03, 0xC0, 0x00, ##        0000           
            0x03, 0xC0, 0x00, ##        0000           
            0x01, 0xE0, 0x00, ##         0000          
            0x01, 0xE0, 0x00, ##         0000          
            0x01, 0xE0, 0x00, ##         0000          
            0x00, 0xF0, 0x00, ##          0000         
            0x00, 0xF0, 0x00, ##          0000         
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x03, 0xC0, ##                0000   
            0x00, 0x03, 0xC0, ##                0000   
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 9, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xFC, 0x00, ##          000000        
            0x01, 0xFC, 0x00, ##         0000000        
            0x01, 0xFE, 0x00, ##         00000000       
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x07, 0x87, 0x80, ##       0000    0000     
            0x0F, 0x07, 0xC0, ##      0000     00000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xE0, ##    00000        0000   
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF0, 0x00, 0x3C, ##  0000              0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 10, 
        'xoffset'  => 6, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000      
            0x78, 0x00, ##   0000     
            0x3C, 0x00, ##    0000    
            0x1E, 0x00, ##     0000   
            0x0E, 0x00, ##      000   
            0x07, 0x00, ##       000  
            0x07, 0x80, ##       0000 
            0x03, 0xC0, ##        0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x3F, 0xFF, 0x00, ##    00000000000000   
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x30, 0x07, 0xC0, ##    00         00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7E, 0x01, 0xE0, ##   000000        0000
            0x78, 0x01, 0xE0, ##   0000          0000
            0xF8, 0x01, 0xE0, ##  00000          0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF8, 0x07, 0xE0, ##  00000        000000
            0x78, 0x0F, 0xE0, ##   0000       0000000
            0x7F, 0xFD, 0xE0, ##   0000000000000 0000
            0x3F, 0xFD, 0xE0, ##    000000000000 0000
            0x1F, 0xF1, 0xE0, ##     000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF3, 0xFC, 0x00, ##  0000  00000000     
            0xF7, 0xFF, 0x00, ##  0000 00000000000   
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0xFE, 0x0F, 0x80, ##  0000000     00000  
            0xFC, 0x07, 0xC0, ##  000000       00000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xFC, 0x07, 0xC0, ##  000000       00000 
            0xFC, 0x07, 0x80, ##  000000       0000  
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0xF7, 0xFF, 0x00, ##  0000 00000000000   
            0xF3, 0xFC, 0x00, ##  0000  00000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                    
            0x03, 0xFF, 0x80, ##        00000000000 
            0x0F, 0xFF, 0xC0, ##      00000000000000
            0x1F, 0xFF, 0xC0, ##     000000000000000
            0x3F, 0x00, 0xC0, ##    000000        00
            0x3C, 0x00, 0x40, ##    0000           0
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0xF8, 0x00, 0x00, ##  00000             
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF8, 0x00, 0x00, ##  00000             
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0x3C, 0x00, 0x40, ##    0000           0
            0x3E, 0x00, 0xC0, ##    00000         00
            0x1F, 0xFF, 0xC0, ##     000000000000000
            0x0F, 0xFF, 0xC0, ##      00000000000000
            0x03, 0xFF, 0x80, ##        00000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x07, 0xF9, 0xE0, ##       00000000  0000
            0x1F, 0xFD, 0xE0, ##     00000000000 0000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3C, 0x0F, 0xE0, ##    0000      0000000
            0x7C, 0x07, 0xE0, ##   00000       000000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x78, 0x03, 0xE0, ##   0000         00000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x7C, 0x07, 0xE0, ##   00000       000000
            0x3C, 0x0F, 0xE0, ##    0000      0000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x1F, 0xFD, 0xE0, ##     00000000000 0000
            0x07, 0xF9, 0xE0, ##       00000000  0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0x78, ##   0000            0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0x3C, 0x00, 0x10, ##    0000             0 
            0x3F, 0x00, 0x70, ##    000000         000 
            0x1F, 0xFF, 0xF0, ##     00000000000000000 
            0x0F, 0xFF, 0xF0, ##      0000000000000000 
            0x03, 0xFF, 0xC0, ##        000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0xFF, 0xC0, ##          0000000000
            0x01, 0xFF, 0xC0, ##         00000000000
            0x01, 0xE0, 0x00, ##         0000       
            0x03, 0xE0, 0x00, ##        00000       
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0x07, 0xF9, 0xE0, ##       00000000  0000
            0x1F, 0xFD, 0xE0, ##     00000000000 0000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3E, 0x07, 0xE0, ##    00000      000000
            0x7C, 0x07, 0xE0, ##   00000       000000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x78, 0x03, 0xE0, ##   0000         00000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x3C, 0x07, 0xE0, ##    0000       000000
            0x3E, 0x0F, 0xE0, ##    00000     0000000
            0x1F, 0xFD, 0xE0, ##     00000000000 0000
            0x0F, 0xF9, 0xE0, ##      000000000  0000
            0x03, 0xF1, 0xE0, ##        000000   0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x07, 0xC0, ##               00000 
            0x1C, 0x0F, 0x80, ##     000      00000  
            0x1F, 0xFF, 0x00, ##     0000000000000   
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x07, 0xF8, 0x00, ##       00000000      
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF1, 0xFE, 0x00, ##  0000   00000000   
            0xF7, 0xFF, 0x00, ##  0000 00000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFC, 0x0F, 0x80, ##  000000      00000 
            0xF8, 0x07, 0x80, ##  00000        0000 
            0xF8, 0x03, 0xC0, ##  00000         0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 12, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x7F, 0xF0, ##   00000000000
            0x7F, 0xF0, ##   00000000000
            0x7F, 0xF0, ##   00000000000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x01, 0xE0, ##         0000 
            0x03, 0xE0, ##        00000 
            0xFF, 0xC0, ##  0000000000  
            0xFF, 0x80, ##  000000000   
            0xFF, 0x00, ##  00000000    
            0x00, 0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 20, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x07, 0x80, ##  0000         0000   
            0xF0, 0x1F, 0x00, ##  0000       00000    
            0xF0, 0x3E, 0x00, ##  0000      00000     
            0xF0, 0x7C, 0x00, ##  0000     00000      
            0xF0, 0xF8, 0x00, ##  0000    00000       
            0xF1, 0xF0, 0x00, ##  0000   00000        
            0xF3, 0xE0, 0x00, ##  0000  00000         
            0xF7, 0xC0, 0x00, ##  0000 00000          
            0xFF, 0xC0, 0x00, ##  0000000000          
            0xFF, 0xE0, 0x00, ##  00000000000         
            0xFD, 0xF0, 0x00, ##  000000 00000        
            0xF8, 0xF0, 0x00, ##  00000   0000        
            0xF0, 0x78, 0x00, ##  0000     0000       
            0xF0, 0x7C, 0x00, ##  0000     00000      
            0xF0, 0x3E, 0x00, ##  0000      00000     
            0xF0, 0x1E, 0x00, ##  0000       0000     
            0xF0, 0x0F, 0x00, ##  0000        0000    
            0xF0, 0x0F, 0x80, ##  0000        00000   
            0xF0, 0x07, 0xC0, ##  0000         00000  
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x01, 0xF0, ##  0000           00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xC0, 0x00, ##  0000000000        
            0xFF, 0xC0, 0x00, ##  0000000000        
            0xFF, 0xC0, 0x00, ##  0000000000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x03, 0xC0, 0x00, ##        0000        
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xF0, 0x00, ##         00000      
            0x00, 0xFF, 0xC0, ##          0000000000
            0x00, 0x7F, 0xC0, ##           000000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0xF7, 0xE3, 0xF0, ##  0000 000000   000000  
            0xFF, 0xF7, 0xF8, ##  000000000000 00000000 
            0xFF, 0xFF, 0xF8, ##  000000000000000000000 
            0xF8, 0xFC, 0x78, ##  00000   000000   0000 
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0xF0, 0x78, 0x3C, ##  0000     0000     0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                    
            0xF1, 0xFE, 0x00, ##  0000   00000000   
            0xF7, 0xFF, 0x00, ##  0000 00000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFC, 0x0F, 0x80, ##  000000      00000 
            0xF8, 0x07, 0x80, ##  00000        0000 
            0xF8, 0x03, 0xC0, ##  00000         0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0xF3, 0xFC, 0x00, ##  0000  00000000     
            0xF7, 0xFF, 0x00, ##  0000 00000000000   
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0xFE, 0x0F, 0x80, ##  0000000     00000  
            0xFC, 0x07, 0xC0, ##  000000       00000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xFC, 0x07, 0xC0, ##  000000       00000 
            0xFC, 0x07, 0x80, ##  000000       0000  
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xF7, 0xFF, 0x00, ##  0000 00000000000   
            0xF3, 0xFC, 0x00, ##  0000  00000000     
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0x07, 0xF9, 0xE0, ##       00000000  0000
            0x1F, 0xFD, 0xE0, ##     00000000000 0000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3E, 0x0F, 0xE0, ##    00000     0000000
            0x7C, 0x07, 0xE0, ##   00000       000000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x78, 0x03, 0xE0, ##   0000         00000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x78, 0x03, 0xE0, ##   0000         00000
            0x7C, 0x07, 0xE0, ##   00000       000000
            0x3C, 0x0F, 0xE0, ##    0000      0000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x1F, 0xFD, 0xE0, ##     00000000000 0000
            0x07, 0xF9, 0xE0, ##       00000000  0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 17, 
        'xoffset'  => 8, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                   
            0xF1, 0xFF, 0x00, ##  0000   000000000 
            0xF3, 0xFF, 0x80, ##  0000  00000000000
            0xF7, 0xFF, 0x80, ##  0000 000000000000
            0xFE, 0x01, 0x80, ##  0000000        00
            0xFC, 0x00, 0x00, ##  000000           
            0xF8, 0x00, 0x00, ##  00000            
            0xF8, 0x00, 0x00, ##  00000            
            0xF8, 0x00, 0x00, ##  00000            
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 17, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                   
            0x0F, 0xFE, 0x00, ##      00000000000  
            0x3F, 0xFF, 0x00, ##    00000000000000 
            0x7F, 0xFF, 0x00, ##   000000000000000 
            0x78, 0x03, 0x00, ##   0000         00 
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xFC, 0x00, 0x00, ##  000000           
            0x7F, 0x80, 0x00, ##   00000000        
            0x7F, 0xF8, 0x00, ##   000000000000    
            0x1F, 0xFE, 0x00, ##     000000000000  
            0x03, 0xFF, 0x00, ##        0000000000 
            0x00, 0x3F, 0x00, ##            000000 
            0x00, 0x0F, 0x80, ##              00000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x0F, 0x80, ##              00000
            0xE0, 0x0F, 0x00, ##  000         0000 
            0xFF, 0xFF, 0x00, ##  0000000000000000 
            0xFF, 0xFE, 0x00, ##  000000000000000  
            0x7F, 0xF8, 0x00, ##   000000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xC0, 0x00, ##        0000         
            0x03, 0xE0, 0x00, ##        00000        
            0x01, 0xF0, 0x00, ##         00000       
            0x01, 0xFF, 0xE0, ##         000000000000
            0x00, 0xFF, 0xE0, ##          00000000000
            0x00, 0x3F, 0xE0, ##            000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x07, 0xC0, ##  0000         00000
            0xF8, 0x07, 0xC0, ##  00000        00000
            0x7C, 0x0F, 0xC0, ##   00000      000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x3F, 0xFB, 0xC0, ##    00000000000 0000
            0x1F, 0xE3, 0xC0, ##     00000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x3C, ##  0000              0000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3C, 0x01, 0xE0, ##    0000         0000   
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x0E, 0x03, 0xC0, ##      000       0000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x03, 0xCE, 0x00, ##        0000  000       
            0x01, 0xFE, 0x00, ##         00000000       
            0x01, 0xFE, 0x00, ##         00000000       
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 26, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0x70, 0x00, 0x07, 0x80, ##   000                 0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x38, 0x00, 0x07, 0x00, ##    000                000  
            0x38, 0x1E, 0x0F, 0x00, ##    000      0000     0000  
            0x3C, 0x1E, 0x0F, 0x00, ##    0000     0000     0000  
            0x3C, 0x3E, 0x0F, 0x00, ##    0000    00000     0000  
            0x1C, 0x3F, 0x0E, 0x00, ##     000    000000    000   
            0x1C, 0x3F, 0x0E, 0x00, ##     000    000000    000   
            0x1E, 0x33, 0x1E, 0x00, ##     0000   00  00   0000   
            0x1E, 0x73, 0x9E, 0x00, ##     0000  000  000  0000   
            0x1E, 0x73, 0x9C, 0x00, ##     0000  000  000  000    
            0x0E, 0x63, 0x9C, 0x00, ##      000  00   000  000    
            0x0E, 0xE1, 0xBC, 0x00, ##      000 000    00 0000    
            0x0F, 0xE1, 0xFC, 0x00, ##      0000000    0000000    
            0x0F, 0xE1, 0xF8, 0x00, ##      0000000    000000     
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x07, 0x80, 0x78, 0x00, ##       0000        0000     
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0xCF, 0x00, ##       00000  0000      
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x01, 0xFE, 0x00, ##         00000000       
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xFC, 0x00, ##          000000        
            0x01, 0xFE, 0x00, ##         00000000       
            0x03, 0xDF, 0x00, ##        0000 00000      
            0x07, 0xCF, 0x80, ##       00000  00000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x1E, 0x03, 0xE0, ##     0000       00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF0, 0x00, 0x7C, ##  0000             00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0x78, ##    0000           0000 
            0x3C, 0x00, 0x78, ##    0000           0000 
            0x1E, 0x00, 0xF0, ##     0000         0000  
            0x1E, 0x00, 0xF0, ##     0000         0000  
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x0F, 0x01, 0xE0, ##      0000       0000   
            0x0F, 0x01, 0xE0, ##      0000       0000   
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0x83, 0xC0, ##       0000     0000    
            0x07, 0x83, 0x80, ##       0000     000     
            0x03, 0xC7, 0x80, ##        0000   0000     
            0x03, 0xC7, 0x80, ##        0000   0000     
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x01, 0xEF, 0x00, ##         0000 0000      
            0x01, 0xEE, 0x00, ##         0000 000       
            0x00, 0xFE, 0x00, ##          0000000       
            0x00, 0xFE, 0x00, ##          0000000       
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0xF0, 0x00, ##          0000          
            0x01, 0xF0, 0x00, ##         00000          
            0x03, 0xE0, 0x00, ##        00000           
            0x3F, 0xC0, 0x00, ##    00000000            
            0x3F, 0x80, 0x00, ##    0000000             
            0x3F, 0x00, 0x00, ##    000000              
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x00, 0x03, 0xC0, ##                0000
            0x00, 0x07, 0x80, ##               0000 
            0x00, 0x0F, 0x00, ##              0000  
            0x00, 0x1F, 0x00, ##             00000  
            0x00, 0x3E, 0x00, ##            00000   
            0x00, 0x7C, 0x00, ##           00000    
            0x00, 0xF8, 0x00, ##          00000     
            0x00, 0xF0, 0x00, ##          0000      
            0x01, 0xE0, 0x00, ##         0000       
            0x03, 0xE0, 0x00, ##        00000       
            0x07, 0xC0, 0x00, ##       00000        
            0x0F, 0x80, 0x00, ##      00000         
            0x1F, 0x00, 0x00, ##     00000          
            0x1E, 0x00, 0x00, ##     0000           
            0x3E, 0x00, 0x00, ##    00000           
            0x7C, 0x00, 0x00, ##   00000            
            0xF8, 0x00, 0x00, ##  00000             
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 16, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x3F, ##            000000
            0x00, 0xFF, ##          00000000
            0x01, 0xFF, ##         000000000
            0x01, 0xE0, ##         0000     
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x07, 0xC0, ##       00000      
            0x0F, 0x80, ##      00000       
            0xFF, 0x00, ##  00000000        
            0xFC, 0x00, ##  000000          
            0xFF, 0x00, ##  00000000        
            0x0F, 0x80, ##      00000       
            0x07, 0x80, ##       0000       
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x01, 0xE0, ##         0000     
            0x01, 0xFF, ##         000000000
            0x00, 0xFF, ##          00000000
            0x00, 0x3F, ##            000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 4, 
        'xoffset'  => 11, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 17, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, ##  000000           
            0xFF, 0x00, 0x00, ##  00000000         
            0xFF, 0x80, 0x00, ##  000000000        
            0x07, 0x80, 0x00, ##       0000        
            0x07, 0xC0, 0x00, ##       00000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xE0, 0x00, ##        00000      
            0x01, 0xF0, 0x00, ##         00000     
            0x00, 0xFF, 0x80, ##          000000000
            0x00, 0x3F, 0x80, ##            0000000
            0x00, 0xFF, 0x80, ##          000000000
            0x01, 0xF0, 0x00, ##         00000     
            0x01, 0xE0, 0x00, ##         0000      
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x07, 0xC0, 0x00, ##       00000       
            0x07, 0x80, 0x00, ##       0000        
            0xFF, 0x80, 0x00, ##  000000000        
            0xFF, 0x00, 0x00, ##  00000000         
            0xFC, 0x00, 0x00, ##  000000           
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x80, 0x04, ##      00000            0
            0x3F, 0xE0, 0x0C, ##    000000000         00
            0xFF, 0xFC, 0x1C, ##  00000000000000     000
            0xF0, 0x7F, 0xFC, ##  0000     0000000000000
            0xC0, 0x1F, 0xF0, ##  00         000000000  
            0x80, 0x07, 0xE0, ##  0            000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 4, 
        'xoffset'  => 11, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x03, 0xFF, 0x80, ##        00000000000 
            0x0F, 0xFF, 0xC0, ##      00000000000000
            0x1F, 0xFF, 0xC0, ##     000000000000000
            0x3E, 0x30, 0xC0, ##    00000   00    00
            0x3C, 0x30, 0x00, ##    0000    00      
            0x78, 0x30, 0x00, ##   0000     00      
            0x78, 0x30, 0x00, ##   0000     00      
            0xF8, 0x30, 0x00, ##  00000     00      
            0xF0, 0x30, 0x00, ##  0000      00      
            0xF0, 0x30, 0x00, ##  0000      00      
            0xF0, 0x30, 0x00, ##  0000      00      
            0xF0, 0x30, 0x00, ##  0000      00      
            0xF0, 0x30, 0x00, ##  0000      00      
            0xF0, 0x30, 0x00, ##  0000      00      
            0xF0, 0x30, 0x00, ##  0000      00      
            0xF8, 0x30, 0x00, ##  00000     00      
            0x78, 0x30, 0x00, ##   0000     00      
            0x7C, 0x30, 0x00, ##   00000    00      
            0x3C, 0x30, 0x00, ##    0000    00      
            0x3E, 0x30, 0xC0, ##    00000   00    00
            0x1F, 0xFF, 0xC0, ##     000000000000000
            0x0F, 0xFF, 0xC0, ##      00000000000000
            0x03, 0xFF, 0x80, ##        00000000000 
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x00, 0x7F, 0xE0, ##           0000000000 
            0x00, 0xFF, 0xF0, ##          000000000000
            0x01, 0xFF, 0xF0, ##         0000000000000
            0x03, 0xE0, 0x30, ##        00000       00
            0x03, 0xC0, 0x00, ##        0000          
            0x03, 0xC0, 0x00, ##        0000          
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x7F, 0xFF, 0x80, ##   0000000000000000   
            0x7F, 0xFF, 0x80, ##   0000000000000000   
            0x7F, 0xFF, 0x80, ##   0000000000000000   
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 18, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x60, 0x00, 0x80, ##   00             0 
            0xF0, 0x01, 0xC0, ##  0000           000
            0x79, 0xF3, 0x80, ##   0000  00000  000 
            0x7F, 0xFF, 0x80, ##   0000000000000000 
            0x3F, 0xFF, 0x00, ##    00000000000000  
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x1C, 0x0E, 0x00, ##     000      000   
            0x38, 0x07, 0x00, ##    000        000  
            0x38, 0x07, 0x00, ##    000        000  
            0x38, 0x07, 0x00, ##    000        000  
            0x38, 0x07, 0x00, ##    000        000  
            0x1C, 0x0E, 0x00, ##     000      000   
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x3F, 0xFF, 0x00, ##    00000000000000  
            0x3F, 0xFF, 0x80, ##    000000000000000 
            0x79, 0xE7, 0xC0, ##   0000  0000  00000
            0xE0, 0x01, 0xC0, ##  000            000
            0x40, 0x00, 0x80, ##   0              0 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 25, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x78, 0x00, 0x0F, 0x00, ##   0000               0000 
            0x7C, 0x00, 0x1F, 0x00, ##   00000             00000 
            0x3E, 0x00, 0x1E, 0x00, ##    00000            0000  
            0x1E, 0x00, 0x3E, 0x00, ##     0000           00000  
            0x1F, 0x00, 0x3C, 0x00, ##     00000          0000   
            0x0F, 0x00, 0x78, 0x00, ##      0000         0000    
            0x07, 0x80, 0x78, 0x00, ##       0000        0000    
            0x07, 0x80, 0xF0, 0x00, ##       0000       0000     
            0x03, 0xC0, 0xF0, 0x00, ##        0000      0000     
            0x01, 0xE1, 0xE0, 0x00, ##         0000    0000      
            0x01, 0xE1, 0xC0, 0x00, ##         0000    000       
            0x3F, 0xF3, 0xFE, 0x00, ##    0000000000  000000000  
            0x3F, 0xF3, 0xFE, 0x00, ##    0000000000  000000000  
            0x3F, 0xFF, 0xFE, 0x00, ##    000000000000000000000  
            0x00, 0x7F, 0x00, 0x00, ##           0000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x3F, 0xFF, 0xFE, 0x00, ##    000000000000000000000  
            0x3F, 0xFF, 0xFE, 0x00, ##    000000000000000000000  
            0x3F, 0xFF, 0xFE, 0x00, ##    000000000000000000000  
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x1E, 0x00, 0x00, ##             0000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 4, 
        'xoffset'  => 11, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                    
            0x0F, 0xFE, 0x00, ##      00000000000   
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x3F, 0xFE, 0x00, ##    0000000000000   
            0x7C, 0x02, 0x00, ##   00000        0   
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0x7C, 0x00, 0x00, ##   00000            
            0x3E, 0x00, 0x00, ##    00000           
            0x1F, 0x80, 0x00, ##     000000         
            0x0F, 0xE0, 0x00, ##      0000000       
            0x3F, 0xF8, 0x00, ##    00000000000     
            0x78, 0xFC, 0x00, ##   0000   000000    
            0x78, 0x3F, 0x00, ##   0000     000000  
            0xF0, 0x1F, 0x80, ##  0000       000000 
            0xF0, 0x0F, 0x80, ##  0000        00000 
            0xF0, 0x07, 0xC0, ##  0000         00000
            0xF8, 0x03, 0xC0, ##  00000         0000
            0x7C, 0x03, 0xC0, ##   00000        0000
            0x7E, 0x03, 0xC0, ##   000000       0000
            0x3F, 0x07, 0x80, ##    000000     0000 
            0x1F, 0xCF, 0x80, ##     0000000  00000 
            0x07, 0xFF, 0x00, ##       00000000000  
            0x01, 0xFC, 0x00, ##         0000000    
            0x00, 0xFC, 0x00, ##          000000    
            0x00, 0x3E, 0x00, ##            00000   
            0x00, 0x1F, 0x00, ##             00000  
            0x00, 0x0F, 0x00, ##              0000  
            0x00, 0x0F, 0x00, ##              0000  
            0x00, 0x0F, 0x00, ##              0000  
            0x40, 0x1F, 0x00, ##   0         00000  
            0x70, 0x3E, 0x00, ##   000      00000   
            0x7F, 0xFE, 0x00, ##   00000000000000   
            0x7F, 0xFC, 0x00, ##   0000000000000    
            0x0F, 0xF0, 0x00, ##      00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 12, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 26, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x01, 0xFF, 0xE0, 0x00, ##         000000000000       
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x0E, 0x00, 0x1C, 0x00, ##      000            000    
            0x1C, 0x00, 0x0E, 0x00, ##     000              000   
            0x38, 0x3F, 0x87, 0x00, ##    000     0000000    000  
            0x30, 0xFF, 0xC3, 0x00, ##    00    0000000000    00  
            0x61, 0xE0, 0xC1, 0x80, ##   00    0000     00     00 
            0x63, 0xC0, 0x01, 0x80, ##   00   0000             00 
            0xE3, 0x80, 0x01, 0xC0, ##  000   000              000
            0xC7, 0x00, 0x00, 0xC0, ##  00   000                00
            0xC7, 0x00, 0x00, 0xC0, ##  00   000                00
            0xC7, 0x00, 0x00, 0xC0, ##  00   000                00
            0xC7, 0x00, 0x00, 0xC0, ##  00   000                00
            0xC7, 0x00, 0x00, 0xC0, ##  00   000                00
            0xC7, 0x00, 0x00, 0xC0, ##  00   000                00
            0xE3, 0x80, 0x01, 0xC0, ##  000   000              000
            0x63, 0xC0, 0x01, 0x80, ##   00   0000             00 
            0x61, 0xE0, 0x41, 0x80, ##   00    0000      0     00 
            0x30, 0xFF, 0xC3, 0x00, ##    00    0000000000    00  
            0x38, 0x3F, 0x87, 0x00, ##    000     0000000    000  
            0x1C, 0x00, 0x0E, 0x00, ##     000              000   
            0x0E, 0x00, 0x1C, 0x00, ##      000            000    
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x01, 0xFF, 0xE0, 0x00, ##         000000000000       
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 14, 
        'xoffset'  => 6, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xC0, ##     0000000    
            0x7F, 0xF0, ##   00000000000  
            0x60, 0x78, ##   00      0000 
            0x00, 0x38, ##            000 
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x0F, 0xFC, ##      0000000000
            0x3F, 0xFC, ##    000000000000
            0x78, 0x1C, ##   0000      000
            0xF0, 0x1C, ##  0000       000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x3C, ##  000       0000
            0xE0, 0x7C, ##  000      00000
            0x70, 0xFC, ##   000    000000
            0x7F, 0xDC, ##   000000000 000
            0x1F, 0x1C, ##     00000   000
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 20, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x40, 0x10, ##           0         0
            0x00, 0xC0, 0x30, ##          00        00
            0x01, 0xC0, 0xF0, ##         000      0000
            0x03, 0xC1, 0xF0, ##        0000     00000
            0x07, 0x83, 0xE0, ##       0000     00000 
            0x0F, 0x07, 0xC0, ##      0000     00000  
            0x3E, 0x0F, 0x80, ##    00000     00000   
            0x7C, 0x1E, 0x00, ##   00000     0000     
            0xF8, 0x3C, 0x00, ##  00000     0000      
            0xF0, 0x78, 0x00, ##  0000     0000       
            0xF8, 0x3C, 0x00, ##  00000     0000      
            0x7C, 0x1F, 0x00, ##   00000     00000    
            0x1E, 0x0F, 0x80, ##     0000     00000   
            0x0F, 0x07, 0xC0, ##      0000     00000  
            0x07, 0x83, 0xE0, ##       0000     00000 
            0x03, 0xC1, 0xF0, ##        0000     00000
            0x01, 0xC0, 0x70, ##         000       000
            0x00, 0xC0, 0x30, ##          00        00
            0x00, 0x40, 0x10, ##           0         0
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 11, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 26, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x01, 0xFF, 0xE0, 0x00, ##         000000000000       
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x0E, 0x00, 0x1C, 0x00, ##      000            000    
            0x1C, 0x00, 0x0E, 0x00, ##     000              000   
            0x39, 0xFF, 0x07, 0x00, ##    000  000000000     000  
            0x31, 0xFF, 0xC3, 0x00, ##    00   00000000000    00  
            0x61, 0xC1, 0xE1, 0x80, ##   00    000     0000    00 
            0x61, 0xC0, 0xE1, 0x80, ##   00    000      000    00 
            0xE1, 0xC0, 0xE1, 0xC0, ##  000    000      000    000
            0xC1, 0xC0, 0xE0, 0xC0, ##  00     000      000     00
            0xC1, 0xC0, 0xE0, 0xC0, ##  00     000      000     00
            0xC1, 0xC1, 0xC0, 0xC0, ##  00     000     000      00
            0xC1, 0xFF, 0x00, 0xC0, ##  00     000000000        00
            0xC1, 0xC7, 0x00, 0xC0, ##  00     000   000        00
            0xC1, 0xC3, 0x80, 0xC0, ##  00     000    000       00
            0xE1, 0xC1, 0xC1, 0xC0, ##  000    000     000     000
            0x61, 0xC1, 0xC1, 0x80, ##   00    000     000     00 
            0x61, 0xC0, 0xE1, 0x80, ##   00    000      000    00 
            0x31, 0xC0, 0x73, 0x00, ##    00   000       000  00  
            0x38, 0x00, 0x07, 0x00, ##    000                000  
            0x1C, 0x00, 0x0E, 0x00, ##     000              000   
            0x0E, 0x00, 0x1C, 0x00, ##      000            000    
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x01, 0xFF, 0xE0, 0x00, ##         000000000000       
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 13, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 13, 
        'xoffset'  => 6, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000    
            0x3F, 0xE0, ##    000000000  
            0x7F, 0xF0, ##   00000000000 
            0x78, 0xF0, ##   0000   0000 
            0xF0, 0x78, ##  0000     0000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xF0, 0x78, ##  0000     0000
            0x78, 0xF0, ##   0000   0000 
            0x7F, 0xF0, ##   00000000000 
            0x3F, 0xE0, ##    000000000  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 12, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000    
            0xFF, 0xC0, ##  0000000000  
            0xC1, 0xE0, ##  00     0000 
            0x00, 0xF0, ##          0000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x01, 0xE0, ##         0000 
            0x03, 0xC0, ##        0000  
            0x03, 0x80, ##        000   
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x1C, 0x00, ##     000      
            0x38, 0x00, ##    000       
            0x70, 0x00, ##   000        
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 13, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0x80, ##   00000000    
            0x7F, 0xE0, ##   0000000000  
            0x40, 0xE0, ##   0      000  
            0x00, 0x70, ##           000 
            0x00, 0x70, ##           000 
            0x00, 0x70, ##           000 
            0x00, 0xE0, ##          000  
            0x1F, 0xC0, ##     0000000   
            0x1F, 0x80, ##     000000    
            0x00, 0xE0, ##          000  
            0x00, 0x70, ##           000 
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x78, ##           0000
            0xC0, 0xF0, ##  00      0000 
            0xFF, 0xE0, ##  00000000000  
            0x7F, 0x80, ##   00000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 10, 
        'xoffset'  => 10, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000
            0x07, 0x80, ##       0000 
            0x0F, 0x00, ##      0000  
            0x1E, 0x00, ##     0000   
            0x1C, 0x00, ##     000    
            0x38, 0x00, ##    000     
            0x78, 0x00, ##   0000     
            0xF0, 0x00, ##  0000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x03, 0xC0, ##  0000          0000   
            0xF0, 0x07, 0xC0, ##  0000         00000   
            0xF8, 0x07, 0xC0, ##  00000        00000   
            0xFC, 0x0F, 0xC0, ##  000000      000000   
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFD, 0xF8, ##  00000000000000 000000
            0xF7, 0xF9, 0xF8, ##  0000 00000000  000000
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x0F, 0xFF, 0xE0, ##      000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7F, 0xF0, 0xE0, ##   00000000000    000
            0x7F, 0xF0, 0xE0, ##   00000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0x7F, 0xF0, 0xE0, ##   00000000000    000
            0x3F, 0xF0, 0xE0, ##    0000000000    000
            0x1F, 0xF0, 0xE0, ##     000000000    000
            0x03, 0xF0, 0xE0, ##        000000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 5, 
        'xoffset'  => 10, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 9, 
        'xoffset'  => 8, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0E, 0x00, ##      000  
            0x06, 0x00, ##       00  
            0x07, 0x00, ##       000 
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x07, 0x80, ##       0000
            0xFF, 0x80, ##  000000000
            0xFF, 0x00, ##  00000000 
            0xFE, 0x00, ##  0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 12, 
        'xoffset'  => 8, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7E, 0x00, ##   000000     
            0xFE, 0x00, ##  0000000     
            0xFE, 0x00, ##  0000000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 16, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x3C, ##    0000    0000  
            0x78, 0x1E, ##   0000      0000 
            0x70, 0x0E, ##   000        000 
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0x70, 0x0E, ##   000        000 
            0x70, 0x1E, ##   000       0000 
            0x3C, 0x3C, ##    0000    0000  
            0x1F, 0xF8, ##     0000000000   
            0x07, 0xE0, ##       000000     
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x7F, 0xFE, ##   00000000000000 
            0x7F, 0xFE, ##   00000000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x80, 0x40, 0x00, ##  0        0          
            0xC0, 0x60, 0x00, ##  00       00         
            0xE0, 0x78, 0x00, ##  000      0000       
            0xF0, 0x7C, 0x00, ##  0000     00000      
            0x78, 0x3E, 0x00, ##   0000     00000     
            0x3C, 0x1F, 0x00, ##    0000     00000    
            0x1F, 0x07, 0x80, ##     00000     0000   
            0x0F, 0x83, 0xC0, ##      00000     0000  
            0x07, 0xC1, 0xE0, ##       00000     0000 
            0x03, 0xC0, 0xF0, ##        0000      0000
            0x07, 0xC1, 0xE0, ##       00000     0000 
            0x0F, 0x83, 0xC0, ##      00000     0000  
            0x1E, 0x0F, 0x80, ##     0000     00000   
            0x3C, 0x1F, 0x00, ##    0000     00000    
            0x78, 0x3E, 0x00, ##   0000     00000     
            0xF0, 0x7C, 0x00, ##  0000     00000      
            0xE0, 0x70, 0x00, ##  000      000        
            0xC0, 0x60, 0x00, ##  00       00         
            0x80, 0x40, 0x00, ##  0        0          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 23, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0x80, 0x00, ##        000              
            0x7F, 0x80, 0x00, ##   00000000              
            0x7F, 0x80, 0x00, ##   00000000              
            0x43, 0x80, 0x00, ##   0    000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x3F, 0xFC, 0x00, ##    000000000000         
            0x3F, 0xFC, 0x00, ##    000000000000         
            0x3F, 0xFC, 0x1E, ##    000000000000     0000
            0x00, 0x01, 0xFE, ##                 00000000
            0x00, 0x1F, 0xFC, ##             00000000000 
            0x01, 0xFF, 0xC0, ##         00000000000     
            0x1F, 0xFC, 0x00, ##     00000000000         
            0xFF, 0x80, 0x00, ##  000000000              
            0x78, 0x00, 0xF0, ##   0000           0000   
            0x00, 0x00, 0xF0, ##                  0000   
            0x00, 0x01, 0xF0, ##                 00000   
            0x00, 0x03, 0xF0, ##                000000   
            0x00, 0x07, 0x70, ##               000 000   
            0x00, 0x06, 0x70, ##               00  000   
            0x00, 0x0E, 0x70, ##              000  000   
            0x00, 0x1C, 0x70, ##             000   000   
            0x00, 0x18, 0x70, ##             00    000   
            0x00, 0x38, 0x70, ##            000    000   
            0x00, 0x70, 0x70, ##           000     000   
            0x00, 0x7F, 0xFE, ##           00000000000000
            0x00, 0x7F, 0xFE, ##           00000000000000
            0x00, 0x7F, 0xFE, ##           00000000000000
            0x00, 0x00, 0x70, ##                   000   
            0x00, 0x00, 0x70, ##                   000   
            0x00, 0x00, 0x70, ##                   000   
            0x00, 0x00, 0x70, ##                   000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 23, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0x80, 0x00, ##        000              
            0x7F, 0x80, 0x00, ##   00000000              
            0x7F, 0x80, 0x00, ##   00000000              
            0x43, 0x80, 0x00, ##   0    000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x03, 0x80, 0x00, ##        000              
            0x3F, 0xFC, 0x00, ##    000000000000         
            0x3F, 0xFC, 0x00, ##    000000000000         
            0x3F, 0xFC, 0x1E, ##    000000000000     0000
            0x00, 0x01, 0xFE, ##                 00000000
            0x00, 0x0F, 0xFC, ##              0000000000 
            0x00, 0xFF, 0xC0, ##          0000000000     
            0x0F, 0xFC, 0x00, ##      0000000000         
            0xFF, 0xC0, 0x00, ##  0000000000             
            0x7C, 0x07, 0xE0, ##   00000       000000    
            0x00, 0x1F, 0xF8, ##             0000000000  
            0x00, 0x1F, 0xFC, ##             00000000000 
            0x00, 0x18, 0x3E, ##             00     00000
            0x00, 0x00, 0x1E, ##                     0000
            0x00, 0x00, 0x1E, ##                     0000
            0x00, 0x00, 0x1E, ##                     0000
            0x00, 0x00, 0x3C, ##                    0000 
            0x00, 0x00, 0x38, ##                    000  
            0x00, 0x00, 0x70, ##                   000   
            0x00, 0x00, 0xE0, ##                  000    
            0x00, 0x01, 0xC0, ##                 000     
            0x00, 0x03, 0x80, ##                000      
            0x00, 0x07, 0x00, ##               000       
            0x00, 0x0E, 0x00, ##              000        
            0x00, 0x1F, 0xFE, ##             000000000000
            0x00, 0x1F, 0xFE, ##             000000000000
            0x00, 0x1F, 0xFE, ##             000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 23, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0xE0, 0x00, ##      0000000            
            0x1F, 0xF0, 0x00, ##     000000000           
            0x1F, 0xF8, 0x00, ##     0000000000          
            0x10, 0x3C, 0x00, ##     0      0000         
            0x00, 0x1C, 0x00, ##             000         
            0x00, 0x1C, 0x00, ##             000         
            0x00, 0x3C, 0x00, ##            0000         
            0x07, 0xF8, 0x00, ##       00000000          
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xF0, 0x00, ##       0000000           
            0x00, 0x3C, 0x00, ##            0000         
            0x00, 0x0E, 0x00, ##              000        
            0x00, 0x0E, 0x00, ##              000        
            0x00, 0x0E, 0x00, ##              000        
            0x00, 0x1E, 0x00, ##             0000        
            0x30, 0x3E, 0x00, ##    00      00000        
            0x3F, 0xFC, 0x00, ##    000000000000         
            0x3F, 0xF8, 0x02, ##    00000000000         0
            0x0F, 0xE0, 0x3E, ##      0000000       00000
            0x00, 0x03, 0xFE, ##                000000000
            0x00, 0x3F, 0xF8, ##            00000000000  
            0x03, 0xFF, 0x00, ##        0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000           
            0x7F, 0x00, 0x00, ##   0000000               
            0x60, 0x00, 0x78, ##   00              0000  
            0x00, 0x00, 0xF8, ##                  00000  
            0x00, 0x01, 0xF8, ##                 000000  
            0x00, 0x03, 0xB8, ##                000 000  
            0x00, 0x03, 0x38, ##                00  000  
            0x00, 0x07, 0x38, ##               000  000  
            0x00, 0x0E, 0x38, ##              000   000  
            0x00, 0x1C, 0x38, ##             000    000  
            0x00, 0x38, 0x38, ##            000     000  
            0x00, 0x38, 0x38, ##            000     000  
            0x00, 0x7F, 0xFE, ##           00000000000000
            0x00, 0x7F, 0xFE, ##           00000000000000
            0x00, 0x7F, 0xFE, ##           00000000000000
            0x00, 0x00, 0x38, ##                    000  
            0x00, 0x00, 0x38, ##                    000  
            0x00, 0x00, 0x38, ##                    000  
            0x00, 0x00, 0x38, ##                    000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 17, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xC0, 0x00, ##        0000       
            0x07, 0x80, 0x00, ##       0000        
            0x0F, 0x80, 0x00, ##      00000        
            0x1F, 0x00, 0x00, ##     00000         
            0x3E, 0x00, 0x00, ##    00000          
            0x7C, 0x00, 0x00, ##   00000           
            0x78, 0x00, 0x00, ##   0000            
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF8, 0x01, 0x80, ##  00000          00
            0x7C, 0x07, 0x80, ##   00000       0000
            0x7F, 0xFF, 0x80, ##   0000000000000000
            0x3F, 0xFF, 0x00, ##    00000000000000 
            0x0F, 0xFC, 0x00, ##      0000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x01, 0xE0, 0x00, ##         0000             
            0x00, 0xF0, 0x00, ##          0000            
            0x00, 0x70, 0x00, ##           000            
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x1E, 0x00, ##             0000         
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xC7, 0x80, ##        0000   0000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0xC3, 0xC0, ##       00000    0000      
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x01, 0xF0, ##      0000       00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x3F, 0xFF, 0xF8, ##    0000000000000000000   
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3C, ##   00000            0000  
            0x78, 0x00, 0x3E, ##   0000             00000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x07, 0x80, ##               0000       
            0x00, 0x0F, 0x00, ##              0000        
            0x00, 0x0E, 0x00, ##              000         
            0x00, 0x1C, 0x00, ##             000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x78, 0x00, ##           0000           
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xC7, 0x80, ##        0000   0000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0xC3, 0xC0, ##       00000    0000      
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x01, 0xF0, ##      0000       00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x3F, 0xFF, 0xF8, ##    0000000000000000000   
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3C, ##   00000            0000  
            0x78, 0x00, 0x3E, ##   0000             00000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xEF, 0x00, ##          000 0000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xC3, 0x80, ##         000    000       
            0x03, 0x81, 0xC0, ##        000      000      
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xC7, 0x80, ##        0000   0000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0xC3, 0xC0, ##       00000    0000      
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x01, 0xF0, ##      0000       00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x3F, 0xFF, 0xF8, ##    0000000000000000000   
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3C, ##   00000            0000  
            0x78, 0x00, 0x3E, ##   0000             00000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x01, 0xE0, 0xE0, ##         0000     000     
            0x03, 0xF8, 0xE0, ##        0000000   000     
            0x07, 0xFF, 0xE0, ##       00000000000000     
            0x07, 0x1F, 0xC0, ##       000   0000000      
            0x07, 0x07, 0x80, ##       000     0000       
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xE7, 0x00, ##          000  000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0xC3, 0xE0, ##       00000    00000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x3F, 0xFF, 0xFC, ##    00000000000000000000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x7C, 0x00, ##           00000          
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xFF, 0x80, ##         0000000000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0x81, 0xC0, ##        000      000      
            0x03, 0x81, 0xC0, ##        000      000      
            0x03, 0x81, 0xC0, ##        000      000      
            0x03, 0x81, 0xC0, ##        000      000      
            0x01, 0xC3, 0x80, ##         000    000       
            0x01, 0xFF, 0x80, ##         0000000000       
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xFF, 0x80, ##         0000000000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xE7, 0xC0, ##        00000  00000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0xC3, 0xE0, ##       00000    00000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x0F, 0x01, 0xF0, ##      0000       00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x3F, 0xFF, 0xFC, ##    00000000000000000000  
            0x3F, 0xFF, 0xFC, ##    00000000000000000000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 25, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000 
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000 
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000 
            0x01, 0xE7, 0x80, 0x00, ##         0000  0000        
            0x01, 0xC7, 0x80, 0x00, ##         000   0000        
            0x01, 0xC7, 0x80, 0x00, ##         000   0000        
            0x03, 0xC7, 0x80, 0x00, ##        0000   0000        
            0x03, 0xC7, 0x80, 0x00, ##        0000   0000        
            0x03, 0x87, 0x80, 0x00, ##        000    0000        
            0x03, 0x87, 0x80, 0x00, ##        000    0000        
            0x07, 0x87, 0x80, 0x00, ##       0000    0000        
            0x07, 0x87, 0x80, 0x00, ##       0000    0000        
            0x07, 0x07, 0x80, 0x00, ##       000     0000        
            0x0F, 0x07, 0xFF, 0x00, ##      0000     00000000000 
            0x0F, 0x07, 0xFF, 0x00, ##      0000     00000000000 
            0x0F, 0x07, 0xFF, 0x00, ##      0000     00000000000 
            0x0E, 0x07, 0x80, 0x00, ##      000      0000        
            0x1E, 0x07, 0x80, 0x00, ##     0000      0000        
            0x1E, 0x07, 0x80, 0x00, ##     0000      0000        
            0x1E, 0x07, 0x80, 0x00, ##     0000      0000        
            0x1F, 0xFF, 0x80, 0x00, ##     00000000000000        
            0x3F, 0xFF, 0x80, 0x00, ##    000000000000000        
            0x3F, 0xFF, 0x80, 0x00, ##    000000000000000        
            0x38, 0x07, 0x80, 0x00, ##    000        0000        
            0x78, 0x07, 0x80, 0x00, ##   0000        0000        
            0x78, 0x07, 0x80, 0x00, ##   0000        0000        
            0x78, 0x07, 0x80, 0x00, ##   0000        0000        
            0x70, 0x07, 0x80, 0x00, ##   000         0000        
            0xF0, 0x07, 0xFF, 0x80, ##  0000         000000000000
            0xF0, 0x07, 0xFF, 0x80, ##  0000         000000000000
            0xF0, 0x07, 0xFF, 0x80, ##  0000         000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x01, 0xFF, 0xC0, ##         00000000000  
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x0F, 0xFF, 0xF0, ##      0000000000000000
            0x0F, 0x00, 0x70, ##      0000         000
            0x1E, 0x00, 0x10, ##     0000            0
            0x3C, 0x00, 0x00, ##    0000              
            0x3C, 0x00, 0x00, ##    0000              
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x3C, 0x00, 0x00, ##    0000              
            0x3C, 0x00, 0x00, ##    0000              
            0x1E, 0x00, 0x10, ##     0000            0
            0x1F, 0x00, 0x70, ##     00000         000
            0x0F, 0xFF, 0xF0, ##      0000000000000000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x01, 0xFF, 0xC0, ##         00000000000  
            0x00, 0x0C, 0x00, ##              00      
            0x00, 0x0E, 0x00, ##              000     
            0x00, 0x07, 0x00, ##               000    
            0x00, 0x07, 0x00, ##               000    
            0x00, 0x0F, 0x00, ##              0000    
            0x01, 0xFF, 0x00, ##         000000000    
            0x01, 0xFE, 0x00, ##         00000000     
            0x01, 0xFC, 0x00, ##         0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x0F, 0x00, 0x00, ##      0000           
            0x07, 0x80, 0x00, ##       0000          
            0x03, 0x80, 0x00, ##        000          
            0x01, 0xC0, 0x00, ##         000         
            0x01, 0xE0, 0x00, ##         0000        
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x00, ##            0000     
            0x00, 0x78, 0x00, ##           0000      
            0x00, 0x70, 0x00, ##           000       
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xE0, 0x00, ##         0000        
            0x03, 0xC0, 0x00, ##        0000         
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x01, 0xE0, 0x00, ##         0000        
            0x03, 0xF0, 0x00, ##        000000       
            0x07, 0xF8, 0x00, ##       00000000      
            0x0F, 0x3C, 0x00, ##      0000  0000     
            0x0E, 0x1C, 0x00, ##      000    000     
            0x1C, 0x0E, 0x00, ##     000      000    
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000 
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 17, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x0F, 0x00, 0x00, ##      0000         
            0x07, 0x80, 0x00, ##       0000        
            0x03, 0x80, 0x00, ##        000        
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xE0, 0x00, ##         0000      
            0x00, 0xE0, 0x00, ##          000      
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 17, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x00, ##            0000   
            0x00, 0x78, 0x00, ##           0000    
            0x00, 0x70, 0x00, ##           000     
            0x00, 0xE0, 0x00, ##          000      
            0x01, 0xC0, 0x00, ##         000       
            0x03, 0xC0, 0x00, ##        0000       
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 17, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x01, 0xE0, 0x00, ##         0000      
            0x03, 0xF0, 0x00, ##        000000     
            0x07, 0xF8, 0x00, ##       00000000    
            0x0F, 0x38, 0x00, ##      0000  000    
            0x0E, 0x1C, 0x00, ##      000    000   
            0x1C, 0x0E, 0x00, ##     000      000  
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 17, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x1E, 0x1E, 0x00, ##     0000    0000  
            0x1E, 0x1E, 0x00, ##     0000    0000  
            0x1E, 0x1E, 0x00, ##     0000    0000  
            0x1E, 0x1E, 0x00, ##     0000    0000  
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1F, 0xFC, 0x00, ##     00000000000         
            0x1F, 0xFF, 0x80, ##     00000000000000      
            0x1F, 0xFF, 0xC0, ##     000000000000000     
            0x1E, 0x07, 0xE0, ##     0000      000000    
            0x1E, 0x01, 0xF0, ##     0000        00000   
            0x1E, 0x00, 0x78, ##     0000          0000  
            0x1E, 0x00, 0x78, ##     0000          0000  
            0x1E, 0x00, 0x3C, ##     0000           0000 
            0x1E, 0x00, 0x3C, ##     0000           0000 
            0x1E, 0x00, 0x3C, ##     0000           0000 
            0x1E, 0x00, 0x1E, ##     0000            0000
            0x1E, 0x00, 0x1E, ##     0000            0000
            0x1E, 0x00, 0x1E, ##     0000            0000
            0xFF, 0xF8, 0x1E, ##  0000000000000      0000
            0xFF, 0xF8, 0x1E, ##  0000000000000      0000
            0xFF, 0xF8, 0x1E, ##  0000000000000      0000
            0x1E, 0x00, 0x1E, ##     0000            0000
            0x1E, 0x00, 0x1E, ##     0000            0000
            0x1E, 0x00, 0x1E, ##     0000            0000
            0x1E, 0x00, 0x1E, ##     0000            0000
            0x1E, 0x00, 0x1E, ##     0000            0000
            0x1E, 0x00, 0x3C, ##     0000           0000 
            0x1E, 0x00, 0x3C, ##     0000           0000 
            0x1E, 0x00, 0x3C, ##     0000           0000 
            0x1E, 0x00, 0x78, ##     0000          0000  
            0x1E, 0x00, 0x78, ##     0000          0000  
            0x1E, 0x01, 0xF0, ##     0000        00000   
            0x1E, 0x07, 0xE0, ##     0000      000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000     
            0x1F, 0xFF, 0x80, ##     00000000000000      
            0x1F, 0xFC, 0x00, ##     00000000000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x07, 0x83, 0x80, ##       0000     000   
            0x0F, 0xE3, 0x80, ##      0000000   000   
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x1C, 0x7F, 0x00, ##     000   0000000    
            0x1C, 0x1E, 0x00, ##     000     0000     
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFC, 0x00, 0xF0, ##  000000          0000
            0xFE, 0x00, 0xF0, ##  0000000         0000
            0xFE, 0x00, 0xF0, ##  0000000         0000
            0xFE, 0x00, 0xF0, ##  0000000         0000
            0xFF, 0x00, 0xF0, ##  00000000        0000
            0xFF, 0x00, 0xF0, ##  00000000        0000
            0xFF, 0x80, 0xF0, ##  000000000       0000
            0xF7, 0x80, 0xF0, ##  0000 0000       0000
            0xF7, 0x80, 0xF0, ##  0000 0000       0000
            0xF3, 0xC0, 0xF0, ##  0000  0000      0000
            0xF3, 0xC0, 0xF0, ##  0000  0000      0000
            0xF1, 0xE0, 0xF0, ##  0000   0000     0000
            0xF1, 0xE0, 0xF0, ##  0000   0000     0000
            0xF1, 0xE0, 0xF0, ##  0000   0000     0000
            0xF0, 0xF0, 0xF0, ##  0000    0000    0000
            0xF0, 0xF0, 0xF0, ##  0000    0000    0000
            0xF0, 0x70, 0xF0, ##  0000     000    0000
            0xF0, 0x78, 0xF0, ##  0000     0000   0000
            0xF0, 0x78, 0xF0, ##  0000     0000   0000
            0xF0, 0x3C, 0xF0, ##  0000      0000  0000
            0xF0, 0x3C, 0xF0, ##  0000      0000  0000
            0xF0, 0x1C, 0xF0, ##  0000       000  0000
            0xF0, 0x1E, 0xF0, ##  0000       0000 0000
            0xF0, 0x0E, 0xF0, ##  0000        000 0000
            0xF0, 0x0F, 0xF0, ##  0000        00000000
            0xF0, 0x0F, 0xF0, ##  0000        00000000
            0xF0, 0x07, 0xF0, ##  0000         0000000
            0xF0, 0x07, 0xF0, ##  0000         0000000
            0xF0, 0x03, 0xF0, ##  0000          000000
            0xF0, 0x03, 0xF0, ##  0000          000000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x03, 0xC0, 0x00, ##        0000           
            0x01, 0xC0, 0x00, ##         000           
            0x01, 0xE0, 0x00, ##         0000          
            0x00, 0xF0, 0x00, ##          0000         
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x20, 0x00, ##            0          
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x7C, 0x01, 0xE0, ##   00000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFE, 0x00, ##        000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0xF0, 0x00, ##          0000         
            0x01, 0xE0, 0x00, ##         0000          
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x20, 0x00, ##            0          
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x7C, 0x01, 0xE0, ##   00000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFE, 0x00, ##        000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0xF8, 0x00, ##          00000        
            0x01, 0xFC, 0x00, ##         0000000       
            0x03, 0xDE, 0x00, ##        0000 0000      
            0x07, 0x8F, 0x00, ##       0000   0000     
            0x07, 0x07, 0x00, ##       000     000     
            0x0E, 0x03, 0x80, ##      000       000    
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x20, 0x00, ##            0          
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x7C, 0x01, 0xE0, ##   00000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFE, 0x00, ##        000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x07, 0xC1, 0xC0, ##       00000     000   
            0x0F, 0xF3, 0xC0, ##      00000000  0000   
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1C, 0x7F, 0x80, ##     000   00000000    
            0x1C, 0x1F, 0x00, ##     000     00000     
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x20, 0x00, ##            0          
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x7C, 0x01, 0xE0, ##   00000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFE, 0x00, ##        000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x0F, 0x07, 0x80, ##      0000     0000    
            0x0F, 0x07, 0x80, ##      0000     0000    
            0x0F, 0x07, 0x80, ##      0000     0000    
            0x0F, 0x07, 0x80, ##      0000     0000    
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x20, 0x00, ##            0          
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x7C, 0x01, 0xE0, ##   00000         0000  
            0x3C, 0x01, 0xE0, ##    0000         0000  
            0x1E, 0x03, 0xC0, ##     0000       0000   
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFE, 0x00, ##        000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x20, 0x00, 0x40, ##    0              0  
            0x70, 0x00, 0xE0, ##   000            000 
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0x0F, 0x80, ##     00000    00000   
            0x0F, 0x9E, 0x00, ##      00000  0000     
            0x07, 0xFC, 0x00, ##       000000000      
            0x03, 0xF8, 0x00, ##        0000000       
            0x01, 0xF0, 0x00, ##         00000        
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xFC, 0x00, ##        00000000      
            0x07, 0xBE, 0x00, ##       0000 00000     
            0x0F, 0x1F, 0x00, ##      0000   00000    
            0x1E, 0x0F, 0x80, ##     0000     00000   
            0x3C, 0x07, 0xC0, ##    0000       00000  
            0x78, 0x03, 0xE0, ##   0000         00000 
            0x70, 0x01, 0xE0, ##   000           0000 
            0x20, 0x00, 0xC0, ##    0             00  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 25, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x03, 0x00, ##                        00 
            0x00, 0xFF, 0xC7, 0x80, ##          0000000000   0000
            0x03, 0xFF, 0xE7, 0x00, ##        0000000000000  000 
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000  
            0x07, 0x80, 0xFC, 0x00, ##       0000       000000   
            0x0F, 0x00, 0x7C, 0x00, ##      0000         00000   
            0x0F, 0x00, 0x78, 0x00, ##      0000         0000    
            0x1E, 0x00, 0x7C, 0x00, ##     0000          00000   
            0x1E, 0x00, 0xFC, 0x00, ##     0000         000000   
            0x1E, 0x00, 0xFC, 0x00, ##     0000         000000   
            0x3C, 0x01, 0xDE, 0x00, ##    0000         000 0000  
            0x3C, 0x03, 0xDE, 0x00, ##    0000        0000 0000  
            0x3C, 0x07, 0x9E, 0x00, ##    0000       0000  0000  
            0x3C, 0x07, 0x1E, 0x00, ##    0000       000   0000  
            0x3C, 0x0F, 0x1E, 0x00, ##    0000      0000   0000  
            0x3C, 0x1E, 0x1E, 0x00, ##    0000     0000    0000  
            0x3C, 0x3C, 0x1E, 0x00, ##    0000    0000     0000  
            0x3C, 0x3C, 0x1E, 0x00, ##    0000    0000     0000  
            0x3C, 0x78, 0x1E, 0x00, ##    0000   0000      0000  
            0x3C, 0xF0, 0x1E, 0x00, ##    0000  0000       0000  
            0x3D, 0xF0, 0x1E, 0x00, ##    0000 00000       0000  
            0x3D, 0xE0, 0x1E, 0x00, ##    0000 0000        0000  
            0x3F, 0xC0, 0x1E, 0x00, ##    00000000         0000  
            0x3F, 0x80, 0x3C, 0x00, ##    0000000         0000   
            0x1F, 0x80, 0x3C, 0x00, ##     000000         0000   
            0x1F, 0x00, 0x3C, 0x00, ##     00000          0000   
            0x1F, 0x00, 0x38, 0x00, ##     00000          000    
            0x1F, 0x80, 0x78, 0x00, ##     000000        0000    
            0x3F, 0xC0, 0xF0, 0x00, ##    00000000      0000     
            0x7F, 0xFF, 0xF0, 0x00, ##   0000000000000000000     
            0x73, 0xFF, 0xE0, 0x00, ##   000  0000000000000      
            0xE1, 0xFF, 0x80, 0x00, ##  000    0000000000        
            0x40, 0x00, 0x00, 0x00, ##   0                       
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x07, 0x80, 0x00, ##       0000           
            0x03, 0xC0, 0x00, ##        0000          
            0x01, 0xE0, 0x00, ##         0000         
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x38, 0x00, ##            000       
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x70, 0x00, 0xE0, ##   000            000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xE0, 0x00, ##          000         
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x70, 0x00, 0xE0, ##   000            000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0x9C, 0x00, ##        000  000      
            0x07, 0x0E, 0x00, ##       000    000     
            0x0E, 0x07, 0x00, ##      000      000    
            0x1C, 0x03, 0x80, ##     000        000   
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x70, 0x00, 0xE0, ##   000            000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x70, 0x00, 0xE0, ##   000            000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x07, 0x80, ##               0000       
            0x00, 0x0F, 0x00, ##              0000        
            0x00, 0x0E, 0x00, ##              000         
            0x00, 0x1C, 0x00, ##             000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xF0, 0x07, 0xE0, ##  0000         000000 
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x07, 0xE0, ##  0000         000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xF8, 0x00, ##       00000000       
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x00, ##    00000000000000    
            0x7C, 0x0F, 0x80, ##   00000      00000   
            0x78, 0x07, 0x80, ##   0000        0000   
            0xF8, 0x03, 0xC0, ##  00000         0000  
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x03, 0xC0, ##  0000          0000  
            0xF0, 0x0F, 0xC0, ##  0000        000000  
            0xF0, 0x3F, 0x00, ##  0000      000000    
            0xF0, 0x78, 0x00, ##  0000     0000       
            0xF0, 0xF0, 0x00, ##  0000    0000        
            0xF1, 0xE0, 0x00, ##  0000   0000         
            0xF1, 0xE0, 0x00, ##  0000   0000         
            0xF1, 0xE0, 0x00, ##  0000   0000         
            0xF1, 0xE0, 0x00, ##  0000   0000         
            0xF1, 0xF0, 0x00, ##  0000   00000        
            0xF0, 0xF8, 0x00, ##  0000    00000       
            0xF0, 0xFE, 0x00, ##  0000    0000000     
            0xF0, 0x7F, 0x00, ##  0000     0000000    
            0xF0, 0x3F, 0x80, ##  0000      0000000   
            0xF0, 0x0F, 0xC0, ##  0000        000000  
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF3, 0xFF, 0xE0, ##  0000  0000000000000 
            0xF3, 0xFF, 0xC0, ##  0000  000000000000  
            0xF3, 0xFF, 0x00, ##  0000  0000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1E, 0x00, 0x00, ##     0000            
            0x0F, 0x00, 0x00, ##      0000           
            0x07, 0x80, 0x00, ##       0000          
            0x03, 0x80, 0x00, ##        000          
            0x03, 0xC0, 0x00, ##        0000         
            0x01, 0xE0, 0x00, ##         0000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0x70, 0x00, ##           000       
            0x00, 0x38, 0x00, ##            000      
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x3F, 0xFF, 0x00, ##    00000000000000   
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x30, 0x07, 0xC0, ##    00         00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7E, 0x01, 0xE0, ##   000000        0000
            0x78, 0x01, 0xE0, ##   0000          0000
            0xF8, 0x01, 0xE0, ##  00000          0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF8, 0x07, 0xE0, ##  00000        000000
            0x78, 0x0F, 0xE0, ##   0000       0000000
            0x7F, 0xFD, 0xE0, ##   0000000000000 0000
            0x3F, 0xFD, 0xE0, ##    000000000000 0000
            0x1F, 0xF1, 0xE0, ##     000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, ##               0000  
            0x00, 0x0F, 0x00, ##              0000   
            0x00, 0x1E, 0x00, ##             0000    
            0x00, 0x1C, 0x00, ##             000     
            0x00, 0x38, 0x00, ##            000      
            0x00, 0x78, 0x00, ##           0000      
            0x00, 0x70, 0x00, ##           000       
            0x00, 0xE0, 0x00, ##          000        
            0x01, 0xC0, 0x00, ##         000         
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x3F, 0xFF, 0x00, ##    00000000000000   
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x30, 0x07, 0xC0, ##    00         00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7E, 0x01, 0xE0, ##   000000        0000
            0x78, 0x01, 0xE0, ##   0000          0000
            0xF8, 0x01, 0xE0, ##  00000          0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF8, 0x07, 0xE0, ##  00000        000000
            0x78, 0x0F, 0xE0, ##   0000       0000000
            0x7F, 0xFD, 0xE0, ##   0000000000000 0000
            0x3F, 0xFD, 0xE0, ##    000000000000 0000
            0x1F, 0xF1, 0xE0, ##     000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x03, 0x9C, 0x00, ##        000  000     
            0x07, 0x1C, 0x00, ##       000   000     
            0x07, 0x0E, 0x00, ##       000    000    
            0x0E, 0x07, 0x00, ##      000      000   
            0x0C, 0x07, 0x00, ##      00       000   
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x3F, 0xFF, 0x00, ##    00000000000000   
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x30, 0x07, 0xC0, ##    00         00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7E, 0x01, 0xE0, ##   000000        0000
            0x78, 0x01, 0xE0, ##   0000          0000
            0xF8, 0x01, 0xE0, ##  00000          0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF8, 0x07, 0xE0, ##  00000        000000
            0x78, 0x0F, 0xE0, ##   0000       0000000
            0x7F, 0xFD, 0xE0, ##   0000000000000 0000
            0x3F, 0xFD, 0xE0, ##    000000000000 0000
            0x1F, 0xF1, 0xE0, ##     000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x83, 0x80, ##       0000     000  
            0x0F, 0xC3, 0x80, ##      000000    000  
            0x0F, 0xE3, 0x80, ##      0000000   000  
            0x1E, 0xF7, 0x80, ##     0000 0000 0000  
            0x1C, 0x7F, 0x00, ##     000   0000000   
            0x1C, 0x3F, 0x00, ##     000    000000   
            0x1C, 0x1E, 0x00, ##     000     0000    
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x3F, 0xFF, 0x00, ##    00000000000000   
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x30, 0x07, 0xC0, ##    00         00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7E, 0x01, 0xE0, ##   000000        0000
            0x78, 0x01, 0xE0, ##   0000          0000
            0xF8, 0x01, 0xE0, ##  00000          0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF8, 0x07, 0xE0, ##  00000        000000
            0x78, 0x0F, 0xE0, ##   0000       0000000
            0x7F, 0xFD, 0xE0, ##   0000000000000 0000
            0x3F, 0xFD, 0xE0, ##    000000000000 0000
            0x1F, 0xF1, 0xE0, ##     000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x0F, 0x00, ##      0000    0000   
            0x0F, 0x0F, 0x00, ##      0000    0000   
            0x0F, 0x0F, 0x00, ##      0000    0000   
            0x0F, 0x0F, 0x00, ##      0000    0000   
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x3F, 0xFF, 0x00, ##    00000000000000   
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x30, 0x07, 0xC0, ##    00         00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7E, 0x01, 0xE0, ##   000000        0000
            0x78, 0x01, 0xE0, ##   0000          0000
            0xF8, 0x01, 0xE0, ##  00000          0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF8, 0x07, 0xE0, ##  00000        000000
            0x78, 0x0F, 0xE0, ##   0000       0000000
            0x7F, 0xFD, 0xE0, ##   0000000000000 0000
            0x3F, 0xFD, 0xE0, ##    000000000000 0000
            0x1F, 0xF1, 0xE0, ##     000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000       
            0x03, 0xFC, 0x00, ##        00000000     
            0x07, 0xFE, 0x00, ##       0000000000    
            0x0F, 0x0E, 0x00, ##      0000    000    
            0x0E, 0x07, 0x00, ##      000      000   
            0x0E, 0x07, 0x00, ##      000      000   
            0x0E, 0x07, 0x00, ##      000      000   
            0x0E, 0x07, 0x00, ##      000      000   
            0x0F, 0x0E, 0x00, ##      0000    000    
            0x07, 0xFE, 0x00, ##       0000000000    
            0x03, 0xFC, 0x00, ##        00000000     
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x1F, 0xFE, 0x00, ##     000000000000    
            0x3F, 0xFF, 0x00, ##    00000000000000   
            0x3F, 0xFF, 0x80, ##    000000000000000  
            0x30, 0x07, 0xC0, ##    00         00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x00, 0x01, 0xE0, ##                 0000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7E, 0x01, 0xE0, ##   000000        0000
            0x78, 0x01, 0xE0, ##   0000          0000
            0xF8, 0x01, 0xE0, ##  00000          0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF0, 0x03, 0xE0, ##  0000          00000
            0xF8, 0x07, 0xE0, ##  00000        000000
            0x78, 0x0F, 0xE0, ##   0000       0000000
            0x7F, 0xFD, 0xE0, ##   0000000000000 0000
            0x3F, 0xFD, 0xE0, ##    000000000000 0000
            0x1F, 0xF1, 0xE0, ##     000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 25, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                           
            0x3F, 0xE3, 0xFC, 0x00, ##    000000000   00000000   
            0x3F, 0xFF, 0xFE, 0x00, ##    000000000000000000000  
            0x3F, 0xFF, 0xFF, 0x00, ##    0000000000000000000000 
            0x20, 0x7E, 0x0F, 0x00, ##    0      000000     0000 
            0x00, 0x7C, 0x0F, 0x00, ##           00000      0000 
            0x00, 0x3C, 0x07, 0x80, ##            0000       0000
            0x00, 0x3C, 0x07, 0x80, ##            0000       0000
            0x00, 0x3C, 0x07, 0x80, ##            0000       0000
            0x00, 0x3C, 0x07, 0x80, ##            0000       0000
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000
            0x3F, 0xFF, 0xFF, 0x80, ##    00000000000000000000000
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000
            0x7C, 0x3C, 0x00, 0x00, ##   00000    0000           
            0xF8, 0x3C, 0x00, 0x00, ##  00000     0000           
            0xF0, 0x3C, 0x00, 0x00, ##  0000      0000           
            0xF0, 0x3C, 0x00, 0x00, ##  0000      0000           
            0xF0, 0x3C, 0x00, 0x00, ##  0000      0000           
            0xF0, 0x3C, 0x00, 0x00, ##  0000      0000           
            0xF0, 0x3E, 0x00, 0x00, ##  0000      00000          
            0xF8, 0x7F, 0x01, 0x00, ##  00000    0000000       0 
            0x7F, 0xFF, 0xFF, 0x00, ##   00000000000000000000000 
            0x3F, 0xE7, 0xFF, 0x00, ##    000000000  00000000000 
            0x1F, 0xC3, 0xFE, 0x00, ##     0000000    000000000  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                    
            0x03, 0xFF, 0x80, ##        00000000000 
            0x0F, 0xFF, 0xC0, ##      00000000000000
            0x1F, 0xFF, 0xC0, ##     000000000000000
            0x3F, 0x00, 0xC0, ##    000000        00
            0x3C, 0x00, 0x40, ##    0000           0
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0xF8, 0x00, 0x00, ##  00000             
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF8, 0x00, 0x00, ##  00000             
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0x3C, 0x00, 0x40, ##    0000           0
            0x3E, 0x00, 0xC0, ##    00000         00
            0x1F, 0xFF, 0xC0, ##     000000000000000
            0x0F, 0xFF, 0xC0, ##      00000000000000
            0x03, 0xFF, 0x80, ##        00000000000 
            0x00, 0x38, 0x00, ##            000     
            0x00, 0x1C, 0x00, ##             000    
            0x00, 0x0E, 0x00, ##              000   
            0x00, 0x0E, 0x00, ##              000   
            0x02, 0x1E, 0x00, ##        0    0000   
            0x03, 0xFE, 0x00, ##        000000000   
            0x03, 0xFC, 0x00, ##        00000000    
            0x01, 0xF8, 0x00, ##         000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x07, 0x80, 0x00, ##       0000            
            0x03, 0xC0, 0x00, ##        0000           
            0x01, 0xE0, 0x00, ##         0000          
            0x00, 0xE0, 0x00, ##          000          
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x38, 0x00, ##            000        
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0x78, ##   0000            0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0x3C, 0x00, 0x10, ##    0000             0 
            0x3F, 0x00, 0x70, ##    000000         000 
            0x1F, 0xFF, 0xF0, ##     00000000000000000 
            0x0F, 0xFF, 0xF0, ##      0000000000000000 
            0x03, 0xFF, 0xC0, ##        000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, ##                0000   
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x1C, 0x00, ##             000       
            0x00, 0x3C, 0x00, ##            0000       
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0xF0, 0x00, ##          0000         
            0x00, 0xE0, 0x00, ##          000          
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0x78, ##   0000            0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0x3C, 0x00, 0x10, ##    0000             0 
            0x3F, 0x00, 0x70, ##    000000         000 
            0x1F, 0xFF, 0xF0, ##     00000000000000000 
            0x0F, 0xFF, 0xF0, ##      0000000000000000 
            0x03, 0xFF, 0xC0, ##        000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, ##           000         
            0x00, 0xF8, 0x00, ##          00000        
            0x00, 0xFC, 0x00, ##          000000       
            0x01, 0xFC, 0x00, ##         0000000       
            0x01, 0xCE, 0x00, ##         000  000      
            0x03, 0x8F, 0x00, ##        000   0000     
            0x07, 0x07, 0x00, ##       000     000     
            0x07, 0x03, 0x80, ##       000      000    
            0x0E, 0x01, 0xC0, ##      000        000   
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x78, 0x00, 0x78, ##   0000            0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0x3C, 0x00, 0x10, ##    0000             0 
            0x3F, 0x00, 0x70, ##    000000         000 
            0x1F, 0xFF, 0xF0, ##     00000000000000000 
            0x0F, 0xFF, 0xF0, ##      0000000000000000 
            0x03, 0xFF, 0xC0, ##        000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x87, 0x80, ##       0000    0000    
            0x07, 0x87, 0x80, ##       0000    0000    
            0x07, 0x87, 0x80, ##       0000    0000    
            0x07, 0x87, 0x80, ##       0000    0000    
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x7C, 0x00, 0xF0, ##   00000          0000 
            0x78, 0x00, 0x78, ##   0000            0000
            0xF8, 0x00, 0x78, ##  00000            0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x78, 0x00, 0x00, ##   0000                
            0x78, 0x00, 0x00, ##   0000                
            0x3C, 0x00, 0x10, ##    0000             0 
            0x3F, 0x00, 0x70, ##    000000         000 
            0x1F, 0xFF, 0xF0, ##     00000000000000000 
            0x0F, 0xFF, 0xF0, ##      0000000000000000 
            0x03, 0xFF, 0xC0, ##        000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3E, 0x00, 0x00, ##    00000            
            0x1E, 0x00, 0x00, ##     0000            
            0x0F, 0x00, 0x00, ##      0000           
            0x07, 0x80, 0x00, ##       0000          
            0x03, 0xC0, 0x00, ##        0000         
            0x01, 0xC0, 0x00, ##         000         
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0x78, 0x00, ##           0000      
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x00, ##               000   
            0x00, 0x0F, 0x00, ##              0000   
            0x00, 0x1E, 0x00, ##             0000    
            0x00, 0x3C, 0x00, ##            0000     
            0x00, 0x38, 0x00, ##            000      
            0x00, 0x70, 0x00, ##           000       
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xE0, 0x00, ##         0000        
            0x01, 0xC0, 0x00, ##         000         
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xE0, 0x00, ##          000        
            0x01, 0xF0, 0x00, ##         00000       
            0x01, 0xF0, 0x00, ##         00000       
            0x03, 0xB8, 0x00, ##        000 000      
            0x07, 0xBC, 0x00, ##       0000 0000     
            0x07, 0x1C, 0x00, ##       000   000     
            0x0E, 0x0E, 0x00, ##      000     000    
            0x1C, 0x06, 0x00, ##     000       00    
            0x1C, 0x07, 0x00, ##     000       000   
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x1E, 0x1E, 0x00, ##     0000    0000    
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x3F, 0xF0, 0x00, ##    0000000000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x00, 0x00, ##      0000            
            0x07, 0x81, 0x80, ##       0000      00   
            0x03, 0xC7, 0x80, ##        0000   0000   
            0x03, 0xFF, 0x80, ##        00000000000   
            0x01, 0xF8, 0x00, ##         000000       
            0x0F, 0xF8, 0x00, ##      000000000       
            0x3F, 0x78, 0x00, ##    000000 0000       
            0x18, 0x3C, 0x00, ##     00     0000      
            0x00, 0x3E, 0x00, ##            00000     
            0x00, 0x1F, 0x00, ##             00000    
            0x01, 0xFF, 0x00, ##         000000000    
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x1F, 0xFF, 0xC0, ##     000000000000000  
            0x3F, 0x03, 0xC0, ##    000000      0000  
            0x3C, 0x03, 0xE0, ##    0000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF8, 0x01, 0xF0, ##  00000          00000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x07, 0x00, ##      0000     000  
            0x1F, 0x87, 0x00, ##     000000    000  
            0x1F, 0xCF, 0x00, ##     0000000  0000  
            0x3C, 0xFE, 0x00, ##    0000  0000000   
            0x38, 0x7E, 0x00, ##    000    000000   
            0x38, 0x3C, 0x00, ##    000     0000    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0xF1, 0xFE, 0x00, ##  0000   00000000   
            0xF7, 0xFF, 0x00, ##  0000 00000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFC, 0x0F, 0x80, ##  000000      00000 
            0xF8, 0x07, 0x80, ##  00000        0000 
            0xF8, 0x03, 0xC0, ##  00000         0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1E, 0x00, 0x00, ##     0000             
            0x0F, 0x00, 0x00, ##      0000            
            0x07, 0x80, 0x00, ##       0000           
            0x07, 0x80, 0x00, ##       0000           
            0x03, 0xC0, 0x00, ##        0000          
            0x01, 0xE0, 0x00, ##         0000         
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x38, 0x00, ##            000       
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, ##               0000   
            0x00, 0x0F, 0x00, ##              0000    
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xE0, 0x00, ##          000         
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xF8, 0x00, ##        0000000       
            0x03, 0x9C, 0x00, ##        000  000      
            0x07, 0x0E, 0x00, ##       000    000     
            0x07, 0x0E, 0x00, ##       000    000     
            0x0E, 0x07, 0x00, ##      000      000    
            0x1C, 0x03, 0x80, ##     000        000   
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x83, 0x80, ##       0000     000   
            0x0F, 0xC3, 0x80, ##      000000    000   
            0x0F, 0xE3, 0x80, ##      0000000   000   
            0x1E, 0xF7, 0x80, ##     0000 0000 0000   
            0x1C, 0x7F, 0x00, ##     000   0000000    
            0x1C, 0x3F, 0x00, ##     000    000000    
            0x1C, 0x1E, 0x00, ##     000     0000     
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x07, 0xFE, 0x00, ##       0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x04, ##                       0  
            0x00, 0x00, 0x06, ##                       00 
            0x01, 0xFF, 0x8E, ##         0000000000   000 
            0x03, 0xFF, 0xDC, ##        000000000000 000  
            0x07, 0xFF, 0xF8, ##       0000000000000000   
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1E, 0x01, 0xF8, ##     0000        000000   
            0x1E, 0x01, 0xF8, ##     0000        000000   
            0x3C, 0x03, 0xBC, ##    0000        000 0000  
            0x3C, 0x07, 0x3C, ##    0000       000  0000  
            0x3C, 0x0E, 0x3C, ##    0000      000   0000  
            0x3C, 0x1C, 0x3C, ##    0000     000    0000  
            0x3C, 0x3C, 0x3C, ##    0000    0000    0000  
            0x3C, 0x38, 0x3C, ##    0000    000     0000  
            0x3C, 0x70, 0x3C, ##    0000   000      0000  
            0x3C, 0xE0, 0x3C, ##    0000  000       0000  
            0x3D, 0xC0, 0x3C, ##    0000 000        0000  
            0x1F, 0xC0, 0x78, ##     0000000       0000   
            0x1F, 0x80, 0x78, ##     000000        0000   
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x1F, 0x81, 0xF0, ##     000000      00000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000     
            0x3B, 0xFF, 0xC0, ##    000 000000000000      
            0x71, 0xFF, 0x80, ##   000   0000000000       
            0xE0, 0x00, 0x00, ##  000                     
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3C, 0x00, 0x00, ##    0000            
            0x1E, 0x00, 0x00, ##     0000           
            0x0E, 0x00, 0x00, ##      000           
            0x0F, 0x00, 0x00, ##      0000          
            0x07, 0x80, 0x00, ##       0000         
            0x03, 0xC0, 0x00, ##        0000        
            0x01, 0xC0, 0x00, ##         000        
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0x70, 0x00, ##           000      
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x07, 0xC0, ##  0000         00000
            0xF8, 0x07, 0xC0, ##  00000        00000
            0x7C, 0x0F, 0xC0, ##   00000      000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x3F, 0xFB, 0xC0, ##    00000000000 0000
            0x1F, 0xE3, 0xC0, ##     00000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x00, ##              0000  
            0x00, 0x1E, 0x00, ##             0000   
            0x00, 0x3C, 0x00, ##            0000    
            0x00, 0x38, 0x00, ##            000     
            0x00, 0x78, 0x00, ##           0000     
            0x00, 0xF0, 0x00, ##          0000      
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xC0, 0x00, ##         000        
            0x03, 0x80, 0x00, ##        000         
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x07, 0xC0, ##  0000         00000
            0xF8, 0x07, 0xC0, ##  00000        00000
            0x7C, 0x0F, 0xC0, ##   00000      000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x3F, 0xFB, 0xC0, ##    00000000000 0000
            0x1F, 0xE3, 0xC0, ##     00000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xE0, 0x00, ##         0000       
            0x03, 0xF0, 0x00, ##        000000      
            0x07, 0xF0, 0x00, ##       0000000      
            0x07, 0x38, 0x00, ##       000  000     
            0x0E, 0x3C, 0x00, ##      000   0000    
            0x1E, 0x1C, 0x00, ##     0000    000    
            0x1C, 0x0E, 0x00, ##     000      000   
            0x38, 0x07, 0x00, ##    000        000  
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x07, 0xC0, ##  0000         00000
            0xF8, 0x07, 0xC0, ##  00000        00000
            0x7C, 0x0F, 0xC0, ##   00000      000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x3F, 0xFB, 0xC0, ##    00000000000 0000
            0x1F, 0xE3, 0xC0, ##     00000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0xF0, 0x07, 0xC0, ##  0000         00000
            0xF8, 0x07, 0xC0, ##  00000        00000
            0x7C, 0x0F, 0xC0, ##   00000      000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x3F, 0xFB, 0xC0, ##    00000000000 0000
            0x1F, 0xE3, 0xC0, ##     00000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, ##                0000    
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x0F, 0x00, ##              0000      
            0x00, 0x1E, 0x00, ##             0000       
            0x00, 0x3C, 0x00, ##            0000        
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x70, 0x00, ##           000          
            0x00, 0xE0, 0x00, ##          000           
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0x78, ##    0000           0000 
            0x3C, 0x00, 0x78, ##    0000           0000 
            0x1E, 0x00, 0xF0, ##     0000         0000  
            0x1E, 0x00, 0xF0, ##     0000         0000  
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x0F, 0x01, 0xE0, ##      0000       0000   
            0x0F, 0x01, 0xE0, ##      0000       0000   
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0x83, 0xC0, ##       0000     0000    
            0x07, 0x83, 0x80, ##       0000     000     
            0x03, 0xC7, 0x80, ##        0000   0000     
            0x03, 0xC7, 0x80, ##        0000   0000     
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x01, 0xEF, 0x00, ##         0000 0000      
            0x01, 0xEE, 0x00, ##         0000 000       
            0x00, 0xFE, 0x00, ##          0000000       
            0x00, 0xFE, 0x00, ##          0000000       
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0xF0, 0x00, ##          0000          
            0x01, 0xF0, 0x00, ##         00000          
            0x03, 0xE0, 0x00, ##        00000           
            0x3F, 0xC0, 0x00, ##    00000000            
            0x3F, 0x80, 0x00, ##    0000000             
            0x3F, 0x00, 0x00, ##    000000              
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF3, 0xFC, 0x00, ##  0000  00000000     
            0xF7, 0xFF, 0x00, ##  0000 00000000000   
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0xFE, 0x0F, 0x80, ##  0000000     00000  
            0xFC, 0x07, 0xC0, ##  000000       00000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF0, 0x01, 0xE0, ##  0000           0000
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xF8, 0x03, 0xC0, ##  00000         0000 
            0xFC, 0x07, 0xC0, ##  000000       00000 
            0xFC, 0x07, 0x80, ##  000000       0000  
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xF7, 0xFF, 0x00, ##  0000 00000000000   
            0xF3, 0xFC, 0x00, ##  0000  00000000     
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0x78, ##    0000           0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x00, 0xF0, ##    00000         0000  
            0x1E, 0x00, 0xF0, ##     0000         0000  
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x0F, 0x01, 0xE0, ##      0000       0000   
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0x83, 0xC0, ##       0000     0000    
            0x07, 0x87, 0x80, ##       0000    0000     
            0x03, 0xC7, 0x80, ##        0000   0000     
            0x03, 0xC7, 0x00, ##        0000   000      
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x01, 0xEF, 0x00, ##         0000 0000      
            0x01, 0xEE, 0x00, ##         0000 000       
            0x00, 0xFE, 0x00, ##          0000000       
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0xF0, 0x00, ##          0000          
            0x01, 0xE0, 0x00, ##         0000           
            0x03, 0xE0, 0x00, ##        00000           
            0x3F, 0xC0, 0x00, ##    00000000            
            0x3F, 0x80, 0x00, ##    0000000             
            0x3F, 0x00, 0x00, ##    000000              
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { },  # A
    '66' => { },  # B
    '67' => { },  # C
    '68' => { },  # D
    '69' => { },  # E
    '70' => { },  # F
    '71' => { },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { },  # K
    '76' => { },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { },  # O
    '80' => { },  # P
    '81' => { },  # Q
    '82' => { },  # R
    '83' => { },  # S
    '84' => { },  # T
    '85' => { },  # U
    '86' => { },  # V
    '87' => { },  # W
    '88' => { },  # X
    '89' => { },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { },  # v
    '119' => { },  # w
    '120' => { },  # x
    '121' => { },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { },  # À
    '193' => { },  # Á
    '194' => { },  # Â
    '195' => { },  # Ã
    '196' => { },  # Ä
    '197' => { },  # Å
    '198' => { },  # Æ
    '199' => { },  # Ç
    '200' => { },  # È
    '201' => { },  # É
    '202' => { },  # Ê
    '203' => { },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { },  # Ð
    '209' => { },  # Ñ
    '210' => { },  # Ò
    '211' => { },  # Ó
    '212' => { },  # Ô
    '213' => { },  # Õ
    '214' => { },  # Ö
    '215' => { },  # ×
    '216' => { },  # Ø
    '217' => { },  # Ù
    '218' => { },  # Ú
    '219' => { },  # Û
    '220' => { },  # Ü
    '221' => { },  # Ý
    '222' => { },  # Þ
    '223' => { },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { },  # è
    '233' => { },  # é
    '234' => { },  # ê
    '235' => { },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { },  # ð
    '241' => { },  # ñ
    '242' => { },  # ò
    '243' => { },  # ó
    '244' => { },  # ô
    '245' => { },  # õ
    '246' => { },  # ö
    '247' => { },  # ÷
    '248' => { },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { },  # ý
    '254' => { },  # þ
    '255' => { },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
