package App::Manoc::DB::ResultSet::VlanRange;
#ABSTRACT: ResultSet class for VlanRange

use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';


sub get_overlap_ranges {
    my ( $self, $start, $end ) = @_;

    my $conditions = [
        {
            start => { '<=' => $start },
            end   => { '>=' => $start },
        },
        {
            start => { '<=' => $end },
            end   => { '>=' => $end },
        },
    ];

    return
        wantarray ? $self->search($conditions)->all :
        $self->search_rs($conditions);
}


1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::VlanRange - ResultSet class for VlanRange

=head1 VERSION

version 2.99.2

=head1 METHODS

=head2 get_overlap_ranges( $start, $end )

Return all the VlanRange which are overlap the given internal.

=head1 SEE ALSO

L<DBIx::Class::ResultSet>

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
