% Read raw data and construct Allan variance from rawstats data file
% Data are collected using rawstats filtered to remove all peers but usno_raw.
%
clear;
fid = fopen('usno_raw', 'r');
[table, count] = fscanf(fid, '%f %f %f %f %f %f');
a = table(1:6:count); b = table(2:6:count);
t1 = table(3:6:count);
t2 = table(4:6:count);
t3 = table(5:6:count);
t4 = table(6:6:count);
x1 = (a - a(1)) * 86400 + b - b(1);
y1 = (t2 - t1 + t3 - t4) / 2;
x = x1; y = y1;
%
% Construct allan deviation plot. Note min 10 intervals averaged.
%
i = 1; d = 64;
while length(y) >= 10
	u = diff(y) / d;
	v = diff(u);
	z1(i) = sqrt(sum(v .* v) / (2 * length(u)));
	m1(i) = d;
	y = y(1:2:length(y));
	i = i + 1; d = d * 2;
end
save usno_raw.txt m1 z1 -ascii
%
% Construct Allan deviation from sythetic data.
%
fid = fopen('synth_usno_raw', 'r');
[table, count] = fscanf(fid, '%f %f %f');
a = table(1:3:count); b = table(2:3:count);
x1 = a - a(1); y1 = b / 1000000;
x = x1; y = y1;
%
% Fix rollover and occasional tick interrupt and a spike or two.
%
d = 0;
for i = 2:length(x)
	if ((y1(i - 1) - y1(i)) > .5)
		d = d + 1;
	elseif ((y1(i - 1) - y1(i)) < -.5)
                d = d - 1;
	end
	y(i) = y(i) + d;
end
%
% Construct allan deviation. Note min 10 intervals averaged.
%
i = 1; d = 2;
while length(y) >= 10 
	u = diff(y) / d;
	v = diff(u);
	z2(i) = sqrt(sum(v .* v) / (2 * length(u)));
	m2(i) = d;
	y = y(1:2:length(y));
	i = i + 1; d = d * 2;
end
save synth_usno_raw.txt m2 z2 -ascii
