% Data are generated by NTP simulator mode 3 with options in allan.sh.
%
clear;
fid = fopen('synth_noise', 'r');
[table, count] = fscanf(fid, '%f %f %f');
a = table(1:3:count); b = table(2:3:count); c = table(3:3:count);
x1 = a - a(1); y1 = b;
x = x1; y = y1; d = 0;
%
% Fix rollover.
%
d = 0;
for i = 2:length(x)
	if ((y1(i - 1) - y1(i)) > 500000)
		d = d + 1000000;
	elseif ((y1(i - 1) - y1(i)) < -500000)
		d = d - 1000000;
	end
	y(i) = y(i) + d;
end
y = fix(y) / 1000000;
%
% Construct allan deviation plot. Note min 10 intervals averaged.
%
i = 1; d = 2;
while length(y) >= 10 
	u = diff(y) / d;
	v = diff(u);
	z(i) = sqrt(sum(v .* v) / (2 * length(u)));
	m(i) = d;
	y = y(1:2:length(y));
	i = i + 1; d = d * 2;
end
save synth_noise.txt m z -ascii
