/*
 * keys.h: header for keys.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * This file is automatically created by keys.h.proto.
 *
 * @(#)$Id: keys.h.proto,v 1.6 1994/07/02 02:38:10 mrg Stab $
 */

#ifndef _KEYS_H_
#define _KEYS_H_

#define BACKSPACE $
#define BACKWARD_CHARACTER $
#define BACKWARD_HISTORY $
#define BACKWARD_WORD $
#define BEGINNING_OF_LINE $
#define CLEAR_SCREEN $
#define COMMAND_COMPLETION $
#define DELETE_CHARACTER $
#define DELETE_NEXT_WORD $
#define DELETE_PREVIOUS_WORD $
#define END_OF_LINE $
#define ENTER_DIGRAPH $
#define	ENTER_MENU $
#define ERASE_LINE $
#define ERASE_TO_BEG_OF_LINE $
#define ERASE_TO_END_OF_LINE $
#define FORWARD_CHARACTER $
#define FORWARD_HISTORY $
#define FORWARD_WORD $
#define META1_CHARACTER $
#define META2_CHARACTER $
#define META3_CHARACTER $
#define META4_CHARACTER $
#define NEXT_WINDOW $
#define NOTHING $
#define PARSE_COMMAND $
#define PREVIOUS_WINDOW $
#define QUIT_IRC $
#define QUOTE_CHARACTER $
#define REFRESH_INPUTLINE $
#define REFRESH_SCREEN $
#define	SCROLL_BACKWARD $
#define	SCROLL_END $
#define SCROLL_FORWARD $
#define SCROLL_START $
#define SELF_INSERT $
#define SEND_LINE $
#define STOP_IRC $
#define SWAP_LAST_WINDOW $
#define SWAP_NEXT_WINDOW $
#define SWAP_PREVIOUS_WINDOW $
#define SWITCH_CHANNELS $
#define TOGGLE_INSERT_MODE $
#define TOGGLE_STOP_SCREEN $
#define TRANSPOSE_CHARACTERS $
#define TYPE_TEXT $
#define UNSTOP_ALL_WINDOWS $
#define YANK_FROM_CUTBUFFER $
#define NUMBER_OF_FUNCTIONS $

/* KeyMap: the structure of the irc keymaps */
typedef struct
{
	int	index;
	char	changed;
	int	global;
	char	*stuff;
}	KeyMap;

/* KeyMapNames: the structure of the keymap to realname array */
typedef struct
{
	char	*name;
	void	(*func) ();
}	KeyMapNames;

extern	KeyMap	FAR keys[],
		FAR meta1_keys[],
		FAR meta2_keys[],
		FAR meta3_keys[],
		FAR meta4_keys[];
extern	KeyMapNames FAR key_names[];

extern	void	(* get_send_line())();
extern	void	save_bindings();
extern	void	input_add_character();
extern	void	change_send_line();
extern	void	rbindcmd __P((char *, char *));

#endif /* _KEYS_H_ */
