(*
        Udos.i3
        -------

Weich, Aug. 1993

Interface for some of the pseudo-unix calls that can be made on DOS-PC's
via the gcc library (see djgcc/docs/func.doc!).

Note that these declarations are similar to those in the Udir.i3, Utime.i3
and other modules from the Modula-3 library: These are sometimes not
compatible with the gcc-unix-calls since the PC in general provides less
information. Check especially struct-definitions of information records
carefully when you use the library external declarations.

See System.i3 for a safe interface to Dos/Unix-filesystemcalls!
See djgcc/include for the gcc-library definitions!
**************************************************************************)

UNSAFE INTERFACE Udos;

FROM Ctypes IMPORT short, unsigned_short, char, char_star, int, long;

CONST
  MAXNAMLEN = 14;   (* maximum length of component of file path name *)
  MAXPATHLEN = 1024; (* maximum length of file path name *)

TYPE
  dirent = RECORD                    (* describes DOS directory entry *)
    d_namelen: unsigned_short;               (* name length in bytes *)
    d_name: ARRAY [0..MAXNAMLEN-1] OF char;  (* name *)
  END;

  ffblk = RECORD
    ff_reserved: ARRAY [0..20] OF char;
    ff_attrib: char;
    ff_ftime, ff_fdate, ff_filler: short;
    ff_fsize: long;
    ff_name: ARRAY [0..15] OF char;
  END;
    
  DIR = RECORD                         (* the DOS directory *)
    num_read:  int;
    name:      char_star;
    ff:        ffblk;
    de:        dirent;
  END;

  DIR_star = UNTRACED REF DIR;

  dirent_star = UNTRACED REF dirent;

<*EXTERNAL*> PROCEDURE opendir (filename: char_star): DIR_star;
<*EXTERNAL*> PROCEDURE readdir (dirp: DIR_star): dirent_star;
<*EXTERNAL*> PROCEDURE telldir (dirp: DIR_star): long;
<*EXTERNAL*> PROCEDURE seekdir (dirp: DIR_star; loc: long);
(* 'rewinddir' is usually a macro for 'seekdir(dirp, 0)' *)
<*EXTERNAL*> PROCEDURE closedir(dirp: DIR_star): int;

END Udos.

