(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Jun 16 21:06:18 PDT 1992 by muller         *)
(*      modified on Wed Apr 12 08:48:03 1989 by kalsow         *)

INTERFACE Thread;

<*OBSOLETE*> CONST 
  DefaultStackSize = 3000;   (* in words *)

TYPE
  (* A handle on a thread *)
  T <: ROOT;

  (* Locked by some thread, or unlocked. A newly-allocated Mutex is in
     the unlocked state. *)
  Mutex = MUTEX;

  (* A set of waiting threads. A newly-allocated Condition has no
     threads waiting on it. *)
  Condition <: ROOT;

  Closure = BRANDED "Thread.Closure" OBJECT METHODS
              apply (): REFANY RAISES {} END;

  (* It is also possible to select the size of the stack (in Word.T)
     on which a thread should executed *)
  SizedClosure = Closure BRANDED "Thread.SizedClosure" OBJECT
                   stackSize: CARDINAL := 0; END;


PROCEDURE MinDefaultStackSize (min: CARDINAL); 
(* change the default stack size (in Word.T) for newly forked
   threads to MAX (min, <current value>) *)

PROCEDURE IncDefaultStackSize (inc: CARDINAL);
(* increment the default stack size (in Word.T) for newly forked 
   threads by inc *)


<*OBSOLETE*> PROCEDURE NewMutex (): Mutex;
(* A newly-allocated, unlocked mutex. *)

<*OBSOLETE*> PROCEDURE NewCondition (): Condition;
(* A newly-allocated condition with no threads waiting on it. *)

PROCEDURE Fork (cl: Closure): T;
(* Return a handle on a newly-created thread that executes cl.apply(). *)

PROCEDURE Join (t: T): REFANY;
(* Wait until t has terminated and return its result. It is a checked runtime
   error to call this more than once for any t. *)

PROCEDURE Wait (m: Mutex; c: Condition);
(* The calling thread must have m locked. Atomically unlocks m and waits on c.
   Then waits for m to be unlocked, locks it, and returns. *)

PROCEDURE Acquire (m: Mutex);
(* Wait until m is unlocked and then lock it. *)

PROCEDURE Release (m: Mutex);
(* The calling thread must have m locked.  Unlocks m. *)

PROCEDURE Broadcast (c: Condition);
(* All threads waiting on c cease waiting and become eligible to run.  *)

PROCEDURE Signal (c: Condition);
(* One or more threads waiting on c cease waiting and become eligible to run. A
   no-op if no threads are waiting on c. *)

PROCEDURE Self (): T;
(* Return the handle of the calling thread. *)

EXCEPTION
  Alerted;(* For approximating asynchronous interrupts *)


PROCEDURE Alert (t: T);
(* Mark t as an alerted thread. *)

PROCEDURE TestAlert (): BOOLEAN;
(* If the calling thread has been marked alerted, return TRUE and unmark it. *)

PROCEDURE AlertWait (m: Mutex; c: Condition) RAISES {Alerted};
(* Like Wait, but if the thread is marked alerted at the time of call or
   sometime during the wait, lock m and raise Alerted. Implementations may
   raise additional exceptions. *)

PROCEDURE AlertJoin (t: T): REFANY RAISES {Alerted};
(* Like Join, but if the thread is marked alerted at the time of call or
   sometime during the wait, raise Alerted. Implementations may raise
   additional exceptions. *)



PROCEDURE Yield ();
(* If there are other threads ready to run, transfer control to one of them;
   otherwise continue with the current thread. *)

END Thread.
