#! /bin/sh
##  $Revision: 1.2 $
##  Run subst over a list of files.  Get files in and out of source control
##  if present.

##  Assume no source control.
MODE=none
PLAIN="$*"
CONTROLLED=

if [ -d RCS -a ! -d SCCS ] ; then
    # Find out which files are under RCS control.
    MODE=rcs
    PLAIN=
    for I
    do
	if [ -f RCS/${I},v ] ; then
	    CONTROLLED="${CONTROLLED} ${I}"
	else
	    PLAIN="${PLAIN} ${I}"
	fi
    done
    co -l -q ${CONTROLLED}
fi
if [ -d SCCS -a ! -d RCS ] ; then
    # Find out which files are under SCCS control.
    MODE=sccs
    PLAIN=
    for I
    do
	if [ -f SCCS/s.${I} ] ; then
	    CONTROLLED="${CONTROLLED} ${I}"
	else
	    PLAIN="${PLAIN} ${I}"
	fi
    done
    sccs get -e ${CONTROLLED}
fi

case `whoami`@`hostname` in
rsalz@news)
    PLAIN="$*"
    CONTROLLED=
    MODE=none
    ;;
esac

##  Make sure we can write all non-controlled files.
test ! -z "${PLAIN}" && chmod +w ${PLAIN}

##  Make the list of files, run config over it.
for I in ${PLAIN} ${CONTROLLED} ; do
    echo ../site/${I}
done >files.$$
(cd ../config; make quiet FILE=../site/files.$$)
rm -f files.$$

##  Check files back into source control, if we have to.
case $MODE in
none)
    exit 0
    ;;
rcs)
    echo 'Ran subst from Makefile' | ci -u -q -f ${CONTROLLED}
    ;;
sccs)
    echo 'Ran subst from Makefile' | sccs delget -s ${CONTROLLED}
    ;;
esac
