: # *-*-perl-*-*
	eval 'exec perl -S $0 "$@"'
	if $running_under_some_shell;  
#
#  Generates HTML stats for a broker database.  
#
#  Usage: 
#  mkbrokerstats.pl broker-dir > stats.html
#
#  mkbrokerstats.pl,v 1.14 1995/06/06 01:06:29 wessels Exp
#
$ENV{'HARVEST_HOME'} = "/usr/local/harvest" if (!defined($ENV{'HARVEST_HOME'}));
unshift(@INC, "$ENV{'HARVEST_HOME'}/lib");      # use local installation
require 'ctime.pl';

$Usage = "$0 broker-dir > stats.html";

# An array for the type field in Collection.conf
@ColTypes = (
	"Gatherer",
	"Gatherer",
	"Gatherer",
	"Gatherer",
	"Broker",
	"Broker",
	"Broker",
	"Broker"
);

# Get to the correct directory, and find the name of this Broker
#
$dir = shift				|| die "$Usage\n";
exit (1) if ( ! -d $dir );
chdir ($dir)				|| die "$Usage\n";
@X = split ('/', `pwd`);
chop ($Broker = pop (@X));

# Count # of objects in Registry
#
$CMD="dumpregistry -count .|";
open(CMD)				|| die "Cannot run $CMD: $!\n";
while (<CMD>) {
	$NObjs = $1 if (/VALID ENTRIES: (\d+), (\d+)/o);
}
close CMD;

# Find unique servers from the Registry
#
$multiples = 0;
$CMD="dumpregistry .|";
open (CMD)                              || die "Cannot run $CMD: $!\n";
while (<CMD>) {
        if (/^URL: (\w+:\/\/[^\/]+)\/.*$/o) {
		$Servers{$1}++;
		$multiples = 1 if (!$multiples && $Servers{$1} > 1);
	}
}
close CMD;

#  Conserves some memory and CPU by only using Servers with > 1 object
$NServers=0; 
while (($x, $value) = each %Servers) {
	$NServers++; 		# count all Servers
	delete $Servers{$x} if ($Servers{$x} == 1 && $multiples && $NServers > 20);
}


# Read broker.conf for various things
#
$CF="admin/broker.conf";
open (CF)					|| die "$CF: $!\n";
while (<CF>) {
	next if (/^#/o || /^\s*\n$/o);
	$ColTime	= $1 if (/Collection-Time ([\d:]+)/o);
	$CleanRate	= $1 if (/Clean-Rate (\d+)/o);
	$ColRate	= $1 if (/Collection-Rate (\d+)/o);
}
close CF;
$CleanRate = int ($CleanRate / 3600);
$ColRate   = int ($ColRate   / 3600);


# Print out some HTML
#
print <<EOF;
<HTML>
<HEAD>
<TITLE>
$Broker Broker Statistics
</TITLE>
</HEAD>

<BODY>
<H2>$Broker Broker Statistics</H2>
EOF

print "There are <B>$NObjs</B> objects in the database";

# Hack, mostly for news: URL's.  The %Servers array is only filled with
# URL's having a hostname.  So, if %Serves is empty, don't print the
# list.
#
if ($NServers) {
	$N=0;
	print "\nfrom <B>$NServers</B> Internet server(s), including:<P>\n";
	print "<UL>\n";
	foreach $x (sort {$Servers{$b} <=> $Servers{$a}} keys %Servers) {
		last if ($N++ > 10);
		printf "<LI> <A HREF=\"%s/\">\n\t%s/</A> (%d objects)\n",
			$x,
			$x,
			$Servers{$x};
	}
	print "</UL>\n";
} else {
	print ".<P>\n";
}

print <<EOF;

Collection occurs every <B>$ColRate</B> hours, at
<B>$ColTime</B>.<P>

The broker checks for expired objects every <B>$CleanRate</B> hours.<P>

Objects are collected from the following Harvest servers:
<UL>
EOF

$CF="admin/Collection.conf";
open (CF)                                        || die "$CF: $!\n";
while (<CF>) {
	next if (/^#/o || /^\s*\n$/o);
	chop $_;
	($host, $port, $type, $query) = split;
	if ($ColTypes[$type] eq "Gatherer") {
		system "gather -info $host $port | info-to-html.pl > $host.$port.html";
	} else {
		open(OUT, "> $host.$port.html") || die "$host.$port.html: $!\n";
		print OUT <<EOM;
<HTML>
<strong>Sorry, no statistics for this Broker are available.</strong>
</HTML>
EOM
		close(OUT);
		chmod 0664, "$host.$port.html";
	}
	printf "<LI> <A HREF=\"%s.%d.html\">\n\t[%s] %s, port %d</A>\n",
		$host, $port, $ColTypes[$type], $host, $port;
}
close CF;

chop ($time0 = &ctime (time));
print <<EOF;
</UL>

<HR>
Generated $time0

</BODY>
</HTML>
EOF

exit 0;
