/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/standalone.c
    Version 2.24
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/signal.h>
#include <ctype.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <pwd.h>
#include <string.h>
#include "gn.h"

#ifdef BSD
static void	zombie();
#endif
extern int	daemon_init();

extern void	reopen_log();

void
do_standalone()
{

	int 	user_id = USERID,
		group_id = GROUPID,
		sockdes,
		sd,
		len,
		pid,
		on = TRUE;
	
	struct linger ling;
	struct sockaddr_in	sa_server,
				sa_client;

	fprintf( stdout, "%d\n", getpid());
	fflush( stdout);

	if ( port == 0)
		port = atoi( DEFAULTPORT);
	if ((sd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) == -1) {
		fprintf( stderr, "Could not get socket.\n");
		exit(2);
	}

	ling.l_onoff = ling.l_linger = 0;

#ifndef NO_LINGER
	if ( setsockopt( sd, SOL_SOCKET, SO_LINGER, (char *)&ling,
					    sizeof (ling)) == -1) {
		senderr2( "Could not set linger option [setsockopt]", "");
		exit(2);
	}
#endif

	if ( (setsockopt( sd, SOL_SOCKET, SO_REUSEADDR, 						&on, sizeof( on))) == -1) {
		senderr2( "Could not set SO_REUSEADDR", "");
		exit(2);
	}

#ifdef BSD
        signal( SIGCHLD, (void (*)())zombie );
#else
        signal( SIGCLD, SIG_IGN);
#endif

	bzero((char *) &sa_server, sizeof( sa_server));
	sa_server.sin_family = AF_INET;
	sa_server.sin_addr.s_addr = htonl( INADDR_ANY);
	sa_server.sin_port = htons( port);
	if( bind( sd, (struct sockaddr *) &sa_server,
			sizeof(sa_server)) == -1) {
		fprintf( stderr, "Could not bind to port.\n");
		perror( "bind");
	        exit(2);
	}

	listen( sd, QUEBACKLOG);

	if ( getuid() == 0 ) {  /* Running as root */

		if (setgid( (gid_t) group_id) == -1) {
			fprintf( stderr,  "Unable to set gid.\n");
			exit( 2);
		}

		if (setuid( (uid_t) user_id) == -1) {
			fprintf( stderr,  "Unable to set uid.\n");
			exit( 2);
		}
	}

	/* We delayed openning it until after setuid */
	open_gnlog( gnlogfile);
	signal( SIGHUP, reopen_log);

	while ( TRUE) {
	        len = sizeof(sa_client);
	        if ( (sockdes = accept( sd, &sa_client, &len)) == -1 ) {
			if( errno != EINTR)
				senderr2( "Accept failed", "");
			continue;
		}

        	if((pid = fork()) == -1) {
			close(sockdes);
			sleep( 1);
			writelog( "Unable to fork new process",
					"discarding request");
			continue;
		}


		if ( pid == 0 ) { 		/* Child process */
			signal( SIGHUP, SIG_DFL);
			signal( SIGQUIT, SIG_DFL);
			signal( SIGINT, SIG_DFL);
			signal( SIGTERM, SIG_DFL);
			signal( SIGALRM, SIG_DFL);
			alarm( TIMEOUT);  /* Timeout after TIMEOUT seconds */
			close(0);
			close(1);
			dup2(sockdes,0);
			dup2(sockdes,1);
			close(sd);
			do_request();
			fclose(stdin);
			fclose(stdout);
			exit (0);
		}

		close(sockdes);
	}
}

#ifdef BSD
static void
zombie()
{
#ifndef NEXT
	int status;
#else
	union wait status;
#endif
	pid_t	pid;

	while( (pid = wait3(&status, WNOHANG|WUNTRACED, NULL)) > 0)
		;
}
#endif

/*
 * The following function adapted from Stevens, "Advanced Programming in the
 * Unix Environment", p. 418,  initializes the the standalone daemon.
 */

int
daemon_init()
{
	pid_t	pid,
		procgp;

	if ( (pid = fork()) < 0 )
		return (-1);
	else if ( pid != 0 )
		exit( 0);

#ifndef NO_SETSID
	if ( (procgp = setsid()) == -1 ) {
		fprintf( stderr, "Setsid failed\n");
		perror("setsid");
		exit( 2);
	}
#else
	if ( ( procgp = setpgrp( getpid(), 0) ) == -1) {
		fprintf( stderr, "Setpgrp failed\n");
		perror("setpgrp");
		exit( 2);
	}
#endif    
	chdir( "/");
	umask( 0);
	return (0);
}




