########################## -*- Mode: Perl -*- ##########################
##
## File             : Dutch.pm
##
## Description      : SFgate messages in dutch
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Tue Mar  5 13:33:38 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Nov 21 12:51:03 1996
##
## $State: Exp $
##
## $Id: Dutch.pm,v 5.1.1.1 1996/12/23 12:51:15 goevert Exp goevert $
##
## $Log: Dutch.pm,v $
## Revision 5.1.1.1  1996/12/23 12:51:15  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:31  goevert
## *** empty log message ***
##
## Revision 5.0.1.3  1996/05/31 15:44:52  goevert
## patch14: language handling changed (SFgate-server)
##
## Revision 5.0.1.2  1996/05/15 17:07:45  goevert
## patch10:
##
## Revision 5.0.1.1  1996/05/13 11:29:21  goevert
## patch1:
##
########################################################################

# Thanks to Mark Koenen <markko@sci.kun.nl>
# for providing these translations


package SFgate::Language::Dutch;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and|en'; 
$or_regexp        = 'or|of';
$not_regexp       = 'not|niet';

$plaintext_regexp = 'text|plain|strict';
$soundex_regexp   = 'soundex';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',            'No description available.',
             'print_wsrc',            'Wais source description could not be parsed:',
             'init_plain1',        'U heeft <B>&eacute;&eacute;n</B> document gekozen:',
             'init_plain2',        'U heeft <B>',
             'init_plain3',        '</B> documenten gekozen:',
             'init_plain4',        'U heeft geen enkel document gekozen!',
             'init_plain5',        'De gelecteerde databases bevatten <B>&eacute;&eacute;n</B> dokument die voldoet aan uw selectiecriterium:',
             'init_plain6',        'De gelecteerde databases bevatten <B>',
             'init_plain7',        '</B> dokumenten die voldoen aan uw selectiecriterium:',
             'init_plain8',        'De geselecteerde databases bevatten <B>&eacute;&eacute;n</B> item die aan uw selectiecriterium voldoet.',
             'init_plain9',           'Conversion of documents:',
             'init_plain10',       'Selecteer een aantal van de volgende dokumenten:',
             'init_plain11',       'Haal dokumenten',
             'init_plain12',       'Maak opnieuw keuze',
             'init_plain13',          'Prior documents...',
             'init_form1',         'De geselecteerde databases bevatten <B>&eacute;&eacute;n</B> database beschrijving die aan uw selectiecriterium voldoet:',
             'init_form2',         'De geselecteerde databases bevatten <B>',
             'init_form3',         '</B> database beschrijvingen die aan uw selectiecriterium voldoen:',
             'init_form4',         'Selecteer een aantal van de volgende databases en geef uw selectiecriterium:',
             'init_form5',         'Start zoeken',
             'init_form6',         'Wis formulier',
             'print_anchor1',      'Database:',
             'print_anchor2',      'Grootte:',
             'print_anchor3',      'Type:',
             'print_anchor4',         'Score:',
             'print_diagnostics1', 'Diagnostiek',
             'print_diagnostics2', 'Server <B>',
             'print_diagnostics3', '</B> geeft de volgende diagnostiek:',
             # search_index.pl
             'do_request1',        'kon dokument niet ophalen:',
             'do_request2',        'WAIS dokument',
             'do_request3',        'Probeert u het direkt te halen!',
             'do_request4',        'debug',
             'do_request5',           'You didn\'t specify a query.',
             'do_request6',        'in',
             'do_request7',           'You didn\'t select any databases.',
             'print_queries1',     'Uw selectiecriterium was:',
             'print_queries2',        'Queries in Databases:',
             'print_forms',           'Refine your query',
             'dumpenv',            'Overzicht van de variabelen',
             'print_footer1',         'Further documents...',
             'print_footer2',      'Deze pagina is gegenereerd door',
             'do_sorry1',             'Syntax error in query',
             'do_sorry2',          'Sorry! Uw selectiecriterium kunnen niet verwerkt worden:',
             'main1',              'be&iuml;ndigd',
             'main2',              'be&iuml;ndigd met melding',
             'main3',              'Neemt u a.u.b. contact op met de WWW beheerder',
             'main4',              'Vreemde fout',
             'main5',              'is niet',
             'main6',              'Door wie werd ik dan wel aangeroepen?',
             # query.pl
             'translate_query',       'Couldn\'t parse date field',
             # parse_query.pl
             'parse_query1',       'eind zoekproces na operator',
             'parse_query2',       'onverwachte sluithaak',
             'parse_query3',       'onverwachte sluit accolade',
             'parse_query4',       'onverwachte operator',
             'parse_query5',       'onverwachte numerieke predikaat',
             'parse_query6',       'onverwachte',
             'parse_query7',       'ontbrekende selectiecriterium na openingshaak',
             'parse_query8',       'ontbrekende sluithaak',
             'parse_query9',       'geen begrenzer voor letterlijke zoekactie:',
             'parse_query10',      'atleast operator zonder numerieke argument',
             'parse_query11',      'atleast operador zonder term',
             'parse_query12',      'geneste indextypelists niet mogelijk',
             'parse_query13',      'ontbrekende openings accolade na indextypelist',
             'parse_query14',      'ontbrekende selectiecriterium na indextypelist',
             'parse_query15',      'ontbrekende sluit accolade na indextypelist',
             'parse_query16',      'geen term bij indextype',
             'parse_query17',      'proximity operator',
             'parse_query18',      'zonder numeriek argument groter dan 0',
             'parse_query19',      'zonder tweede term',
             'parse_query20',      'geneste veldexpressies niet toegestaan',
             'parse_query21',      'een niet-numeriek argument bij een numeriek predikaat',
             'parse_query22',      'ontbrekende selectiecriterium in veldexpressie'
             );


1;
