// QuestionDoc.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
//
// Additional strings needed in [[NXApp delegate] stringTable]:
//	"WAIS Question Error!"
//	"Can't find WAIS specifications for document %s"
//	"Can't find WAIS specifications for source %s"
//

#import "Doc.h"

@interface QuestionDoc:Doc
{
    // WAIS handle.
    id waisQuestion;
    
    // Fields in question window.
    id searchButton;
    id keyWordField;
    id resultBrowser;
    id resultWell;
    id sourceBrowser;
    id sourceWell;
    id similarBrowser;
    id similarWell;
    id iconWellControl;
}

+ (const char *)fileType;
+ (const char *)nibName;
+ (const char *)miniIconName;
+ (const char *)defaultFolder;
- init;
- free;
- dump:sender;
- load:sender;
- setFileName:(const char *)aName;
- search:sender;
- textDidEnd:sender endChar:(unsigned short)whyEnd;
- (int)openFile:(const char *)fileKey ok:(int *)flag;
- (int)prepFile:(const char *)fileKey ok:(int *)flag;

@end
