// AssocTableCell.m
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.

#import "AssocTableCell.h"
#import <appkit/appkit.h>

@implementation AssocTableCell

- initTextCell:(const char *)aString
{
    [super initTextCell:aString];
    assocField = [[TextFieldCell alloc] initTextCell:""];
    assocSize = 0.20;
    assocGray = NX_DKGRAY;
    [assocField setTextGray:assocGray];
    return self;
}

- free
{
    [assocField free];
    return [super free];
}

- drawInside:(const NXRect *)cellFrame inView:controlView
{
    NXRect assocFrame, textFrame;
    float x, y, h, w;
    id rtn;
    
    // Compute subcell rects.
    x = NX_X(cellFrame); y = NX_Y(cellFrame);
    w = NX_WIDTH(cellFrame); h = NX_HEIGHT(cellFrame);
    NX_X(&assocFrame) = x;			NX_Y(&assocFrame) = y;
    NX_WIDTH(&assocFrame) = assocSize*w;	NX_HEIGHT(&assocFrame) = h;
    NX_X(&textFrame) = x + assocSize*w;		NX_Y(&textFrame) = y;
    NX_WIDTH(&textFrame) = (1-assocSize)*w;	NX_HEIGHT(&textFrame) = h;
    
    // Draw subcells.
    rtn = [super drawInside:&textFrame inView:controlView];
    [assocField drawSelf:&assocFrame inView:controlView];
    [assocField highlight:&assocFrame inView:controlView lit:[self isHighlighted]];
    return rtn;
}

- setBackgroundColor:(NXColor)Colorvalue
{
    [assocField setBackgroundColor:Colorvalue];
    return [super setBackgroundColor:Colorvalue];
}

- setBackgroundGray:(float)value
{
    [assocField setBackgroundGray:value];
    return [super setBackgroundGray:value];
}

- setBackgroundTransparent:(BOOL)flag
{
    [assocField setBackgroundTransparent:flag];
    return [super setBackgroundTransparent:flag];
}

- setTextAttributes:textObj
{
    [assocField setTextAttributes:textObj];
    [assocField setTextGray:assocGray];
    return [super setTextAttributes:textObj];
}

- setAssocStringValue:(const char *)aValue
{
    [assocField setStringValue:aValue];
    [[self controlView] updateCellInside:self];
    return self;
}

- (const char *)assocStringValue
{
    return [assocField stringValue];
}

- setAssocSize:(float)aValue
{
    assocSize = aValue;
    if(assocSize > 1.0) assocSize = 1.0;
    if(assocSize < 0.0) assocSize = 0.0;
    [[self controlView] updateCellInside:self];
    return self;
}

- (float)assocSize
{
    return assocSize;
}

- setAssocGray:(float)aValue
{
    assocGray = aValue;
    if(assocGray > 1.0) assocGray = 1.0;
    if(assocGray < 0.0) assocGray = 0.0;
    [assocField setTextGray:assocGray];
    [[self controlView] updateCellInside:self];
    return self;
}

- (float)assocGray
{
    return assocGray;
}

@end
