/* mocode.c, the motif I/F code for Motif X (Servers/Question) Wais */

#include "global.h"
#include <Xm/MwmUtil.h>


char *show_buffer;


Widget g_make_option(option_name,mnem_char,id,sensitive,CB,mp,meta_label,meta_char)
char *option_name;
char mnem_char;
int id;
Boolean sensitive;
XtCallbackProc CB;
Widget mp;
char *meta_label;
char *meta_char;
{
	int ac;
	Arg al[10];
	Widget b;

	ac = 0;
	XtSetArg(al[ac], XmNlabelString,
		 XmStringCreateLtoR(option_name, XmSTRING_DEFAULT_CHARSET)); ac++;
	XtSetArg(al[ac], XmNmnemonic, mnem_char); ac++;
	XtSetArg(al[ac], XmNaccelerator, meta_char); ac++;
        XtSetArg(al[ac], XmNacceleratorText,XmStringCreateLtoR(meta_label,XmSTRING_DEFAULT_CHARSET)); ac++;
	b = XmCreatePushButtonGadget (mp, option_name, al, ac);
	XtAddCallback (b, XmNactivateCallback, CB, id);
	XtManageChild (b);
	if (!sensitive) XtSetSensitive(b, sensitive);
	return(b);
}

void DisplaySelectedProducts(wdgt)
Widget wdgt;
{

int *positions;
int pos_count;
int i;

if (XmListGetSelectedPos(XmSelectionBoxGetChild(wdgt,XmDIALOG_LIST),&positions,&pos_count) == False) {
   fprintf(stderr,"Couldn't get the selected position.\n");
   return;
   }
else {
   for (i=1; i<= pos_count; i++) {
        MXQDisplayDoc(positions[i-1]);
      }
   }
}


void create_err_dialog()
{
int ac=0;
Arg al[2];
void MXQDialogAcceptCB();

	err_dialog = XmCreateWarningDialog(mxq_app_shell,
			   "err", al, ac);
	XtAddCallback (err_dialog, XmNokCallback,
			MXQDialogAcceptCB, MXQ_DIALOG_ERR);
	XtUnmanageChild(XmMessageBoxGetChild(err_dialog,
			XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(err_dialog,
			XmDIALOG_HELP_BUTTON));


}


void dialog_error(s)
char *s;
{
  int ac;
  Arg al[10];

	ac=0;
	XtSetArg(al[ac], XmNmessageString, XmStringCreateLtoR
	   (s, XmSTRING_DEFAULT_CHARSET));  ac++;
        if (err_dialog==NULL) create_err_dialog();
	XtSetValues(err_dialog, al, ac);
	XtManageChild(err_dialog);
	ForceDialog(err_dialog);
	XmUpdateDisplay(err_dialog);
	XmUpdateDisplay(err_dialog);
}

void create_work_dialog()
{
int ac=0;
Arg al[2];
void MXQDialogAcceptCB();

	work_dialog = XmCreateWorkingDialog(mxq_app_shell,
			   "work", al, ac);
	XtAddCallback (work_dialog, XmNokCallback,
			MXQDialogAcceptCB, MXQ_DIALOG_WORK);
	XtUnmanageChild(XmMessageBoxGetChild(work_dialog,
			XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(work_dialog,
			XmDIALOG_HELP_BUTTON));


}


void dialog_work(s)
char *s;
{
  int ac;
  Arg al[10];

	ac=0;
	XtSetArg(al[ac], XmNmessageString, XmStringCreateLtoR
	   (s, XmSTRING_DEFAULT_CHARSET));  ac++;
        if (work_dialog==NULL) create_work_dialog();
	XtSetValues(work_dialog, al, ac);
	XtManageChild(work_dialog);
	ForceDialog(work_dialog);
	XmUpdateDisplay(work_dialog);
	XmUpdateDisplay(work_dialog);
}


void create_fetch_dialog()
{
int ac=0;
Arg al[2];
void MXQDialogAcceptCB();

	fetch_dialog = XmCreateWorkingDialog(mxq_server_responses,
			   "fetch", al, ac);
	XtAddCallback (fetch_dialog, XmNokCallback,
			MXQDialogAcceptCB, MXQ_DIALOG_FETCH);
	XtUnmanageChild(XmMessageBoxGetChild(fetch_dialog,
			XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(fetch_dialog,
			XmDIALOG_HELP_BUTTON));


}


void dialog_fetch(s)
char *s;
{
  int ac;
  Arg al[10];

if (strncmp(s,"done.",5)==0) XtUnmanageChild(fetch_dialog);
else {
	ac=0;
	XtSetArg(al[ac], XmNmessageString, XmStringCreateLtoR
	   (s, XmSTRING_DEFAULT_CHARSET));  ac++;
        if (fetch_dialog==NULL) create_fetch_dialog();
	XtSetValues(fetch_dialog, al, ac);
	XtManageChild(fetch_dialog);
	ForceDialog(fetch_dialog);
	XmUpdateDisplay(fetch_dialog);
	XmUpdateDisplay(fetch_dialog);
	}
}



void init_err_string()
{

err_string[0][0]='\0';
err_string[1][0]='\0';
err_string[2][0]='\0';
err_string[3][0]='\0';

}


void print_dialog_err(s)
char *s;
{
char make[4096];

strcpy(err_string[0],err_string[1]);
strcpy(err_string[1],err_string[2]);
strcpy(err_string[2],err_string[3]);
strcpy(err_string[3],s);

sprintf(make,"%s\n%s\n%s\n%s",err_string[0],err_string[1],err_string[2],err_string[3]);
dialog_error(make);

}






void AddRelevant(wdgt)
Widget wdgt;
{

int *positions;
int pos_count;

void MXQAddRelevant();

if (XmListGetSelectedPos(XmSelectionBoxGetChild(wdgt,XmDIALOG_LIST),&positions,&pos_count) == False) {
   fprintf(stderr,"Couldn't get the selected position.\n");
   return;
   }
else {

      MXQAddRelevant(mxq_relevance_list,positions[0]);

      }
}


void ClearHits( listWidget )
Widget	listWidget;
{
    XmListDeleteAllItems( listWidget );
}



void AddHit( str , listWidget)
char	*str;
Widget	listWidget;
{
    XmString strn;

    strn = XmStringCreateSimple( str );
    XmListAddItem( listWidget, strn, 0);
    XmStringFree( strn );
}

void ClearHeadline(listWidget)
Widget listWidget;
{
headlinenum = 0;
XmListDeleteAllItems( listWidget );
}


void AddHeadline(str)
char *str;
{
headlinenum++;
strcpy(headlines[headlinenum],str);

}

void ShowHeadline(listWidget)
Widget listWidget;
{
XmString *xmstr;
int i;
Arg al[10];
int ac=0;

if (headlinenum == 0) return;
xmstr = (XmString *) XtMalloc(sizeof(XmString) * (headlinenum+2));
for (i=0 ;  i<headlinenum ; i++) {
  xmstr[i] = XmStringCreate(headlines[i+1],XmSTRING_DEFAULT_CHARSET);
  }

XtSetArg(al[ac],XmNitems,xmstr); ac++;
XtSetArg(al[ac],XmNitemCount, headlinenum); ac++;
XtSetValues(listWidget,al,ac);

}






void ClearDocWin()
{
/*fprintf(stderr,"clearing doc window.  (NOT!) \n"); */
}



void PrintDocWin()
{
/*fprintf(stderr,"Printing to doc win.  Uhh huh...  \n");*/
}



char *PrepOutDoc()
{

char *tmpfilename;
FILE *fptr;

tmpfilename=tmpnam(NULL);
if ((fptr=fopen(tmpfilename,"a"))==NULL) {
   fprintf(stderr,"was unable to open %s for append.\n",tmpfilename);
   return (NULL);
   }
else {
   fclose(fptr);
   return(tmpfilename);
   }
}

int AppendFile(to_append,size,fname)
char *to_append;
long size;
char *fname;
{

FILE *fptr;

if (show_buffer != NULL) {
    free(show_buffer);
    show_buffer = NULL;
    }
show_buffer = (char *)malloc(size+10);
bcopy(to_append,show_buffer,size+1);


if ((fptr=fopen(fname,"a"))==NULL) {
    fprintf(stderr,"got to AppendFile, but now I can't fopen %s\n",fname);
    return(-1);
    }
else {
    fwrite(to_append,1,size,fptr);
    fclose(fptr);
    return(0);
    }
}


void DisplayFile(fname,type,target)
char *fname;
char *type;
char *target;
{

char cmd[1024];
int i;
Boolean done;
void MXQCreateMiniTED();
void MXQRealizeMiniTED();

if (strcmp(type,"TEXT")==0) {
   sprintf(cmd,"rm %s",fname);
   system(cmd);

   i=0; done = False;
		while (! done) {
			if (waisviewer[i]==NULL) done=True;
/*			else if (!XtIsRealized(waisviewer[i])) done=True; */
			else if (waisviewer_in_use[i] == False) done=True;
			if (! done) i=i+1;
			if (i ==7) done = True;
			}

		if (i == (numviewers -1)) {
/*			fprintf(stderr,"gonna have to create one\n"); */
			}
		else if (waisviewer[i]==NULL) {
			MXQCreateMiniTED(i);
			strcpy(waisviewer_keywords[i],XmTextGetString(mxq_tell_me_text));
			}
/*		else if (! XtIsRealized(waisviewer[i]) ) { */
		else if (waisviewer_in_use[i]==False) {
			MXQRealizeMiniTED(i);
			strcpy(waisviewer_keywords[i],XmTextGetString(mxq_tell_me_text));
			}
		else {
			fprintf(stderr,"mxwais has entered an inconsistent state.  error 232.\n");
			}
   if (i != (numviewers-1) ) { 
		XmTextSetString(waisviewer_text[i],show_buffer);
		free(show_buffer);
		show_buffer = NULL;
		strcpy(waisviewer_keywords[i],XmTextGetString(mxq_tell_me_text));
		}

   }
else if (strcmp(type,"GIF")==0) {
   sprintf(cmd,"(xloadimage %s ; rm %s) &",fname,fname); 
   system(cmd);
   }
else if (strcmp(type,"TIFF")==0) {
   sprintf(cmd,"(xv %s ; rm %s) &",fname,fname);
   system(cmd);
   }
else if (strcmp(type,"PICT")==0) {
   sprintf(cmd,"(pictview %s ; rm %s) &",fname,fname);
   system(cmd);
   }
else if (strcmp(type,"WSRC")==0) {
   char savesourceas[256], *clip, sourcename[256], *homedir;
   int len;

   clip= strchr(target,' ');
   len = (clip-target)+1;
   if (clip==NULL) len=strlen(target);  /* odd server return fix */
   strncpy(sourcename,target,len);
   sourcename[len]='\0';
   homedir= (char *)getenv("HOME");
   sprintf(savesourceas,"%s/wais-sources/%s",homedir,sourcename);
   sprintf(cmd,"(mwsrc %s %s; rm %s) &",fname,savesourceas,fname);
   system(cmd);
   }
}




/***************************
 ***************************

  QUESTION CODE STARTS HERE

 ***************************
 ***************************/

void CreateMotifQuestionInterface(argc,argv)
int argc;
char **argv;
{
int i;
void MXQCreateMain(),MXQCreateMenu(),MXQCreateWorkForm();
void MXQCreateTopLabel(),MXQCreateTellMeLabel(),MXQCreateTellMeText();
void MXQCreateByAskingLabel(),MXQCreateByAskingList(),MXQCreateAddPersButton();
void MXQCreateDeleteThisButton();
void MXQCreateDoSearchButton(),MXQCreateAbortButton();
void MXQCreateSep(), MXQCreateRelevanceLabel();
void MXQCreateRelevanceList(), MXQCreateRelevanceRemoveButton();
void MXQCreateStatusLabel();




mxq_app_shell = XtInitialize(argv[0],"MXQWais",NULL,0,&argc,argv);

WaisSourceDir = XGetDefault(XtDisplay(mxq_app_shell),"mxqwais","waisCommonSourceDir");
/* fprintf(stderr,"waissourcedir = %s\n",WaisSourceDir); */


MXQCreateMain();
MXQCreateMenu();
MXQCreateWorkForm();

MXQCreateTopLabel();
MXQCreateTellMeLabel();
MXQCreateTellMeText();

MXQCreateByAskingLabel();
MXQCreateByAskingList();
MXQCreateAddPersButton();
MXQCreateDeleteThisButton();

MXQCreateRelevanceLabel();
MXQCreateRelevanceList();
MXQCreateRelevanceRemoveButton();


MXQCreateDoSearchButton();
/* ac=0;
XtSetArg(al[ac],XmNdefaultButton,mxq_do_search_button); ac++;
XtSetValues(mxq_work_form,al,ac); */

/* MXQCreateAbortButton(); */  /*so much for aborting a question in progress*/
MXQCreateStatusLabel();

/* MXSCreateSep(); */

XtRealizeWidget(mxq_app_shell);
numsources=0; /* There are no sources loaded yet */
numviewers=8;
waisviewer      = (Widget *) malloc(numviewers*sizeof(Widget));
waisviewer_main = (Widget *) malloc(numviewers*sizeof(Widget));
waisviewer_menu = (Widget *) malloc(numviewers*sizeof(Widget));
waisviewer_text = (Widget *) malloc(numviewers*sizeof(Widget));
waisviewer_in_use = (Boolean *)malloc(numviewers*sizeof(Boolean));
waisviewer_savedialog = (Widget *) malloc(numviewers*sizeof(Widget));

for (i=0; i< numviewers; i++) {
   waisviewer[i] = waisviewer_main[i] = waisviewer_menu[i] = waisviewer_text[i] = NULL;
   waisviewer_in_use[i] = False;
   }

/* waisq_init();  */   /* why did I do this twice??? */
waisq_init();

}





void MXQCreateMain()
{
int ac = 0;
Arg al[2];

mxq_mainer = XmCreateMainWindow (mxq_app_shell, "mxq_mainer", al, ac);
XtManageChild (mxq_mainer);
}


void MXQCreateMenu()
{
int ac = 0;
Arg al[10];
Widget menu_pane;
Widget cascade;
Widget test_button;

mxq_menu_bar = XmCreateMenuBar (mxq_mainer,"mxq_menu_bar", al, ac);
XtManageChild (mxq_menu_bar);

ac = 0;
menu_pane = XmCreatePulldownMenu (mxq_menu_bar, "menu_pane", al, ac);

mxq_menu_quit_button=g_make_option("Quit",'Q',MXQ_MENU_QUIT,True,MXQMenuCB,menu_pane,"Meta+Q","Meta<Key>q:");
test_button=g_make_option("Test",'T',MXQ_MENU_TEST,True,MXQMenuCB,menu_pane,"Meta+T","Meta<Key>t:");

/* make the menu */
ac = 0;
XtSetArg (al[ac], XmNsubMenuId, menu_pane);  ac++;
XtSetArg(al[ac], XmNlabelString,
	 XmStringCreateLtoR("File", XmSTRING_DEFAULT_CHARSET)); ac++;
XtSetArg(al[ac], XmNmnemonic, 'F'); ac++;
cascade = XmCreateCascadeButton (mxq_menu_bar, "File", al, ac);
XtManageChild (cascade);


}

void MXQCreateWorkForm()
{
int ac=0;
Arg al[2];

mxq_work_form = XmCreateForm(mxq_mainer, "mxq_work_form", al, ac);
XtManageChild(mxq_work_form);
}


void MXQCreateTopLabel()
{
int ac=0;
Arg al[2];

mxq_top_label = XmCreateLabel(mxq_work_form, "mxq_top_label", al, ac);
XtManageChild(mxq_top_label);
}



void MXQCreateTellMeLabel()
{
int ac=0;
Arg al[2];

mxq_tell_me_label = XmCreateLabel(mxq_work_form, "mxq_tell_me_label", al, ac);
XtManageChild(mxq_tell_me_label);
}


void MXQCreateTellMeText()
{
int ac=0;
Arg al[2];

mxq_tell_me_text = XmCreateText(mxq_work_form, "mxq_tell_me_text", al, ac);
XtManageChild(mxq_tell_me_text);
XtAddCallback(mxq_tell_me_text,XmNactivateCallback,MXQButtonCB,MXQ_BUTTON_RUN_SEARCH);

}



void MXQCreateByAskingLabel()
{
int ac=0;
Arg al[2];

mxq_by_asking_label = XmCreateLabel(mxq_work_form, "mxq_by_asking_label", al, ac);
XtManageChild(mxq_by_asking_label);
}



void MXQCreateByAskingList()
{
int ac=0;
Arg al[2];

mxq_by_asking_list_frame=XmCreateFrame(mxq_work_form,"mxq_by_asking_list_frame", al, ac);
XtManageChild(mxq_by_asking_list_frame);

mxq_by_asking_list = XmCreateScrolledList(mxq_by_asking_list_frame, "mxq_by_asking_list", al, ac);
XtManageChild(mxq_by_asking_list);
/* AddHit("eos-online-help.src",mxq_by_asking_list);  */
/*   escott -- a debugging remnant, used by ancients */



}



void MXQCreateAddPersButton()
{
int ac=0;
Arg al[2];

mxq_add_pers_button = XmCreatePushButton(mxq_work_form, "mxq_add_pers_button", al, ac);
XtManageChild(mxq_add_pers_button);
XtAddCallback(mxq_add_pers_button,XmNactivateCallback,MXQButtonCB,MXQ_BUTTON_ADD_PERS);

}


void MXQCreateDeleteThisButton()
{
int ac=0;
Arg al[2];

mxq_delete_this_button = XmCreatePushButton(mxq_work_form, "mxq_delete_this_button", al, ac);
XtManageChild(mxq_delete_this_button);
XtAddCallback(mxq_delete_this_button,XmNactivateCallback,MXQButtonCB,MXQ_BUTTON_DELETE_PERS);


}

void MXQCreateRelevanceLabel()
{
int ac=0;
Arg al[2];

mxq_relevance_label = XmCreateLabel(mxq_work_form, "mxq_relevance_label", al, ac);
XtManageChild(mxq_relevance_label);
}



void MXQCreateRelevanceList()
{
int ac=0;
Arg al[2];

mxq_relevance_list_frame=XmCreateFrame(mxq_work_form,"mxq_relevance_list_frame", al, ac);
XtManageChild(mxq_relevance_list_frame);

mxq_relevance_list = XmCreateScrolledList(mxq_relevance_list_frame,"mxq_relevance_list", al, ac);
XtManageChild(mxq_relevance_list);
}


void MXQCreateRelevanceRemoveButton()
{
int ac=0;
Arg al[2];

mxq_relevance_remove_button = XmCreatePushButton(mxq_work_form, "mxq_relevance_remove_button", al, ac);
XtAddCallback(mxq_relevance_remove_button,XmNactivateCallback,MXQButtonCB,MXQ_BUTTON_DELETE_THIS);
XtManageChild(mxq_relevance_remove_button);
}


void MXQCreateDoSearchButton()
{
int ac=0;
Arg al[2];

mxq_do_search_button = XmCreatePushButton(mxq_work_form, "mxq_do_search_button", al, ac);
XtManageChild(mxq_do_search_button);
XtAddCallback(mxq_do_search_button,XmNactivateCallback,MXQButtonCB,MXQ_BUTTON_RUN_SEARCH);

}

/*
void MXQCreateAbortButton()
{
int ac=0;
Arg al[2];
extern void Abort();

mxq_abort_button = XmCreatePushButton(mxq_work_form, "mxq_abort_button", al, ac);
XtManageChild(mxq_abort_button); 
XtAddCallback(mxq_abort_button,XmNactivateCallback,Abort,MXQ_BUTTON_RUN_SEARCH);

}
*/

void MXQCreateStatusLabel()
{
int ac=0;
Arg al[3];


XtSetArg(al[ac], XmNlabelString, XmStringCreateLtoR
        (" ", XmSTRING_DEFAULT_CHARSET));  ac++;
XtSetArg(al[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
mxq_status_label = XmCreateLabel(mxq_work_form, "mxq_status_label", al, ac);
XtManageChild(mxq_status_label);
}



void MXQCreateSourceFileDialog()
{
int ac=0;
Arg al[10];
void MXQDialogAcceptCB();
void MXQDialogCancelCB();
char tfn[256];
char command[256];
FILE *infile;
Boolean cont,hasHomeSources;
XmString *xmstr;
int i;
char *homedir;
char waissourcedir[256];

homedir = (char *)getenv("HOME");
sprintf(waissourcedir,"%s/wais-sources",homedir);
hasHomeSources = access(waissourcedir,X_OK);
/* fprintf(stderr,"hasHomeSources = %d\n",hasHomeSources);*/

sprintf(tfn,"/tmp/mxqls%d",getpid());
if (WaisSourceDir != NULL) {
   if (hasHomeSources == 0) {
      sprintf(command,"ls -1 $HOME/wais-sources %s |grep -v / | sort | uniq > %s",WaisSourceDir,tfn);
      }
   else {
        sprintf(command,"ls -1  %s |grep -v / | sort | uniq > %s",WaisSourceDir,tfn);
        }
   }
else {
   if (hasHomeSources  == 0) {
      sprintf(command,"ls -1 $HOME/wais-sources  |grep -v / | sort > %s",tfn);
      }
   else {
      fprintf(stderr,"No Sources available.\n");
      return;
      }
   }
system(command);
infile=fopen(tfn,"r");
wais_sources_ghost_num=0;
cont = True;
while (cont) {
   if (fscanf(infile,"%s",wais_sources_ghost[wais_sources_ghost_num]) == EOF) {
      cont=False;
      }
   if (strlen(wais_sources_ghost[wais_sources_ghost_num]) >0 ) wais_sources_ghost_num++;
   if (wais_sources_ghost_num >= MAXWAISSOURCES) cont=False;
   }
fclose(infile);

xmstr= (XmString *) XtMalloc(sizeof(XmString) * MAXWAISSOURCES);
for (i=0; i<wais_sources_ghost_num; i++) {
   xmstr[i]=XmStringCreate(wais_sources_ghost[i],XmSTRING_DEFAULT_CHARSET);
   }

if (mxq_source_file_dialog == NULL) {
   mxq_source_file_dialog=XmCreateSelectionDialog(mxq_app_shell,"mxq_source_file_dialog",al,ac);
   XtAddCallback (	mxq_source_file_dialog, XmNokCallback,
			MXQDialogAcceptCB, MXQ_DIALOG_SOURCE);
   XtAddCallback (	mxq_source_file_dialog, XmNcancelCallback,
			MXQDialogCancelCB, MXQ_DIALOG_SOURCE);
   }

ac=0;
XtSetArg(al[ac],XmNitemCount,wais_sources_ghost_num); ac++;
XtSetArg(al[ac],XmNitems,xmstr); ac++;
XtSetValues(XmSelectionBoxGetChild(mxq_source_file_dialog,XmDIALOG_LIST),al,ac);

}





void MXQCreateNoSourcesDialog()
{
int ac=0;
Arg al[2];

	mxq_no_sources_dialog = XmCreateMessageDialog(mxq_app_shell,
			       "mxq_no_sources_dialog", al, ac);
	XtAddCallback (mxq_no_sources_dialog, XmNokCallback,
			MXQDialogAcceptCB, MXQ_DIALOG_NO_SOURCES);
	XtUnmanageChild(XmMessageBoxGetChild(mxq_no_sources_dialog,
			XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(mxq_no_sources_dialog,
			XmDIALOG_HELP_BUTTON));

}


void MXQLoadSource(filename)
char *filename;
{
char *newfilename;


if ( (newfilename=strrchr(filename,'/'))!=NULL )  {
   AddHit(newfilename+1,mxq_by_asking_list);
   strcpy(sourcenames[numsources],newfilename+1);
   }
else {
   AddHit(filename,mxq_by_asking_list);
   strcpy(sourcenames[numsources],filename);
   }
numsources++;
}




void MXQBuildAndRunSearch()
{

char *keywords;

   keywords=XmTextGetString(mxq_tell_me_text);
   waisq_main(NULL,NULL,sourcenames,keywords);

}

void MXQCreateMiniTEDmenu(num)
int num;

{
int ac = 0;
Arg al[10];
Widget menu_pane;
Widget cascade;
Widget menu_button;
void MXQMiniTEDcloseCB();
void MXQMiniTEDsearchCB();
void MXQMiniTEDsaveCB();

ac = 0;
menu_pane = XmCreatePulldownMenu (waisviewer_menu[num], "menu_pane", al, ac);

menu_button=g_make_option("Save...",'S',num,True,MXQMiniTEDsaveCB,menu_pane,"Meta+S","Meta<Key>s:");
menu_button=g_make_option("Find Keyword",'K',num,True,MXQMiniTEDsearchCB,menu_pane,"Find","<Key>Find:");
menu_button=g_make_option("Quit Waisviewer",'Q',num,True,MXQMiniTEDcloseCB,menu_pane,"Meta+Q","Meta<Key>q:");

/* make the menu */
ac = 0;
XtSetArg (al[ac], XmNsubMenuId, menu_pane);  ac++;
XtSetArg(al[ac], XmNlabelString,
	 XmStringCreateLtoR("File", XmSTRING_DEFAULT_CHARSET)); ac++;
XtSetArg(al[ac], XmNmnemonic, 'F'); ac++;
cascade = XmCreateCascadeButton (waisviewer_menu[num], "File", al, ac);
XtManageChild (cascade);


}

void MXQCreateMiniTED(num)
int num;
{
int ac=0;
Arg al[20];
Widget former,rowcol;
Widget button;
void MXQMiniTEDcloseCB();
void MXQMiniTEDsearchCB();
void MXQMiniTEDsaveCB();

waisviewer[num]=XtAppCreateShell("waisviewer","Waisviewer",applicationShellWidgetClass,
                         XtDisplay(mxq_app_shell),al,ac);
waisviewer_main[num]=XmCreateMainWindow(waisviewer[num],"waisviewer_main",al,ac);
XtManageChild(waisviewer_main[num]);
waisviewer_menu[num]=XmCreateMenuBar(waisviewer_main[num],"waisviewer_menu",al,ac);
XtManageChild(waisviewer_menu[num]);
MXQCreateMiniTEDmenu(num);

ac=0;
former  =  XmCreateForm(waisviewer_main[num],"waisviewer_form",al,ac);
XtManageChild(former);

ac=0;
XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM); ac++;
XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM); ac++;
XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM); ac++;
rowcol =   XmCreateRowColumn(former,"rowcol",al,ac);
XtManageChild(rowcol);

ac=0;
button = XmCreatePushButton(rowcol,"save_button",al,ac);
XtAddCallback (button, XmNactivateCallback, MXQMiniTEDsaveCB, num);
XtManageChild(button);

ac=0;
button = XmCreatePushButton(rowcol,"search_button",al,ac);
XtAddCallback (button, XmNactivateCallback, MXQMiniTEDsearchCB, num);
XtManageChild(button);

ac=0;
button = XmCreatePushButton(rowcol,"close_button",al,ac);
XtAddCallback (button, XmNactivateCallback, MXQMiniTEDcloseCB, num);
XtManageChild(button);


XtSetArg(al[ac],XmNeditMode,XmMULTI_LINE_EDIT);          ac++;
XtSetArg(al[ac],XmNcolumns,80);                          ac++;
XtSetArg(al[ac],XmNrows,24);                             ac++;
XtSetArg(al[ac],XmNscrollVertical,True);                 ac++;
XtSetArg(al[ac],XmNscrollHorizontal,True);               ac++;
XtSetArg (al[ac], XmNresizeWidth, False);                ac++;
XtSetArg (al[ac], XmNresizeHeight, False);               ac++;
XtSetArg(al[ac],XmNscrollingPolicy, XmSTATIC);           ac++;
XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);         ac++;
XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);       ac++;
XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);        ac++;
XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_WIDGET);    ac++;
XtSetArg(al[ac],XmNbottomWidget,rowcol);                 ac++;

waisviewer_text[num]=XmCreateScrolledText(former,"waisviewer_text",al,ac);
XtManageChild(waisviewer_text[num]);

XmMainWindowSetAreas(waisviewer_main[num],waisviewer_menu[num],NULL,NULL,NULL,former);

XtRealizeWidget(waisviewer[num]);
waisviewer_in_use[num]=True;


}



void MXQMenuCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{

int i;
void MXQRealizeMiniTED();
void MXQCreateMiniTED();
Boolean done;


	switch ((int)client_data)
	{

	case MXQ_MENU_QUIT:
		exit(0);
		break; /* unreachable */
	case MXQ_MENU_TEST:
		i=0; done = False;
		while (! done) {
			if (waisviewer[i]==NULL) done=True;
/*			else if (!XtIsRealized(waisviewer[i])) done=True; */
			else if (!XtIsManaged(waisviewer[i])) done=True;

			if (! done) i=i+1;
			if (i ==7) done = True;
			}

		if (i == (numviewers -1)) {
/*			fprintf(stderr,"gonna have to create one\n"); */
			}
		else if (waisviewer[i]==NULL) {
			MXQCreateMiniTED(i);
			}
/*		else if (! XtIsRealized(waisviewer[i]) ) {*/
		else if (! XtIsManaged(waisviewer[i]) ) {

			MXQRealizeMiniTED(i);
			}
		else {
			fprintf(stderr,"mxwais has entered an inconsistent state.  error 231.\n");
			}
		break;
	default:
		break;

	}
}





void MXQMiniTEDcloseCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{



/* XtUnmanageChild(waisviewer_text[(int)client_data]); */
/* XtUnmanageChild(waisviewer_menu[(int)client_data]); */
XtUnmanageChild(waisviewer_main[(int)client_data]);

/* XtUnrealizeWidget(waisviewer[(int)client_data]); */
XtUnmapWidget(waisviewer[(int)client_data]);
waisviewer_in_use[(int)client_data] = False;


}


void MXQMiniTEDsearchCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{

int num = (int)client_data;
int i=0;
int j=0;
int k=0;
int done = 0;
int hitlen = 0;
int l = 0;
int endOfBuffer;
int whereCursor;
char searchFor[64][64];
char *searchThis;
char keywords[256];
char *hits[64],*firstHit;


strcpy(keywords,waisviewer_keywords[num]);
searchThis = XmTextGetString(waisviewer_text[num]);
whereCursor = XmTextGetInsertionPosition(waisviewer_text[num]);
endOfBuffer = XmTextGetLastPosition(waisviewer_text[num]);
/* searchThis[endOfBuffer+1]='\0';*/    /* looks like you have to null terminate it yourself... */

lowercase(keywords);
lowercase(searchThis);

while(done==0) {
   for (k=0; (keywords[j] != ' ') && (keywords[j] != '\0'); k++,j++) {
      searchFor[i][k] = keywords[j];
      }
   while (keywords[j]==' ') j++;

   searchFor[i][k]='\0';
   if (keywords[j]=='\0') done = 1;
   i=i+1;
   }

/* break it, and let's see the keywords array! */
/* i is now the number of keywordsw found, so you can access up to [i-1] */

for (l=0; l<i; l++) {
   hits[l]=e_strstr(searchThis+whereCursor,searchFor[l]);  /* use mine 'til rest of world catches on */
   }

firstHit = searchThis+endOfBuffer+1;
for (l=0; l<i; l++) {
   if (hits[l]!=NULL) {
      if (hits[l] <= firstHit) {
         firstHit = hits[l];
         hitlen = strlen(searchFor[l]);
         }
      }
   }
if (firstHit != searchThis+endOfBuffer+1) {
   XmTextSetSelection(waisviewer_text[num],firstHit-searchThis, (firstHit - searchThis)+hitlen, CurrentTime);
   XmTextSetInsertionPosition(waisviewer_text[num],(firstHit - searchThis)+hitlen);
   }

}


void MXQMiniTEDsaveCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{
int num = (int)client_data;
void MXQCreateMiniTEDSaveDialog();


if (waisviewer_savedialog[num] == NULL)
    MXQCreateMiniTEDSaveDialog(num);
XtManageChild(waisviewer_savedialog[num]);


}


static void focusTO(data,dummy)
char *data;
XtIntervalId *dummy;
{
    XmProcessTraversal((Widget) data, XmTRAVERSE_CURRENT);
}



static void focusCB(w,data,dummy) 
Widget w;
XtPointer data,dummy;
{
    XtRemoveCallback(w, XmNfocusCallback, focusCB, data);
    XtAppAddTimeOut(XtWidgetToApplicationContext(w), 0, focusTO, data);
}

void MXQMiniTEDSaveDialogCB (w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{

FILE *outfile;
XmSelectionBoxCallbackStruct *scb = (XmSelectionBoxCallbackStruct *) call_data;
char *save_as_filename,*buffer;
int count,len;
int num = (int)client_data;

/* get the filename string from the file selection box */
XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &save_as_filename);
XtUnmanageChild (w);

buffer = XmTextGetString(waisviewer_text[num]);
len = strlen(buffer);
outfile = fopen(save_as_filename,"w");
if (outfile == NULL) {
   fprintf(stderr,"can't open outfile %s\n",save_as_filename);
   }
else {
   count = fwrite(buffer,1,len,outfile);
   if (count != len ) {
      fprintf(stderr,"Only able to write %d of %d items.\n",count,len);
      }
   else {
      fclose(outfile);
      }
   }
free (save_as_filename);
free (buffer);

}


void MXQCreateMiniTEDSaveDialog(num)
int num;
{
int ac=0;
Arg al[2];
void MXQMiniTEDSaveDialogCB();

	XtSetArg(al[ac], XmNselectionLabelString, XmStringCreateLtoR
	   ("Enter name to save as:", XmSTRING_DEFAULT_CHARSET));  ac++;
	waisviewer_savedialog[num] = XmCreatePromptDialog(waisviewer[num],
			   "save file dialog", al, ac);
        XtAddCallback(waisviewer_savedialog[num], XmNfocusCallback, focusCB, 
                      XmSelectionBoxGetChild(waisviewer_savedialog[num],
                                             XmDIALOG_TEXT));

	XtUnmanageChild(XmSelectionBoxGetChild(waisviewer_savedialog[num],
			XmDIALOG_HELP_BUTTON));
	XtAddCallback (waisviewer_savedialog[num], XmNokCallback,
			MXQMiniTEDSaveDialogCB, num);
/*	XtAddCallback (new_dialog, XmNcancelCallback,
			DialogCancelCB, DIALOG_NEW);    */

}






void MXQRealizeMiniTED(i)
int i;
{

XtManageChild(waisviewer_text[i]);
XtManageChild(waisviewer_menu[i]);
XtManageChild(waisviewer_main[i]);

/*XtRealizeWidget(waisviewer[i]); */
/*XtManageChild(waisviewer[i]); */
XtMapWidget(waisviewer[i]);
waisviewer_in_use[i]=True;

}


void MXQButtonCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{
	int *positions;
	int pos_count;
        void MXQDeleteRelevant();

switch ((int)client_data)
{
case MXQ_BUTTON_RUN_SEARCH:

if (numsources == 0) {
   /* There were no sources */
   if (mxq_no_sources_dialog == NULL) {
      MXQCreateNoSourcesDialog();
      }
   XtManageChild(mxq_no_sources_dialog);
   }
else {
/*	XmProcessTraversal(mxq_do_search_button,XmTRAVERSE_CURRENT);
	XmUpdateDisplay(mxq_do_search_button); */
watch_cursor();

	MXQBuildAndRunSearch();
	MXQShowSearchResults();
normal_cursor();
	}
break;


case MXQ_BUTTON_DELETE_THIS:


if (XmListGetSelectedPos(mxq_relevance_list,&positions,&pos_count) == False) {
   return; /* nothing was selected */
   }
else {
   if (pos_count >1) fprintf(stderr,"Delete croaks on deleting more than one.\n");
   XmListDeletePos(mxq_relevance_list,positions[0]);
   MXQDeleteRelevant(positions[0]);
   }
break;

case MXQ_BUTTON_ADD_PERS:
   watch_cursor();
   MXQCreateSourceFileDialog();  /* now handles case for already created */

   XtManageChild(mxq_source_file_dialog);
   normal_cursor();

   break;

case MXQ_BUTTON_DELETE_PERS:


if (XmListGetSelectedPos(mxq_by_asking_list,&positions,&pos_count) == False) {
   return; /* nothing was selected */
   }
else {
   int i;

   if (pos_count >1) fprintf(stderr,"Delete croaks on deleting more than one.\n");
   XmListDeletePos(mxq_by_asking_list,positions[0]);
   for (i=positions[0]-1; i< numsources; i++) {
      strcpy(sourcenames[i],sourcenames[i+1]);
      }
   numsources--;
   }
break;


default:
	break;

}   /*  end of switch    */
}   /*  end of function  */




void MXQDialogAcceptCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{
	void DisplaySelectedProducts();
	char *filename=NULL;

	switch ((int)client_data)
	{
	case MXQ_DIALOG_VIEW:
		DisplaySelectedProducts(w);
		break;
	case MXQ_DIALOG_SOURCE:
                /* open the file and read it into the text widget */
		if (filename != NULL) 
		{
		   XtFree(filename);
		   filename = NULL;
                   }
		{


		   XmFileSelectionBoxCallbackStruct *fcb =
		               (XmFileSelectionBoxCallbackStruct *) call_data;

			   /* get the filename from the file selection box */
		   XmStringGetLtoR(fcb->value, XmSTRING_DEFAULT_CHARSET, &filename);
		   XtUnmanageChild(w);
		   MXQLoadSource(filename);
		   free(filename);
		}
		break;
	case MXQ_DIALOG_ERR:
		init_err_string();
		break;
	case MXQ_DIALOG_WORK:
		break;

	default:
		break;

	}
}



void MXQDialogApplyCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{

switch ((int)client_data) {
   case MXQ_DIALOG_VIEW:
      AddRelevant(w);
      break;
   }

}






void MXQDialogCancelCB(w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{

if (w == mxq_server_responses_list) {
   XtUnrealizeWidget(mxq_server_responses);
   }
else {
   XtUnmanageChild(w);
   }
}




void MXQCreateServerResponses()
{
int ac=0;
Arg al[10];

mxq_server_responses = XtAppCreateShell("responses","Responses",applicationShellWidgetClass,
                                        XtDisplay(mxq_app_shell),al,ac);



mxq_server_responses_list = XmCreateSelectionBox(mxq_server_responses, "mxq_server_responses_list", al, ac);
XtManageChild(mxq_server_responses_list);

ac=0;
XtSetArg(al[ac], XmNlabelString,
	 XmStringCreateLtoR("View", XmSTRING_DEFAULT_CHARSET)); ac++;
XtSetValues(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_OK_BUTTON),al,ac);

ac=0;
XtSetArg(al[ac], XmNlabelString,
	 XmStringCreateLtoR("Relevant", XmSTRING_DEFAULT_CHARSET)); ac++;
XtSetValues(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_APPLY_BUTTON),al,ac);
XtManageChild(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_APPLY_BUTTON));


ac=0;
XtSetArg(al[ac], XmNlabelString,
	 XmStringCreateLtoR("Cancel", XmSTRING_DEFAULT_CHARSET)); ac++;
XtSetValues(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_CANCEL_BUTTON),al,ac);

XtAddCallback(mxq_server_responses_list, XmNokCallback,
		       MXQDialogAcceptCB, MXQ_DIALOG_VIEW);

XtAddCallback(mxq_server_responses_list, XmNcancelCallback,
                       MXQDialogCancelCB, MXQ_DIALOG_VIEW);

XtAddCallback(mxq_server_responses_list, XmNapplyCallback,
			MXQDialogApplyCB, MXQ_DIALOG_VIEW);

XtUnmanageChild(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_SELECTION_LABEL));
XtUnmanageChild(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_TEXT));

}

/*
 * This procedure will ensure that, if a dialog window is being mapped,
 * its contents become visible before returning.  It is intended to be
 * used just before a bout of computing that doesn't service the display.
 * You should still call XmUpdateDisplay() at intervals during this
 * computing if possible.
 *
 * The monitoring of window states is necessary because attempts to map
 * the dialog are redirected to the window manager (if there is one) and
 * this introduces a significant delay before the window is actually mapped
 * and exposed.  This code works under mwm, twm, uwm, and no-wm.  It
 * doesn't work (but doesn't hang) with olwm if the mainwindow is iconified.
 *
 * The argument to ForceDialog is any widget in the dialog (often it
 * will be the BulletinBoard child of a DialogShell).
 */

ForceDialog(w)
     Widget w;
{
  Widget diashell, topshell;
  Window diawindow, topwindow;
  Display *dpy;
  XWindowAttributes xwa;
  XEvent event;
  XtAppContext cxt;

/* Locate the shell we are interested in.  In a particular instance, you
 * may know these shells already.
 */

  for (diashell = w;
       !XtIsShell(diashell);
       diashell = XtParent(diashell))
    ;

/* Locate its primary window's shell (which may be the same) */

  for (topshell = diashell;
       !XtIsTopLevelShell(topshell);
       topshell = XtParent(topshell))
    ;

  if (XtIsRealized(diashell) && XtIsRealized(topshell)) {
    dpy = XtDisplay(topshell);
    diawindow = XtWindow(diashell);
    topwindow = XtWindow(topshell);
    cxt = XtWidgetToApplicationContext(diashell);

/* Wait for the dialog to be mapped.  It's guaranteed to become so unless... */

    while (XGetWindowAttributes(dpy, diawindow, &xwa),
           xwa.map_state != IsViewable) {

/* ...if the primary is (or becomes) unviewable or unmapped, it's
   probably iconified, and nothing will happen. */

      if (XGetWindowAttributes(dpy, topwindow, &xwa),
          xwa.map_state != IsViewable)
        break;

/* At this stage, we are guaranteed there will be an event of some kind.
   Beware; we are presumably in a callback, so this can recurse. */

      XtAppNextEvent(cxt, &event);
      XtDispatchEvent(&event);
    }
  }

/* The next XSync() will get an expose event if the dialog was unmapped. */

  XmUpdateDisplay(topshell);
}

