/*
 * Copyright (C) 1994, 1995 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * etl_dev.c
 *
 * Purpose:
 *   This file contains some functions used to link X into the device handling
 * structures managed by the etalklibrary.
 *
 * $Log: etl_x.c,v $
 * Revision 1.3  1995/06/13  00:03:56  zappo
 * Removed a rogue simicolon
 *
 * Revision 1.2  1995/05/27  01:38:17  zappo
 * Added ETL_get_resource for reading random resources from any X app.
 *
 * Revision 1.1  1995/04/19  01:28:06  zappo
 * Initial revision
 *
 * ::Header:: etalklib.h
 */
/* In order to get at display parts, we need to announce that we are
 * trying to get at it's private parts.
 */
#define XLIB_ILLEGAL_ACCESS
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include "etalklib.h"


/*
 * Function: ETL_x
 *
 *   This routine will an X display pointer, and return an etalk IO
 * device which can be used to poll the X connection in the central
 * loop function.
 *
 * Returns:     struct InputDevice * - 
 * Parameters:  display - Pointer to display
 *
 * History:
 * zappo   5/26/95    Created
 */
struct InputDevice *ETL_x(display)
     Display *display;
{
  static struct InputDevice *X;

  if(X) return X;

  /* We always use X functions to access, so don't save the address
   */
  X = ET_gen_iodev(IO_X, display->fd, NULL);
  
  X->state = CONNECTED;
  X->name = "X_display";

  return X;
}


/*
 * Function: ETL_get_resource
 *
 *   Looks for the given resources in the X resource database.
 *
 * Returns:     int  - 
 * Parameters:  display  - Pointer to display
 *              resource - Pointer toCharacter of resource
 *              value    -  value
 * History:
 * zappo   5/26/95    Created
 */
int ETL_get_resource(display, name, class, value)
     Display *display;
     char *name, *class;
     XrmValue *value;
{
  static at_least_once = 0;
  static XrmDatabase homeDB;

  char  *str_type[20];

  if(! at_least_once)
    {
      XrmDatabase serverDB;
      char         fnamebuf[1024];
      char        *classname = "xphone";

      if(XResourceManagerString(display) != NULL)
	{
	  serverDB = XrmGetStringDatabase(XResourceManagerString(display));
	} else {
	  /* Grab Xdefaults instead */
	  if(getenv("HOME"))
	    strcpy(fnamebuf, getenv("HOME"));
	  else
	    /* No hope of getting any resources now! */
	    return;

	  strcat(fnamebuf, "/.Xdefaults");

	  serverDB = XrmGetFileDatabase(fnamebuf);
	}

      if(getenv("XENVIRONMENT"))
	{
	  strcpy(fnamebuf, getenv("XENVIRONMENT"));
	}
      else
	{
	  int len;

	  /* Grab Xdefaults-machine instead */
	  if(getenv("HOME"))
	    strcpy(fnamebuf, getenv("HOME"));
	  else
	    /* No hope of getting any resources now! */
	    return;

	  strcat(fnamebuf, "/.Xdefaults-");
	  len = strlen(fnamebuf);
	  gethostname(fnamebuf+len, sizeof(fnamebuf)-len);
	}	  

      homeDB = XrmGetFileDatabase(fnamebuf);
      XrmMergeDatabases(serverDB, &homeDB);

      at_least_once = 1;
    }

  if(verbose)
    printf("Trying to read %s from environment.\n", name);

  /*
   * Now extract the asked for string!
   */
  return XrmGetResource(homeDB, name, class, str_type, value);
  
}
