/*
 * Copyright (C) 1994, 1995 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * This header provides the UNION of all talk message types.  This
 * lets us play with one structure which can have any type of message
 * in it after the UDP read.
 *
 * etl_union.h
 *
 * Purpose:
 *  the definition in here basically links all the thre other message
 * types together because it just doesn't belong in gtalk.h
 *
 * $Log: etl_union.h,v $
 * Revision 1.2  1995/03/25  04:18:33  zappo
 * Updated copyright and comments
 *
 * Revision 1.1  1994/12/12  23:47:14  zappo
 * Initial revision
 *
 */

#ifndef _ETL_UNION
#define _ETL_UNION

/*
 * Special unions so one pointer may point to all types of responses.
 * This assumes that otalk.h, and ntalk.h have both been included
 * before this file.
 */
#ifdef _GTALK_H
union ctl_msg {
#ifdef _OTALK_H
  CTL_MSG_OLD otalk;
#endif
#ifdef _PROTOCOLS_TALKD_H
  CTL_MSG     talk;
#endif
  CTL_MSG_GNU gtalk;
};

union ctl_response {
#ifdef _OTALK_H
  CTL_RESPONSE_OLD otalk;
#endif
#ifdef _PROTOCOLS_TALKD_H
  CTL_RESPONSE     talk;
#endif
  CTL_RESPONSE_GNU gtalk;
};
#endif /* _GTALK_H */

#endif /* _ETL_UNION */
