/*
 * Copyright (C) 1995 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * et_ring.c
 *
 * Purpose:
 *  This file contains functions used to handle ringer file activity.
 * It will initially start with simply reporting to the parent process
 * the presence of a ringer activity, to eventually answering the
 * call's itself.  Of couse, the decision to answer an incomming call
 * should be made by the user, so that feature may never arrive.
 * 
 * $Log: et_ring.c,v $
 * Revision 1.3  1995/03/25  03:38:24  zappo
 * Update copyright.
 *
 * Revision 1.2  1995/02/01  03:36:53  zappo
 * Fixed ringer so it works.
 *
 * Revision 1.1  1995/01/30  22:46:15  zappo
 * Initial revision
 *
 *
 * ::Header:: etalk.h
 */
#include "etalklib.h"
#include "etalk.h"
#include "talk.h"
#include "gtalk.h"

GNU_RING_CONTROL rc;
GNU_RING_RESPONSE rr;


/*
 * Function: ETR_read
 *
 *   Reads from DEV one ringer control structure.  This structure
 * supposedly contains information relavent to an ANNOUNCE as produced
 * by a talk daemon.
 *
 * Returns:     Nothing
 * Parameters:  Ctxt - Context
 *              dev  - Pointer to device
 * History:
 * zappo   1/29/95    Created
 */
void ETR_read(Ctxt, dev)
     struct TalkContext *Ctxt;
     struct InputDevice *dev;
{
  struct InputDevice *newudp;

  ET_recv(dev, &rc, sizeof(rc));

  /* Fix byte swapping in the family so we can use this address. */
  ((struct sockaddr_in *)&rc.addr)->sin_family = 
    ntohs(((struct sockaddr_in *)&rc.addr)->sin_family);

  /* We could also use dev->lraddr, but this is more stable. In     */
  /* addition, this particular address will always be recycled too. */
  newudp = UDP_byaddr(dev, (struct sockaddr_in *)&rc.addr);
  newudp->name = "daemon_ringport";
 
  /* Always print this: This will let us see the full message in the log. */
  RING_print_control(&rc);

  /* Now formulate a response ... */
  rr.vers = TALK_VERSION_GNU;
  rr.type = rc.type;
  rr.answer = SUCCESS;
  
  /* Create a new device which happens to be the talk daemon sending */
  /* this message to me.  Hrumph!                                    */
  ET_send(newudp, &rr, sizeof(rr));

  if(verbose)
    RING_print_response(&rr);

  /* Now send special message to parent (etalk) process   */
  /* Untill I know what I want to do, just print out msg2 */
  printf("\03%c%s\n", TTY_RINGER_REPORT, rc.name);

  return;
}

