;;; minibuffer-yank.el

;;; Use this to yank the default or typical response into the minibuffer.
;;; In CIE, this is used to yank the default tag into the buffer.  So, for
;;; example, you could type the "Class_Name::" and then C-c C-y to pull in
;;; the default which contained the unscoped tag.  Or you could yank in the
;;; tag and edit it.  And so on.  It can also be used for many other things.
;;; By default it yanks in the current buffer file name (very convenient).

;;; Copyright (C) 1993, Intellection Inc.
;;;
;;; Author: Walt Buehring
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 1, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from the
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


;;; Minibuffer Yank

(defvar minibuffer-yank-string nil
  "Bound by commands to specify string yanked by \"minibuffer-yank\" instead
of the buffer file name.")

(defun minibuffer-yank ()
  "Insert the value of 'minibuffer-yank-string' if non-nil, else the
filename of the buffer which invoked the minibuffer command."
  (interactive)
  ;; Use the previous buffer on the buffer list and ensure it has a 
  ;; filename associated with it.
  (if minibuffer-yank-string
      (insert minibuffer-yank-string)
    (and (cdr (buffer-list))
	 (let ((f (buffer-file-name (car (cdr (buffer-list))))))
	   (and f
		(insert (file-name-nondirectory f)))))))
