########################## -*- Mode: Perl -*- ##########################
##
## File             : Table.pm
##
## Description      : converts tagged format (bibdb-html)
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Leopoldo Saggin
## Created On       : Sat Jun 1 10:11:07 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Tue Jun  4 17:36:07 1996
##
## $State: Exp $
##
## $Id: Table.pm,v 5.1 1996/11/05 16:55:14 goevert Exp goevert $
##
## $Log: Table.pm,v $
## Revision 5.1  1996/11/05 16:55:14  goevert
## *** empty log message ***
##
## Revision 5.0.1.1  1996/06/04 16:15:39  goevert
## patch17: New converter Table.pm
##
########################################################################


package SFgate::Converter::Table;


use strict;


## #####################################################################
## convert
## #####################################################################
## interface for SFgate to convert one document
##
## (string) $text:     document to convert
## (string) $headline: headline of document to convert
##
## By default every document is printed with its corresponding wais
## headline. If you want to derive another headline just change
## the $headline variable according to your needs.
##
## HTML special characters (&, <, >) should be encoded in text not
## being HTML code. To do this you can use the function
## &::encode_entities, e.g. $ntext = &::encode_entities($ntext)
## encodes the special chars in $ntext.
##
## returns:
## - string: the converted document ($ntext)
## - string: headline of converted document ($headline)
##
sub convert
{
    my($text, $headline) = @_;
    ## local variables
    local($_);
    my($headtag, $headpos, $head, $label, $value);
    ## return value
    my($ntext);

    if ($text =~ /(<h[0-9]>)/i) {
        $headtag = $1;
        $headpos = index($text, $headtag);
        $head    = substr($text, $headpos + 4, 300);
        $headtag =~ s:<:</:;
        $head    =~ s:($headtag)(.|\n)*::i;
        $text    =  substr($text, 0, $headpos) .
        substr($text, $headpos + 4 + length($head) + length($1));
    }
    $headline = $head  if $head;

    # emphasize labels
    for (split('\n', $text)) {
        next if /^$/;
        ($label, $value) = m/^\s*(\w+):(.*)/;
        if ($value && $label =~ /^\s*\w+/) {
            $ntext .= "<TR><TD VALIGN=\"top\"><b>$label</b>:</TD><TD>$value</TD></TR>\n";
        }
        else {
            $ntext .= "$_\n";
        }       
    }
	    $ntext= "<TABLE>\n$ntext</TABLE>\n";
    return($ntext, $headline);
}


1;
