/*
 * username.c : Some people are tricky about this...
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 *
 * Compile-time parameters (config.h):
 *	HAVE_PWD :      File <pwd.h> defines getpwuid()
 *	HAVE_GETLOGIN : Function char *getlogin() exists
 */
#include <stdio.h>
#include "config.h"

#include <sys/types.h>
extern uid_t getuid();		/* not in stdlib.h, but is in unistd.h */
extern char *getenv();
#ifdef HAVE_GETPWUID
#include <pwd.h>
#endif
#ifdef HAVE_GETLOGIN
extern char *getlogin();
#endif

char *
GetUsername()
{
    char *username;

#ifdef HAVE_GETPWUID
    struct passwd *pwe;
    if ((pwe=getpwuid(getuid())) != NULL)
	    username = pwe->pw_name;
    else
#endif
#ifdef HAVE_GETLOGIN
	if ((username=getlogin()) == NULL)
#endif
	    if ((username=getenv("USER")) == NULL) {
		fprintf(stderr,"Couldn't find username, you should set $USER");
		username = "anonymous";
	    }
    return(username);
}

#ifdef STANDALONE
main()
{
    printf("%s\n",GetUsername());
    exit(0);
}
#endif /* STANDALONE */
