/*
 * hostname.c : Amamzing how hard it is to get this information...
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 *
 * Many possibilities here. The current attempt is:
 * (a) Use HOSTNAME if set, since SO many people have strange systems
 * (b) else call gethostname(), complain if it fails
 * (c) if it succeeded, call gethostbyname() to "canonicalize"
 *     the name (many systems don't return a fully-qualified name,
 *     and getdomainname() is a loss.
 */
#include <stdio.h>
#include <netdb.h>
#ifndef MAXHOSTNAMELEN
#include <sys/param.h>
#endif
#include "sysdefs.h"
#include "stringdefs.h"

char *
GetHostname()
{
    static char hostname[MAXHOSTNAMELEN];
    struct hostent *host;

    if (getenv("HOSTNAME") != NULL)
	strcpy(hostname,getenv("HOSTNAME"));
    else if (gethostname(hostname,sizeof(hostname)) != 0) {
	fprintf(stderr,"gethostname failed -- you should set $HOSTNAME");
	strcpy(hostname,"unknown.host");
    } else if ((host=gethostbyname(hostname)) == NULL) {
	fprintf(stderr,"gethostbyname failed -- you should set $HOSTNAME");
	strcpy(hostname,"unknown.host");
    } else {
	strcpy(hostname,host->h_name);
    }
    return(hostname);
}

#ifdef STANDALONE
main()
{
    printf("%s\n",GetHostname());
    exit(0);
}
#endif /* STANDALONE */

