/*
 * Copyright 1990,1991,1992 Brian Totty
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Brian Totty or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  Brian Totty and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * Brian Totty and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall Brian Totty or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	Brian Totty
 * 	Department of Computer Science
 * 	University Of Illinois at Urbana-Champaign
 *	1304 West Springfield Avenue
 * 	Urbana, IL 61801
 * 
 * 	totty@cs.uiuc.edu
 * 	
 */ 
#include <stdio.h>
#include <Directory.h>

int main(argc,argv)
int argc;
char **argv;
{
	Directory directory;
	DirEntry entry;
	int status;

	if (DirectoryOpen(argv[1],&directory) == FALSE)
	{
		fprintf(stderr,"Can't open directory '%s'\n",argv[1]);
		exit(-1);
	}
	printf("*** Listing Of Directory '%s' ***\n",
	       DirectoryPath(&directory));
	while (DirectoryReadNextEntry(&directory,&entry))
	{
		printf("<Type %5d,  File '%20s',  Mode %3d,  Size %d>\n",
		       DirEntryType(&entry),
		       DirEntryFileName(&entry),
		       DirEntryProt(&entry),
		       DirEntryFileSize(&entry));
	}
	printf("\nChange the directory please...sleeping 5 seconds...\n\n");
	sleep(5);
	DirectoryRestart(&directory);
	while (DirectoryReadNextEntry(&directory,&entry))
	{
		printf("<Type %5d,  File '%20s',  Mode %3d,  Size %d>\n",
		       DirEntryType(&entry),
		       DirEntryFileName(&entry),
		       DirEntryProt(&entry),
		       DirEntryFileSize(&entry));
	}
	return(1);
}
