/* -*- c -*-
 *
 * Author:      James A. Brister <brister@vix.com> -- berkeley-unix --
 * Start Date:  Thu, 01 Feb 1996 22:17:51 +1100
 * Project:     INN -- innfeed
 * File:        sysconfig.h
 * RCSId:       $Id: sysconfig.h,v 1.3 1996/04/13 02:51:33 brister Exp $
 *
 * Copyright:   Copyright (c) 1996 by Internet Software Consortium
 *
 *              Permission to use, copy, modify, and distribute this
 *              software for any purpose with or without fee is hereby
 *              granted, provided that the above copyright notice and this
 *              permission notice appear in all copies.
 *
 *              THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE
 *              CONSORTIUM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *              SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *              MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET
 *              SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
 *              INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *              WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *              WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 *              TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
 *              USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Description: This file should be the only thing you need to touch when
 *              moving innfeed across platforms. 
 * 
 */

/* PLEASE FORWARD ANY CHANGES YOU HAVE TO MAKE TO <brister@vix.com> AND LET
   ME KNOW WHAT, WHY AND FOR WHAT PLATFORM. THANKS. */

#ifndef sysconfig_h__
#define sysconfig_h__ 1

/**********************************************************************/
/*                     Defines for system differences.                */
/**********************************************************************/

/* same as INN's define */
#define DO_HAVE_UNISTD 1

/* same as INN's define */
#define DO_HAVE_UNIX_DOMAIN 1

/* same as INN's for maximum number of file descriptors. Choose one of these */
#define FDCOUNT_GETRLIMIT 1
/* #define FDCOUNT_GETDTAB 1 */
/* #define FDCOUNT_SYSCONF 1 */
/* #define FDCOUNT_ULIMIT 1 */
/* #define FDCOUNT_CONSTANT 1 */


/* set this to 1 if you don't have a strdup on your machine. */
#define NEED_STRDUP 0

/* set this to 1 if you don't have a `u_long', `u_int', `u_short' in your
   include path */
#define NEED_U_INT 0

/* set this to 1 if you don't have a `bool' in your include path */
#define NEED_BOOL 1

/* set to 1 if wait3 takes a union as its argument */
#define DO_USE_UNION_WAIT 1

/* Set to 1 to use waitpid() rather than wait3() */
#define DO_HAVE_WAITPID 0
 
/* set if you need to include <sys/file.h> */
#define DO_NEED_FILE 1

/* set to use fcntl to set non-blocking i/o. undefined uses ioctl. */
#define NBIO_FCNTL 1

/* set if you need to include <time.h> as well as <sys/time.h> */
#define DO_NEED_TIME 1

/* set to 1 if bind of an AF_UNIX socket uses sizeof. 0 if it uses the
   strlen of the path + the size of the sun_family integer. */
#define DO_BIND_USE_SIZEOF 1

/* define the appropriate one for your type of directory reading routines */
#define DIR_DIRENT 1
/* #define DIR_DIRECT 1 */

/* maximum number of struct iovec in a writev. Only define if UIO_MAXIOV isn't
   in any header file. Build and run the program uio_maxiov to determine
   the proper value to use here */
/* #define MAX_IOVEC 1 */

/* how syslog should be opened. */
#define OPENLOG_FLAGS (LOG_NDELAY | LOG_PERROR | LOG_PID)

/* if you're Solaris (or SVR4?) define to 1 to get sys/stream.h included. */
#define DO_NEED_STREAM 0

/* If you dont have strerror() then set to 1 */
#define NEED_STRERROR 0

/* argument type for 4th argument to getsockopt. */
#define GETSOCKOPT_ARG void *


/*
** BSD/OS
*/

#if defined (__bsdi__)
#define MAX_IOVEC 1024
#endif

/*
** LINUX
*/

#if defined (linux)
#define NEED_H_ERRLIST 1
#endif


/*
** OSF/1 aka DEC UNIX
*/

#if defined (__osf__)
#define NEED_H_ERRLIST 1

#undef GETSOCKOPT_ARG
#define GETSOCKOPT_ARG  char *

#define MAX_IOVEC  16
#endif


/*
** SOLARIS
**
** courtesy of vincent@ucthpx.uct.ac.za (Russell Vincent) and Lee McLoughlin
*/

#if defined (SOLARIS)
#define LOG_PERROR 0
#define NEED_STRERROR 1
#define GETSOCKOPT_ARG char *
#define FNDELAY O_NONBLOCK

#define DO_HAVE_WAITPID 1
 
#define wait3(a,b,c) waitpid(-1,a,b)

#undef GETSOCKOPT_ARG
#define GETSOCKOPT_ARG  char *

#define MAX_IOVEC  16

#define DO_NEED_STREAM 1
#endif



/*
** SunOS 4.x
*/

#if defined (sun)
#endif


#endif /* sysconfig_h__ */
