/* EBCDIC.H   V1.0
 | The EBCDIC characters.
 */

/* Control characters: */
#define	NUL	0x0		/* Null */
#define	SOH	0x1		/* Start of Header */
#define	STX	0x2		/* Start of text */
#define	DLE	0x10		/* Data Link Escape */
#define	ETB	0x26		/* End of Transmission Block */
#define	ENQ	0x2d		/* Enquire */
#define	SYN	0x32		/* Synchronization character */
#define	NAK	0x3d		/* Negative Ack */
#define	ACK0	0x70		/* Positive ACK */
#define	PAD	0xff		/* Pad character */

/* The written characters */
#define E_MINUS 0x60	/* - */
#define	E_PLUS	0x4e	/* + */
#define	E_SP	0x40
#define	E_A	0xc1
#define	E_B	0xc2
#define	E_C	0xc3
#define	E_D	0xc4
#define	E_E	0xc5
#define	E_F	0xc6
#define	E_G	0xc7
#define	E_H	0xc8
#define	E_I	0xc9
#define	E_J	0xd1

#define	E_M	0xd4
#define	E_N	0xd5
#define	E_R	0xd9
#define	E_Y	0xe8

#define	E_0	0xf0
#define	E_1	0xf1
#define	E_2	0xf2
#define	E_3	0xf3
#define	E_4	0xf4
#define	E_5	0xf5
#define	E_6	0xf6
#define	E_7	0xf7
#define	E_8	0xf8
#define	E_9	0xf9

#ifdef MAIN		/* Define the full table */
/* Conversion table into EBCDIC */
unsigned char	ASCII_EBCDIC[256] = {
	0000, 0001, 0002, 0003, 0067, 0055, 0056, 0057,
	0026, 0005, 0045, 0013, 0014, 0015, 0016, 0017,
	0020, 0021, 0022, 0023, 0074, 0075, 0062, 0046,
	0030, 0031, 0077, 0047, 0042, 0035, 0065, 0037,
	0100, 0132, 0177, 0173, 0133, 0154, 0120, 0175,
	0115, 0135, 0134, 0116, 0153, 0140, 0113, 0141,
	0360, 0361, 0362, 0363, 0364, 0365, 0366, 0367,
	0370, 0371, 0172, 0136, 0114, 0176, 0156, 0157,
	0174, 0301, 0302, 0303, 0304, 0305, 0306, 0307,
	0310, 0311, 0321, 0322, 0323, 0324, 0325, 0326,
	0327, 0330, 0331, 0342, 0343, 0344, 0345, 0346,
	0347, 0350, 0351, 0255, 0340, 0275, 0137, 0155,
	0171, 0201, 0202, 0203, 0204, 0205, 0206, 0207,
	0210, 0211, 0221, 0222, 0223, 0224, 0225, 0226,
	0227, 0230, 0231, 0242, 0243, 0244, 0245, 0246,
	0247, 0250, 0251, 0300, 0152, 0320, 0241, 0007,
	0101, 0102, 0103, 0104, 0105, 0106, 0107, 0110,
	0111, 0121, 0122, 0123, 0124, 0125, 0126, 0127,
	0130, 0131, 0142, 0143, 0144, 0145, 0146, 0147,
	0150, 0151, 0161, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000 };

unsigned char	EBCDIC_ASCII[256] =  {
	0000, 0001, 0002, 0003, 0000, 0011, 0000, 0177,
	0000, 0000, 0000, 0013, 0014, 0015, 0016, 0017,
	0020, 0021, 0022, 0023, 0000, 0000, 0010, 0000,
	0030, 0031, 0000, 0000, 0000, 0035, 0000, 0037,
	0000, 0000, 0034, 0000, 0000, 0012, 0027, 0033,
	0000, 0000, 0000, 0000, 0000, 0005, 0006, 0007,
	0000, 0000, 0026, 0000, 0000, 0036, 0000, 0004,
	0000, 0000, 0000, 0000, 0024, 0025, 0000, 0032,
	0040, 0200, 0201, 0202, 0203, 0204, 0205, 0206,
	0207, 0210, 0133, 0056, 0074, 0050, 0053, 0174,
	0046, 0211, 0212, 0213, 0214, 0215, 0216, 0217,
	0220, 0221, 0041, 0044, 0052, 0051, 0073, 0136,
	0055, 0057, 0222, 0223, 0224, 0225, 0226, 0227,
	0230, 0231, 0174, 0054, 0045, 0137, 0076, 0077,
	0000, 0232, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0140, 0072, 0043, 0100, 0047, 0075, 0042,
	0000, 0141, 0142, 0143, 0144, 0145, 0146, 0147,
	0150, 0151, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0152, 0153, 0154, 0155, 0156, 0157, 0160,
	0161, 0162, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0176, 0163, 0164, 0165, 0166, 0167, 0170,
	0171, 0172, 0000, 0000, 0000, 0133, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0135, 0000, 0000,
	0173, 0101, 0102, 0103, 0104, 0105, 0106, 0107,
	0110, 0111, 0000, 0000, 0000, 0000, 0000, 0000,
	0175, 0112, 0113, 0114, 0115, 0116, 0117, 0120,
	0121, 0122, 0000, 0000, 0000, 0000, 0000, 0000,
	0134, 0000, 0123, 0124, 0125, 0126, 0127, 0130,
	0131, 0132, 0000, 0000, 0000, 0000, 0000, 0000,
	0060, 0061, 0062, 0063, 0064, 0065, 0066, 0067,
	0070, 0071, 0000, 0000, 0000, 0000, 0000, 0000 };

#else		/* Define them as external */
extern unsigned char	ASCII_EBCDIC[256], EBCDIC_ASCII[256];
#endif
