/*
 * select.c
 *
 * troff2lj soft font selection routines.
 */

#include <stdio.h>
#include "hpfinfo.h"

extern char *prog_name;

static struct hpfontinfo hpftab[3];

/*
 * Initialize hpftab from the files in FINFOPREF with suffices specified
 * in fnames[0-2] (default "R", "I", "B").
 */
hp_init_fonts(fnames)
    char **fnames;
{
    register int i;

    for (i = 0; i < 3; ++i)
	hp_read_info(fnames[i], &hpftab[i]);
}

/*
 * Initialize one entry of hpftab.
 */
hp_read_info(name, info)
    char *name;
    struct hpfontinfo *info;
{
    FILE *fp;
    char path[BUFSIZ];

    strcpy(path, FINFOPREF);
    strcat(path, name);
    if (!(fp = fopen(path, "r"))) {
	fprintf(stderr, "%s: ", prog_name);
	perror(path);
    } else {
	if (fread(info, sizeof(info), 1, fp) != 1)
	    fprintf(stderr, "%s: %s is corrupt\n", prog_name, path);
	fclose(fp);
    }
}

/*
 * Send the codes to select the font mounted on position n (1-3).
 */
hp_sel_font(n)
    register int n;
{
    if (n >= 1 && n <= 3)
	hp_spec_font(&hpftab[n - 1]);
    else
	fprintf(stderr, "%s: Illegal font selection %d\n", prog_name, n);
}

/*
 * Send the codes necessary to specify a LaserJet font, except for point
 * size/pitch and symbol set (dealt with by other functions).
 */
hp_spec_font(ip)
    struct hpfontinfo *ip;
{
    printf("\033&l%dO", ip->fi_orient);
    printf("\033(s%dp", ip->fi_spacing);
    printf("%ds", ip->fi_style);
    printf("%db", ip->fi_weight);
    printf("%dT", ip->fi_typeface);
}
