/*
 * hpconfig.h
 */

#ifndef swap16

/*
 * Locations of HP font files.
 */

/* Where the LaserJet fonts usually live. */
#define FONTDIR "/usr/lib/hpfont/"

/* Prefix for HP fontinfo filenames. */
#define FINFOPREF "/usr/lib/hpfontinfo/fi"

/*
 * Multibyte numbers in font files are stored high byte first.
 * Define LOHI if your machine stores integers low byte first.
 */

/* These may need to be adjusted for different systems. */
typedef short sint16;		/* Signed 16 bit integer. */
typedef unsigned short uint16;	/* Unsigned 16 bit integer. */
typedef char schar;		/* Signed 8 bit integer. */
typedef unsigned char uchar;	/* Unsigned 8 bit integer. */

#ifdef LOHI
/* Exchange the two bytes in a 16 bit integer. */
#define swap16(i) ((i) = (((i) << 8) & 0xff00) | (((i) >> 8) & 0x00ff))
#else
/* No-op. */
#define swap16(i)
#endif /* LOHI */

#endif /* swap16 */
