#if !defined(lint) && !defined(LINT)
static char rcsid[] = "$Header: crontab.c,v 2.0 88/12/10 04:57:41 vixie Exp $";
#endif

/* Revision 1.5  87/05/02  17:33:22  paul
 * pokecron?  (RCS file has the rest of the log)
 * 
 * Revision 1.5  87/05/02  17:33:22  paul
 * baseline for mod.sources release
 * 
 * Revision 1.4  87/03/31  13:11:48  paul
 * I won't say that rs@mirror gave me this idea but crontab uses getopt() now
 * 
 * Revision 1.3  87/03/30  23:43:48  paul
 * another suggestion from rs@mirror:
 *   use getpwuid(getuid)->pw_name instead of getenv("USER")
 *   this is a boost to security...
 * 
 * Revision 1.2  87/02/11  17:40:12  paul
 * changed command syntax to allow append and replace instead of append as
 * default and no replace at all.
 * 
 * Revision 1.1  87/01/26  23:49:06  paul
 * Initial revision
 */

/* Copyright 1988 by Paul Vixie
 * All rights reserved
 *
 * Distribute freely, except: don't remove my name from the source or
 * documentation (don't take credit for my work), mark your changes (don't
 * get me blamed for your possible bugs), don't alter or remove this
 * notice.  May be sold if buildable source is provided to buyer.  No
 * warrantee of any kind, express or implied, is included with this
 * software; use at your own risk, responsibility for damages (if any) to
 * anyone resulting from the use of this software rests entirely with the
 * user.
 *
 * Send bug reports, bug fixes, enhancements, requests, flames, etc., and
 * I'll try to keep a version up to date.  I can be reached as follows:
 * Paul Vixie, 329 Noe Street, San Francisco, CA, 94114, (415) 864-7013,
 * paul@vixie.sf.ca.us || {hoptoad,pacbell,decwrl,crash}!vixie!paul
 */


#define	MAIN_PROGRAM


#include "cron.h"
#include <pwd.h>
#include <errno.h>
#include <sys/file.h>
#if defined(BSD)
# include <sys/time.h>
#endif  /*BSD*/

extern	char	*sprintf();


static int	PID;
static char	USER[MAX_UNAME], REAL_USER[MAX_UNAME];
static char	FILENAME[MAX_FNAME];
static FILE	*NEWTAB;
static int	CHECK_ERROR_COUNT;
static enum	{opt_unknown, opt_list, opt_delete, opt_replace}
		OPTION;

extern void	log_it();

#if DEBUGGING
static char	*OPTIONS[] = {"???", "list", "delete", "replace"};
#endif

static void
usage()
{
	fprintf(stderr, "usage:  %s [-u user] ...\n", PROGNAME);
	fprintf(stderr, " ... -l         (list user's crontab)\n");
	fprintf(stderr, " ... -d         (delete user's crontab)\n");
	fprintf(stderr, " ... -r file    (replace user's crontab)\n");
	exit(ERROR_EXIT);
}


main(argc, argv)
	int	argc;
	char	*argv[];
{
	void	parse_args(), set_cron_uid(), set_cron_cwd(),
		list_cmd(), delete_cmd(), replace_cmd();

	PID = getpid();
	PROGNAME = argv[0];

	setlinebuf(stderr);
	parse_args(argc, argv);
	set_cron_uid();
	set_cron_cwd();
	if (!allowed(USER)) {
		fprintf(stderr,
			"You (%s) are allowed to use this program (%s)\n",
			USER, PROGNAME);
		fprintf(stderr, "See crontab(1) for more information\n");
		log_it(REAL_USER, PID, "AUTH", "crontab command not allowed");
		exit(ERROR_EXIT);
	}
	switch (OPTION)
	{
	case opt_list:		list_cmd();
				break;
	case opt_delete:	delete_cmd();
				break;
	case opt_replace:	replace_cmd();
				break;
	}
}


static void
list_cmd()
{
	extern	errno;
	char	n[MAX_FNAME];
	FILE	*f;
	int	ch;

	log_it(REAL_USER, PID, "LIST", USER);
	(void) sprintf(n, CRON_TAB(USER));
	if (!(f = fopen(n, "r")))
	{
		if (errno == ENOENT)
			fprintf(stderr, "no crontab for %s\n", USER);
		else
			perror(n);
		exit(ERROR_EXIT);
	}

	/* file is open. copy to stdout, close.
	 */
	Set_LineNum(1)
	while (EOF != (ch = get_char(f)))
		putchar(ch);
	fclose(f);
}


static void
delete_cmd()
{
	extern	errno;
	int	unlink();
	void	poke_daemon();
	char	n[MAX_FNAME];

	log_it(REAL_USER, PID, "DELETE", USER);
	(void) sprintf(n, CRON_TAB(USER));
	if (unlink(n))
	{
		if (errno == ENOENT)
			fprintf(stderr, "no crontab for %s\n", USER);
		else
			perror(n);
		exit(ERROR_EXIT);
	}
	poke_daemon();
}


static void
check_error(msg)
	char	*msg;
{
	CHECK_ERROR_COUNT += 1;
	fprintf(stderr, "\"%s\", line %d: %s\n", FILENAME, LINE_NUMBER, msg);
}


static void
replace_cmd()
{
	char	*sprintf();
	entry	*load_entry();
	int	load_env();
	int	unlink();
	void	free_entry();
	void	check_error();
	void	poke_daemon();
	extern	errno;

	char	n[MAX_FNAME], envstr[MAX_ENVSTR];
	FILE	*old;
	int	ch;
	entry	*e;
	int	status;

	/* this code is a little bizarre because it was once part of an
	 * "append" option.  we should probably be writing into a temp
	 * file somewhere and not unlinking the old crontab until the
	 * new one was guaranteed to be installable.  HINT
	 */

	log_it(REAL_USER, PID, "REPLACE", USER);
	(void) sprintf(n, CRON_TAB(USER));
	if (unlink(n))
	{
		/* we only care about the error if it was other than ENOENT.
		 */
		if (errno != ENOENT)
		{
			perror(n);
			exit(ERROR_EXIT);
		}
	}

	/* check the syntax of the file being installed.
	 */

	/* BUG: was reporting errors after the EOF if there were any errors
	 * in the file proper -- kludged it by stopping after first error.
	 *		vix 31mar87
	 */
	CHECK_ERROR_COUNT = 0;
	while (!CHECK_ERROR_COUNT && ERR != (status = load_env(envstr, NEWTAB)))
	{
		if (status == FALSE)
		{
			if (NULL != (e = load_entry(NEWTAB, check_error)))
				free((char *) e);
		}
	}
	if (CHECK_ERROR_COUNT != 0)
	{
		fprintf(stderr, "errors in crontab file, can't install.\n");
		exit(ERROR_EXIT);
	}
	rewind(NEWTAB);

	/* open the old file for append-access.  this depends on the file
	 * being created if it does not exist.
	 */
	if (!(old = fopen(n, "a")))
	{
		perror(n);
		exit(ERROR_EXIT);
	}

	/* append the new to the old
	 */
	Set_LineNum(1)
	while (EOF != (ch = get_char(NEWTAB)))
		putc(ch, old);

	/* close them and we're done
	 */
	fclose(old);

	/* set the file to be owned by root
	 */
	if (ERR == chown(n, ROOT_UID, -1))
	{
		perror("chown");
		unlink(n);
		exit(ERROR_EXIT);
	}

	/* change mode of file, don't do it in fopen() above because file
	 * may not be new.
	 */
	if (ERR == chmod(n, 0600))
	{
		perror("chown");
		unlink(n);
		exit(ERROR_EXIT);
	}

	poke_daemon();
}


static void
poke_daemon()
{
#if defined(BSD)
	struct timeval tvs[2];
	struct timezone tz;

	(void) gettimeofday(&tvs[0], &tz);
	tvs[1] = tvs[0];
	if (utimes(SPOOL_DIR, tvs) == ERR)
	{
		fprintf(stderr, "crontab: can't update mtime on spooldir\n");
		perror(SPOOL_DIR);
		return;
	}
#endif  /*BSD*/
#if defined(ATT)
	fprintf(stderr, "crontab: poke_daemon() needs to be implemented\n");
#endif  /*ATT*/
}
	

static void
parse_args(argc, argv)
	int	argc;
	char	*argv[];
{
	void		usage();
	char		*getenv(), *strcpy();
	int		getuid();
	struct passwd	*getpwnam();
	extern int	getopt(), optind;
	extern char	*optarg;

	struct passwd	*pw;
	int		argch;

	if (!(pw = getpwuid(getuid())))
	{
		fprintf(stderr, "your UID isn't in the passwd file.\n");
		fprintf(stderr, "bailing out.\n");
		exit(ERROR_EXIT);
	}
	strcpy(USER, pw->pw_name);
	strcpy(REAL_USER, USER);
	FILENAME[0] = '\0';
	OPTION = opt_unknown;
	while (EOF != (argch = getopt(argc, argv, "u:ldr:x:")))
	{
		switch (argch)
		{
		case 'x':
			if (!set_debug_flags(optarg))
				usage();
			break;
		case 'u':
			if (getuid() != ROOT_UID)
			{
				fprintf(stderr,
					"must be privileged to use -u\n");
				exit(ERROR_EXIT);
			}
			if ((struct passwd *)NULL == getpwnam(optarg))
			{
				fprintf(stderr, "%s:  user `%s' unknown\n",
					PROGNAME, optarg);
				exit(ERROR_EXIT);
			}
			(void) strcpy(USER, optarg);
			break;
		case 'l':
			if (OPTION != opt_unknown)
				usage();
			OPTION = opt_list;
			break;
		case 'd':
			if (OPTION != opt_unknown)
				usage();
			OPTION = opt_delete;
			break;
		case 'r':
			if (OPTION != opt_unknown)
				usage();
			OPTION = opt_replace;
			(void) strcpy(FILENAME, optarg);
			break;
		default:
			usage();
		}
	}

	endpwent();

	if (OPTION == opt_unknown || argv[optind] != NULL)
		usage();

	if (OPTION == opt_replace) {
		if (!FILENAME[0]) {
			/* getopt(3) says this can't be true
			 * but I'm paranoid today.
			 */
			fprintf(stderr, "filename must be given for -a or -r\n");
			usage();
		}
		/* we have to open the file here because we're going to
		 * chdir(2) into /var/cron before we get around to
		 * reading the file.
		 */
		if (!(NEWTAB = fopen(FILENAME, "r"))) {
			perror(FILENAME);
			exit(ERROR_EXIT);
		}
	}

	Debug(DMISC, ("user=%s, file=%s, option=%s\n",
					USER, FILENAME, OPTIONS[(int)OPTION]))
}
