/*
 * tasyslog() -- support routine for ZMailer transport agents.
 * Copyright 1997, Matti Aarnio <mea@nic.funet.fi>
 *
 * The purpose of this routine is to produce similar syslog entries
 * to those that sendmail(8) does for its message processing.
 *
 */

#include "hostenv.h"
#include <stdio.h>
#include <sysexits.h>
#ifdef HAVE_STDARG_H
# include <stdarg.h>
#else
# include <varargs.h>
#endif
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "zsyslog.h"
#include "mail.h"

void
rtsyslog(msgmtime,msgfile,from,smtprelay,size,nrcpts,msgid)
time_t msgmtime;
char *msgfile, *from, *smtprelay, *msgid;
int size, nrcpts;
{
  char linebuf[8000];		/* Should be aplenty..		*/
  char spoolid[30];		/* Min. space: 6+8+1 chars	*/
  time_t now;

  taspoolid(spoolid, sizeof(spoolid), msgmtime, msgfile);

  time(&now);

  /* to='rp->addr->user'
     ctladdr=`getpwuid(rp->addr->misc)`
     mailer='rp->addr->channel' */

  sprintf(linebuf, "%s: from=<%.200s>, rrelay=%.200s size=%d, nrcpts=%d, msgid=%.200s",
	  spoolid, from, smtprelay, size, nrcpts, msgid);

  zsyslog((LOG_INFO, "%s", linebuf));
}
