/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/*
 * Fake I/O that *must* be used by all internal builtin functions.
 *
 * To use, include <stdio.h> then this file.
 */

#ifndef	Z_IO_H
#define	Z_IO_H

#ifndef __
# ifdef __STDC__
#  define __(x) x
# else
#  define __(x) ()
# endif
#endif

struct	siobuf {
	struct siobuf	*_sb_data;	/* usually self pointer unless dup'ed */
	int		_sb_cnt;	/* no. of bytes left in buffer */
	u_char		*_sb_ptr;	/* current position in buffer */
	u_char		*_sb_base;	/* base of buffer */
	int		_sb_bufsiz;	/* size of buffer */
	short		_sb_flag;	/* open flags, O_CREAT == malloc'ed */
	short		_sb_refcnt;	/* reference count */
	struct siobuf	*sb_next;	/* linked list of these things */
};

#define sb_cnt		_sb_data->_sb_cnt
#define	sb_ptr		_sb_data->_sb_ptr
#define sb_base		_sb_data->_sb_base
#define sb_bufsiz	_sb_data->_sb_bufsiz
#define sb_flag		_sb_data->_sb_flag
#define sb_refcnt	_sb_data->_sb_refcnt

extern struct siobuf *siofds[];		/* array of linked lists of siobufs */

extern struct siobuf *sIOp;


#ifndef	REALSTDIO
#if 0
#ifdef	fileno
#undef	fileno
#endif

#ifdef _HPUX_SOURCE
#define fileno(p)	((unsigned)(((p)->__fileL) + ((p)->__fileH << 8)))
#else
#define	fileno(p)	((unsigned)(p)->__file)
#endif
#endif

#define	_FILEIO(p)   (((sIOp = siofds[fileno(p)]) == NULL) || sIOp->sb_flag < 0)

#ifdef	putc
#undef	putc
#endif	/* putc */
#define putc(x, p)	(_FILEIO(p) ? std_putc(x, p): \
			 ((--sIOp->sb_cnt <= 0 ? siomore(sIOp) : 0), \
			  (int)(*sIOp->sb_ptr++ = (u_char)(x))))

#ifdef	getc
#undef	getc
#endif	/* getc */
#define	getc(p)		(_FILEIO(p) ? std_getc(p) : \
			 (--sIOp->sb_cnt >= 0 ? (int)*sIOp->sb_ptr++ : EOF))

#ifdef	putchar
#undef	putchar
#endif	/* putchar */
#define putchar(x)      putc((x),stdout)

#ifdef	getchar
#undef	getchar
#endif	/* getchar */
#define getchar()       getc(stdin)

#ifdef	ungetc
#undef	ungetc
#endif	/* ungetc */
#define	ungetc(c,p)	(_FILEIO(p) ? std_ungetc(c,p) : \
			 (sIOp->sb_ptr > sIOp->sb_base ? \
				    ++sIOp->sb_cnt, (int)(*--sIOp->sb_ptr = c) : EOF))

#ifdef	feof
#undef	feof
#define	feof(p)		(_FILEIO(p) ? std_feof(p) : \
			 sIOp->sb_ptr == sIOp->sb_base + sIOp->sb_bufsiz)
#endif	/* feof */

#define	ftell(p)	(_FILEIO(p) ? std_ftell(p) : \
			 (long)(sIOp->sb_ptr - sIOp->sb_base))

#define	fgets(s,n,p)	(_FILEIO(p) ? std_fgets(s,n,p) : siofgets(s,n,p))
#define	gets(s)		(_FILEIO(stdin) ? std_gets(s) : siogets(s))
#define	fputs(s,p)	(_FILEIO(p) ? std_fputs(s,p) : siofputs(s,p))
#define	puts(s)		(_FILEIO(stdout) ? std_puts(s) : sioputs(s))
#define	fread(b,s,n,p)	(_FILEIO(p) ? std_fread(b,s,n,p) : siofread(b,s,n,p))
#define	fwrite(b,s,n,p)	(_FILEIO(p) ? std_fwrite(b,s,n,p) : siofwrite(b,s,n,p))

#define	printf		(_FILEIO(stdout) ? std_printf : sioprintf)
#define	fprintf		siofprintf
#define	fscanf		siofscanf

extern char	*std_gets(), *std_fgets();
extern char	*siogets(), *siofgets();
extern int	std_puts(), std_fputs();
extern int	sioputs(), siofputs();
extern int	siofread(), siofwrite();

extern int	std_putc(), std_getc(), std_ungetc(), std_feof();
extern int	std_fread(), std_fwrite();
extern long	std_ftell();
#ifdef HAVE_STDARG_H
extern int	(*std_printf) __((char *fmt, ...));
extern int	sioprintf  __((char *fmt, ...));
extern int	siofprintf __((FILE *fp, char *fmt, ...));
#else
extern int	(*std_printf) __((char *fmt, ...));
extern int	sioprintf  __((char *fmt, ...));
extern int	siofprintf __((FILE *fp, char *fmt, ...));
#endif
extern int	siofscanf __(());
extern int	siomore __(());
#endif	/* REALSTDIO */
#endif	/* Z_IO_H */
