/*

*/

#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>
#ifndef EAI_BADFLAGS
# include "netdb6.h"
#endif

struct valstrpairs { int val; char * str; };

static struct valstrpairs gai_nametonum[] = {
  { 0,		"success" },
  { EAI_ADDRFAMILY,	"address family for name not supported" },
  { EAI_AGAIN,		"temporary failure in name resolution" },
  { EAI_BADFLAGS,	"invalid value for ai_flags" },
  { EAI_FAIL,		"non-recoverable failure in name resolution" },
  { EAI_FAMILY, 	"ai_family not supported" },
  { EAI_MEMORY,		"memory allocation failure" },
  { EAI_NODATA, 	"no address associated with name" },
  { EAI_NONAME,		"name or service is not known" },
  { EAI_SERVICE,	"service not supported for ai_socktype" },
  { EAI_SOCKTYPE,	"ai_socktype not supported" },
  { EAI_SYSTEM,		"system error" },
  { 0, NULL }
};


static char *numtoname(pairs, num)
	struct valstrpairs *pairs;
	int num;
{
	for ( ; pairs->str; pairs++)
	  if (pairs->val == num)
	    return(pairs->str);
	return NULL;
}


char *gai_strerror(num)
int num;
{
	static char buffer[12];
	char *s = numtoname(gai_nametonum, num);

	if (s) return s;

	sprintf(buffer,"error%02x", num);
	return buffer;
}
