/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */
/*
 *	Matti E Aarnio 1994 -- write (new) multiline headers to the file
 *      This is part of the Zmailer
 *
 *	TODO: auto-wrapping/widening of (continued) headers to given
 *	      width! That is, to enable to limit header width to 80
 *	      chars is such is needed somewhere (like BITNET)..
 *	(will do it with MIME-2 code -- always in 80 chars..)
 */

#include "hostenv.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "ta.h"

int
writeheaders(rp,fp,newline,convertmode,maxwidth)
	struct rcpt *rp;
	FILE *fp;
	char *newline;
	int convertmode, maxwidth;
{
	char **msgheaders = *(rp->newmsgheader);
	int newlinelen = strlen(newline);
	int hsize = 0;

	/* If asked for, and they are available,
	   use converted headers */
	/* if (convertmode != _CONVERT_NONE) */
	if (*(rp->newmsgheadercvt) != NULL)
	  msgheaders = *(rp->newmsgheadercvt);

	if (!msgheaders) return -1;

	/* [Thomas Knott]
	 * Error-Flag des Filedescriptors fp loeschen (HP-UX)
	 */
	clearerr(fp);

	while (*msgheaders && !ferror(fp)) {
		int linelen = strlen(*msgheaders);
		if (fwrite(*msgheaders,1,linelen,fp) != linelen)
			return -1;
		hsize += linelen;
		if (fwrite(newline,1,newlinelen,fp) != newlinelen)
			return -1;
		++msgheaders;
	}
	if (fwrite(newline,1,newlinelen,fp) != newlinelen)
		return -1;
	hsize += newlinelen;
	return hsize;
}
