/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/* LINTLIBRARY */

#include "mailer.h"
#ifdef	HAVE_RESOLVER
#include <netdb.h>
#include "search.h"

extern char *dottedquad(), **hp_getaddr();
extern void hp_init();


/*
 * Search the hosts database file for a hostname alias.
 */

struct conscell *
search_hosts(sip)
	struct search_info *sip;
{
	struct hostent *hp;
	struct conscell *tmp;

	sethostent(1);
	if ((hp = gethostbyname((char *)(sip->key))) == NULL)
		return NULL;
	return newstring((u_char *)strsave(hp->h_name));
}

/*
 * Print the database.
 */

void
print_hosts(sip, outfp)
	struct search_info *sip;
	FILE *outfp;
{
#if	!defined(sgi) && !defined(HAVE_RESOLVER)
	char **cpp;
	struct hostent *hp;

	sethostent(1);
	while ((hp = gethostent()) != NULL) {
		hp_init(hp);
		fprintf(outfp, "%s\t%s", dottedquad(*hp_getaddr()), hp->h_name);
		for (cpp = hp->h_aliases; *cpp != NULL; ++cpp)
			fprintf(outfp, " %s", *cpp);
		putc('\n', outfp);
	}
#else
	fprintf(outfp,
		"# router: the gethostent() routine is not available\n");
	fprintf(outfp, "127.0.0.1\tlocalhost\n");
#endif
	fflush(outfp);
}
#endif	/* HAVE_RESOLVER */
