/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include "hostenv.h"
#include <stdio.h>
#include <ctype.h>
#include "malloc.h"
#include <pwd.h>
#include <sysexits.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/stat.h>
#include "mail.h"
#include "zmsignal.h"
#include "ta.h"


#define	PROGNAME	"errormail"
#define	CHANNEL		"error"	/* the default channel name we deliver for */

char *dfltform[] = {
		"From: The Post Office <postmaster>",
		"Subject: email delivery error",
		"Cc: The Postmaster <postmaster>",
		"MIME-Version: 1.0",
		"Content-Type: multipart/report; report-type=delivery-status;",
		"Precedence: junk", /* BSD sendmail */
		"",
		"Processing your mail message caused the following errors:",
		NULL
};

char *progname;

extern char *optarg;
extern int optind;
extern int emptyline();
extern void prversion();
extern void process();

#ifndef strchr
extern char *strrchr();
extern char *strchr();
#endif

extern char *mydomain();

#ifndef	MAXPATHLEN
#define	MAXPATHLEN 1024
#endif	/* MAXPATHLEN */

int D_alloc = 0; /* For tmalloc() from libz.a ... */


int
main(argc, argv)
	int argc;
	char *argv[];
{
	char *channel, msgfilename[MAXPATHLEN+1];
	int errflg, c;
	struct ctldesc *dp;
	RETSIGTYPE (*oldsig)();

	SIGNAL_HANDLESAVE(SIGINT, SIG_IGN, oldsig);
	if (oldsig != SIG_IGN)
	  SIGNAL_HANDLE(SIGINT, wantout);
	SIGNAL_HANDLESAVE(SIGHUP, SIG_IGN, oldsig);
	if (oldsig != SIG_IGN)
	  SIGNAL_HANDLE(SIGHUP, wantout);
	SIGNAL_HANDLESAVE(SIGTERM, SIG_IGN, oldsig);
	if (oldsig != SIG_IGN)
	  SIGNAL_HANDLE(SIGTERM, wantout);
	SIGNAL_IGNORE(SIGPIPE);

	if ((progname = strrchr(argv[0], '/')) == NULL)
	  progname = argv[0];
	else
	  ++progname;
	errflg = 0;
	channel = CHANNEL;
	while ((c = getopt(argc, argv, "c:V")) != EOF) {
	  switch (c) {
	  case 'c':		/* specify channel scanned for */
	    channel = optarg;
	    break;
	  case 'V':
	    prversion(PROGNAME);
	    exit(EX_OK);
	    break;
	  default:
	    ++errflg;
	    break;
	  }
	}
	if (errflg || optind != argc) {
	  fprintf(stderr, "Usage: %s [-V] [-c channel]\n",
		  argv[0]);
	  exit(EX_USAGE);
	}

	while (!getout) {
	  char *s;

	  printf("#hungry\n");
	  fflush(stdout);

	  if (fgets(msgfilename, sizeof msgfilename, stdin) == NULL) break;
	  if (strchr(msgfilename, '\n') == NULL) break; /* No ending '\n' !
							   Must have been
							   partial input! */
	  if (strcmp(msgfilename, "#idle\n") == 0)
	    continue; /* Ah well, we can stay idle.. */

	  /* Input:
	       spool/file/name [ \t host.info ] \n
	   */

	  if (emptyline(msgfilename, sizeof msgfilename))
	    break;

	  s = strchr(msgfilename,'\t');
	  if (s != NULL)
	    *s = 0;	/* Ignore the host-selector */

	  dp = ctlopen(msgfilename, channel, (char *)NULL, &getout, ctlsticky, NULL);
	  if (dp != NULL) {
	    process(dp);
	    ctlclose(dp);
	  } else {
	    printf("#resync %s\n",msgfilename);
	    fflush(stdout);
	  }
	}
	return 0;
}

/*
#ifndef MALLOC_TRACE
univptr_t
tmalloc(n)
	size_t n;
{
	return emalloc((u_int)n);
}
#endif
*/

/* Pick recipient address from the input line.
   EXTREMELY Simple minded parsing.. */
static void pick_env_addr(buf,mfp)
char *buf;
FILE *mfp;
{
	char *s = buf;

	while (*s != 0 && *s != ' ' && *s != '\t' && *s != ':') ++s;
	if (*s != ':') return; /* BAD INPUT! */
	buf = ++s; /* We have skipped the initial header.. */

	s = strchr(buf,'\n');
	if (s) *s = 0;
	s = strchr(buf,'<');
	if (s != NULL) {
	  /*  Cc:  The Postoffice managers <postoffice> */
	  buf = ++s;
	  s = strrchr(buf,'>');
	  if (s) *s = 0;
	  else return; /* No trailing '>' ? BAD BAD! */
	  fprintf(mfp,"to <%s>\n",buf);
	} else {
	  /*  Cc: some-address  */
	  fprintf(mfp,"to <%s>\n",buf);
	}
}

void
process(dp)
	struct ctldesc *dp;
{
	char buf[BUFSIZ];
	char **cpp, *mailshare, *mfpath;
	FILE *mfp, *efp;
	int n;
	struct rcpt *rp;
	char *boundarystr = buildboundary("errmail");
	char lastchar;
	int reportcnt = 0;
	struct stat stbuf;

	if (fstat(dp->msgfd, &stbuf) != 0)
	  abort(); /* This is a "CAN'T FAIL" case.. */

	/* recipient host field is the error message file name in FORMSDIR */
	/* recipient user field is the address causing the error */

	if (dp->senders == NULL) {
	  /*
	   * If there was no error return address
	   * it might be because this message was
	   * an error message being bounced back.
	   * We do NOT want to bounce this, but
	   * instead just drop it on the floor.
	   */
	  for (rp = dp->recipients; rp != NULL; rp = rp->next)
	    diagnostic(rp, EX_OK, 0, "error bounce dropped");
	  return;
	}

	if ((mfp = mail_open(MSG_RFC822)) == NULL) {
	  for (rp = dp->recipients; rp != NULL; rp = rp->next)
	    diagnostic(rp, EX_TEMPFAIL, 0, "mail_open failure");
	  warning("Cannot open mail file!");
	  return;
	}
	fprintf(mfp, "channel error\n");

	rp = dp->recipients;

	fprintf(mfp, "to <%s>\n",rp->addr->link->user);

	/* copy error message file itself */
	if ((mailshare = getzenv("MAILSHARE")) == NULL)
	  mailshare = MAILSHARE;

	mfpath = emalloc(3 + strlen(mailshare) + strlen(FORMSDIR) +
			 strlen(rp->addr->host));
	sprintf(mfpath, "%s/%s/%s", mailshare, FORMSDIR, rp->addr->host);

	if ((efp = fopen(mfpath, "r")) != NULL) {
	  int inhdr = 1;
	  buf[sizeof(buf)-1] = 0;
	  while (fgets(buf,sizeof(buf)-1,efp) != NULL) {
	    if (strncmp(buf,"HDR",3)==0)
	      continue;
	    else if (strncmp(buf,"ADR",3)==0)
	      pick_env_addr(buf+4,mfp);
	    else if (strncmp(buf,"SUB",3)==0)
	      continue;
	    else
	      break;
	  }
	  fseek(efp,0,0); /* Rewind! */
	  fputs("env-end\n",mfp);

	  /* copy To: from error return address */
	  fprintf(mfp, "To: <%s>\n", rp->addr->link->user);

	  while (fgets(buf,sizeof(buf)-1,efp) != NULL) {
	    if (strncmp(buf,"HDR",3)==0) {
	      fputs(buf+4,mfp);
	    } else if (strncmp(buf,"ADR",3)==0) {
	      fputs(buf+4,mfp);
	    } else if (strncmp(buf,"SUB",3)==0) {
	      fputs(buf+4,mfp);
	    } else {
	      if (inhdr) {
		inhdr = 0;
		fprintf(mfp,"MIME-Version: 1.0\n");
		fprintf(mfp,"Content-Type: multipart/report; report-type=delivery-status;\n");
		fprintf(mfp,"\tboundary=\"%s\"\n\n\n",boundarystr);
		fprintf(mfp, "--%s\n", boundarystr);
		fprintf(mfp, "Content-Type: text/plain\n");
	      }
	      fputs(buf,mfp);
	    }
	  } /* ... while() ends.. */
	  fclose(efp);
	} else {
	  for (cpp = &dfltform[0]; *cpp != NULL; ++cpp)
	    if (*cpp == 0) {
	      fprintf(mfp, "\tboundary=\"%s\"\n\n\n",boundarystr);
	      fprintf(mfp, "--%s\n", boundarystr);
	      fprintf(mfp, "Content-Type: text/plain\n");
	    } else
	      fprintf(mfp, "%s\n", *cpp);
	}
	/* print out errors in standard format */
	fputc('\n', mfp);
	for (rp = dp->recipients; rp != NULL; rp = rp->next) {
	  /* If not prohibited, print it! */
	  if ((rp->dsnflags & _DSN_NOTIFY_NEVER) == 0) {
	    fprintf(mfp, "error: %s: %s\n",
		    rp->addr->host, rp->addr->user);
	    ++reportcnt;
	  }
	}

	/* Did we report anything ? */
	if (reportcnt == 0){
	  /* No, throw it away and ack success. */
	  mail_abort(mfp);
	  diagnostic(rp, EX_OK, 0, NULL);
	  return;
	}

	fprintf(mfp, "\n--%s\n", boundarystr);
	fprintf(mfp, "Content-Type: message/delivery-status\n\n");

	/* Print out errors in IETF-NOTARY format as well! */

	if (mydomain() != NULL) {
	  fprintf(mfp, "Reporting-MTA: dns; %s\n", mydomain() );
	} else {
	  fprintf(mfp, "Reporting-MTA: x-local-hostname; -unknown-\n");
	}
	if (dp->envid != NULL)
	  fprintf(mfp, "Original-Envelope-Id: %s\n",dp->envid);
	/* rfc822date() returns a string with trailing newline! */
	fprintf(mfp, "Arrival-Date: %s", rfc822date(&stbuf.st_ctime));
	fprintf(mfp, "\n");

	for (rp = dp->recipients; rp != NULL; rp = rp->next) {
	  /* If not prohibited, print it! */
	  const char *typetag;
	  char *rcpt;
	  static char const *type_rfc   = "RFC822";
	  static char const *type_local = "X-LOCAL";

	  if ((rp->dsnflags & _DSN_NOTIFY_NEVER) != 0)
	    continue;
	  rcpt = rp->addr->user;
	  if (strchr(rcpt,'@') != NULL) {
	    typetag = type_rfc;
	    if (strncmp(rcpt,"ns:",3)==0) /* 'hold'-channel stuff */
	      typetag = type_local;
	  } else
	    typetag = type_local;
	  fprintf(mfp, "Final-Recipient: %s; %s\n", typetag, rcpt);
	  fprintf(mfp, "Action: failed\n");
	  fprintf(mfp, "Diagnostic-Code: X-LOCAL; 500 (%s)\n", rp->addr->host );
	  if (rp->orcpt != NULL)
	    fprintf(mfp, "Original-Rcpt: %s\n",rp->orcpt);
	  fprintf(mfp, "\n");
	}

	fprintf(mfp, "--%s\n", boundarystr);
	fprintf(mfp, "Content-Type: message/rfc822\n\n");

	/* Skip over the delivery envelope lines! */

	rp = dp->recipients;
	/* copy original message file */
	/* seek to message body -- try it anyway */
	lseek(dp->msgfd, dp->msgbodyoffset, 0 /* L_SET -- usually */);
	/* write the (new) headers with local "Received:"-line.. */
	writeheaders(rp,mfp,"\n",0,0);

	/* If the DSN RET=NO is in effect, don't copy the msg body! */
	if ((rp->dsnflags & _DSN_RET_NO) == 0) {

	  /* Copy out the rest with somewhat more efficient method */
	  lastchar = 0;
	  while ((n = read(dp->msgfd, buf, sizeof(buf))) > 0) {
	    fwrite(buf, sizeof buf[0], n, mfp);
	    lastchar = buf[n-1];
	  }
	  if (lastchar != '\n')
	    fputs("\n",mfp);
	}

	fprintf(mfp, "--%s--\n", boundarystr);
	if (ferror(mfp)) {
	  mail_abort(mfp);
	  n = EX_IOERR;
	} else if (mail_close(mfp) == EOF)
	  n = EX_IOERR;
	else
	  n = EX_OK;
	for (rp = dp->recipients; rp != NULL; rp = rp->next) {
	  diagnostic(rp, n, 0, (char *)NULL);
	}
}
