/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include "hostenv.h"
#include "mailer.h"

static char *weekday[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

char *monthname[] = {	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
			"Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

char *
rfc822tz(timep, ts, prettyname)
	time_t *timep;
	struct tm **ts;
	int prettyname;
{
	char *cp;
	int sign, offset;
	time_t tm;
	struct tm ts2;
	static char zone[32];

	*ts    = localtime(timep);
	ts2    = *(*ts);
	ts2.tm_isdst = 0;	/* Make always a non-dst timestamp to
				   figure out our timezone offset .. */
	tm     = mktime(&ts2);
	offset = (tm - *timep) / 60; /* Offset in minutes */
	sign   = offset >= 0;

	sprintf(zone, "%c%02d%02d",
		sign ? '+' : '-', offset / 60, offset % 60);
	cp = zone + strlen(zone);

#ifdef	HAVE_TM_ZONE
	if (prettyname)
	  sprintf(cp," (%s)",(*ts)->tm_zone);
#else	/* !HAVE_TM_ZONE */
#ifdef HAVE_TZNAME
	if (prettyname)
	  sprintf(cp, " (%s)", tzname[(*ts)->tm_isdst]);
#else
	if (prettyname)
	  strcat(cp, " (Zone Name?)");
#endif
#endif	/* USE_BSDTIMEZONE */
	return zone;
}

/* Like ctime(), except returns RFC822 format (variable length!) date string */

u_char *
rfc822date(unixtimep)
	time_t *unixtimep;
{
	static u_char buf[40];
	struct tm *ts;
	char *tzp = rfc822tz(unixtimep, &ts, 0);

	sprintf((char *)buf, "%s, %d %s %d %02d:%02d:%02d %s\n",
		weekday[ts->tm_wday], ts->tm_mday,
		monthname[ts->tm_mon], 1900 + ts->tm_year,
		ts->tm_hour, ts->tm_min, ts->tm_sec, tzp);
	return buf;
}
