/*
 *	A component for ZMailer by Matti Aarnio <mea@nic.funet.fi>
 *	Copyright 1996 Matti Aarnio
 *
 */

#include <stdio.h>
#include <sys/param.h>
#include "hostenv.h"
#include <fcntl.h>
#include <errno.h>
#include <sys/file.h>
#include <stdlib.h>
#include <unistd.h>


void
fd_nonblockingmode(fd)
	int fd;
{
	int i;
	i = fcntl(fd, F_GETFL, 0);
	if (i >= 0) {
#ifdef O_NONBLOCK /* POSIXy thing */
	  /* set up non-blocking I/O */
	  i |= O_NONBLOCK;
#else
#ifdef	FNONBLOCK
	  i |= FNONBLOCK;
#else
	  i |= FNDELAY;
#endif
#endif
	  i = fcntl(fd, F_SETFL, i);
	}
}

void
fd_blockingmode(fd)
	int fd;
{
	int i;
	i = fcntl(fd, F_GETFL, 0);
	if (i >= 0) {
#ifdef O_NONBLOCK /* POSIXy thing */
	  /* set up blocking I/O */
	  i &= ~O_NONBLOCK;
#else
#ifdef	FNONBLOCK
	  i &= ~FNONBLOCK;
#else
	  i &= ~FNDELAY;
#endif
#endif
	  i = fcntl(fd, F_SETFL, i);
	}
}

