#ifndef	__HOSTENV__
#define	__HOSTENV__

#include "libsupport.h"
#include <sys/types.h>
#ifdef __linux__ /* Linux libc-4 needs this, libc-5 doesn't.. */
# include <linux/limits.h>
#endif
#include <sys/param.h> /* Troublepotential: If somebody does not have it ? */
#ifdef HAVE_ALLOCA_H
# define USE_ALLOCA
#endif
#ifdef USE_UNISTD
# include <unistd.h>
#endif
#ifdef USE_STDLIB
# include <stdlib.h>
#endif

/* There are systems which store the stdio fp contained fileno into
   a SIGNED CHARACTER, and simple-minded  fileno() will therefore
   pick an FD of over 127 as negative number..  We provide a wrapper
   for such in case by case basis.. */

#ifndef FILENO
# if defined(sun) && !defined(__svr4__)
#  define FILENO(x) (((unsigned)fileno(x)) & 0xFF)
# else
#  define FILENO(x) fileno(x)
# endif
#endif

#ifndef	__
# ifndef __STDC__
#  define __(x) ()
#  ifdef __GNUC__
#   define const    __const
#   define volatile __volatile
#  else
#   define const
#   define volatile
#  endif
# else
#  define __(x) x
# endif
#endif

#include "sysprotos.h"

#endif	/* !__HOSTENV__ */
