#!/usr/local/bin/perl
#
#  THIS PIECE OF CODE IS COPIED AS IS FROM University of Turku INTERNAL
#  ACCOUNT MANAGEMENT SUBSYSTEM.  You undoubtly need to alter this somewhat..
#

#
#  Combines various   /etc/passwd  files from multiple hosts, and
#  also  /net/sara/disk1/admin/kayttajat  data into complete
#  all encompassing database for mailer.
#

#
# Resulting database is processed (at mailhost) thru  makendbm
# ($MAILSHARE/bin/makendbm) to create final database for mailer.
#

#
# Order of host names in following data is important.
# VAX-group is handled separately.
#
# Host LATER in list overrides whatever hosts before have defined.
#
@HOSTS = ("hcc","fomalhaut","vega","sirius","polaris");
@FILES = ();

%uid2emailu = ();
%uid2email = ();
%email2uid = ();
%realname2email = ();
$maildb = "/usr/local/mail/db";
$saradir = "/net/sara/disk1/admin";
$makendbm = "/usr/local/mail/bin/makendbm";

umask 0177;
chdir "/usr/local/etc";

if ($ARGV[0] eq "DEBUG") { goto kontu_works; }

foreach $host (@HOSTS) {

    #
    #  We collect password files at first.
    #

    local($FN)="passwd.".$host;
    unlink("$FN.new");
    printf "Combining host: $host\n";
    if ($host ne "polaris") {
	$rc = system("/usr/ucb/rcp $host:/etc/passwd $FN.new");
    } else {
	$rc = system("/usr/bin/ypcat passwd >$FN.new");
    }
    if ($rc == 0 ) {
	rename("$FN.new","$FN");
    } else {
	printf "Can't combine host: $host\n";
    }
    @FILES = (@FILES,"$FN");
} # For each..

$rc = system("/usr/local/etc/passwd-tool.exe @FILES > passwd.yp.new");
#if ($rc == 0) {
rename("passwd.yp.new","passwd.yp");
system("chmod 644 passwd.yp");
#	printf "Combining successfull\n";
system("/bin/cp passwd.yp $saradir/passwd");
#} # if bypass..
# else {
#	printf("Combining not successfull, rc=0x%x\n",$rc);
#}
{
    local($host)="Kontu - kayttajat-file";
    local($FN)="passwd.kayttajat";
    unlink("$FN.new");
#	printf "Combining host: $host\n";
    local($rc) = system("cp $saradir/kayttajat $FN.new");
    if ($rc == 0 ) {
	rename("$FN.new","$FN");
    } else {
	printf "Can't combine host: $host\n";
    }
    @FILES = (@FILES,"$FN");
}


for $host (@HOSTS) {
    #
    #  Parse each passwd file for userid and Real.Name
    #
    local($polaris)=($host eq "polaris");
    if (open($PWFILE,"< passwd.$host")) {
#printf("Opened  passwd.$host  $polaris\n");
	local($line,@pwd,@realnames,$realname);
	while($line = <$PWFILE>) {
	    next if $line =~ /^#/;
	    @pwd = split(/:/,$line);
	    # $pwd[0]  is userid
	    # $pwd[4]  is real.name
	    @realnames = & gen_realnames($pwd[4]);
	    local($uu) = "$pwd[0]\@$host.utu.fi";
#printf("Real names for user $pwd[0]: ".join('/',@realnames)."\n");
	    if ($polaris == 0) {
		$uid2emailu{$pwd[0]} = $uu;
		$uid2email{$pwd[0]} = $uu;
		$email2uid{$uu} = $pwd[0];
		for $realname (@realnames) {
		    $realname2email{$realname} = $uu;
		}
	    } else {
		$uid2emailu{$pwd[0]} = $uu;
		$email2uid{$uu} = $pwd[0];
		for $realname (@realnames) {
		    $realname2email{$realname} = "$pwd[0]\@utu.fi";
		}
	    }
	}
	close($PWFILE);
    }
}  # For $host ..

kontu_works:;
#printf "---------------- kontu.kayttajat ----------------\n";
{
    local ($fn) = "passwd.kayttajat";
    local ($INPFILE);
    open($INPFILE,"< $fn");
    local ($line);
    local(@realnames,$realname);
    while ($line = <$INPFILE>) {
	chop($line);		# 
	local($lastname,@namepart)=split(' ',substr($line,0,31));
	local($vmsuser)=substr($line,31,12);
	local($unixuser)=substr($line,44,8);
	local($vmsgroup)=substr($line,53,9);
	local($unixgroup)=substr($line,62,8);
	local($rest)=substr($line,79);
	$lastname  =~ s/,//;
	$vmsuser   =~ s/ //g;
	$vmsuser   =~ tr/A-Z/a-z/;
	$vmsgroup  =~ s/ //g;
	$unixuser  =~ s/ //g;
	$unixgroup =~ s/ //g;
	$rest      =~ s/ //g;
#	$luser="$lastname:@namepart:$vmsuser:$vmsgroup:$unixuser:$unixgroup:$rest";printf("Kontu luserline /$luser/\n");
	@realnames = & gen_realnames("@namepart $lastname");
#printf("Real names for user $pwd[0]: ".join('/',@realnames)."\n");
	if (length($unixuser)>0) {
	    #if (defined($uid2email{$unixuser})) {
	    #printf "Unix user $unixuser already on Polaris: $uid2email{$unixuser}\n";
	    #delete $uid2email{$unixuser};
	    #}
	    if (!defined($email2uid{"$unixuser\@utu.fi"})) {
		$email2uid{"$unixuser\@utu.fi"} = $unixuser; }
	}		       
	if (length($vmsuser)>0) {	# Kontu uname
	    local($vv)="$vmsuser\@sara.utu.fi";
	    if (!defined($uid2emailu{$vmsuser}) && ($vmsuser ne $unixuser)) {
		$uid2emailu{$vmsuser} = $vv;
		$uid2email{$vmsuser} = $vv; }
	    if (!defined($email2uid{$vv})) {
		$email2uid{$vv} = $vmsuser; }
	    if (!defined($realname2email{$realname})) {
		$realname2email{$realname} = $vv; }
	}
	for $realname (@realnames) {
	    if (length($unixuser)>0) {	# UNIX uname
		if (!defined($realname2email{$realname})) {
		    $realname2email{$realname} = "$unixuser\@utu.fi";
		}
	    }
	    if (length($vmsuser)>0) { # Kontu uname
		local($vv)="$vmsuser\@sara.utu.fi";
		if (!defined($uid2email{$vmsuser}) && ($vmsuser ne $unixuser)){
		    $uid2email{$vmsuser} = $vv;
		}
		if (!defined($email2uid{$vv})) {
		    $email2uid{$vv} = $vmsuser;
		}
		if (!defined($realname2email{$realname})) {
		    $realname2email{$realname} = $vv;
		}	       
	    }
	}
    }
    close($INPFILE);

    # Handle OR_* users.
    $fn = "passwd.kayttajat";
    if(!open($INPFILE,"/usr/bin/grep OR_ $fn |")) {
	die "Cannot grep $fn, stopped";
    }
    while ($line = <$INPFILE>) {
	chop($line);
	local($lastname,@namepart)=split('_',substr($line,0,31));
	# An underscore in the name?
	if($#namepart < 0) {
	    next;	# Nope!  Skip this one.
	}
	local($vmsuser)=substr($line,31,12);
	local($unixuser)=substr($line,44,8);
	local($vmsgroup)=substr($line,53,9);
	local($unixgroup)=substr($line,62,8);
	local($rest)=substr($line,79);
	$vmsuser   =~ s/ //g;
	$vmsuser   =~ tr/A-Z/a-z/;
	$vmsgroup  =~ s/ //g;
	$unixuser  =~ s/ //g;
	$unixgroup =~ s/ //g;
	$rest      =~ s/ //g;
#	$luser="$lastname:@namepart:$vmsuser:$vmsgroup:$unixuser:$unixgroup:$rest";printf("Kontu luserline /$luser/\n");
	@realnames = & gen_realnames("@namepart $lastname");
#printf("Real names for user $pwd[0]: ".join('/',@realnames)."\n");
	if (length($unixuser)>0) {
	    #if (defined($uid2email{$unixuser})) {
	    #printf "Unix user $unixuser already on Polaris: $uid2email{$unixuser}\n";
	    #delete $uid2email{$unixuser};
	    #}
	    if (!defined($email2uid{"$unixuser\@utu.fi"})) {
		$email2uid{"$unixuser\@utu.fi"} = $unixuser;
	    }
	}
	if (length($vmsuser)>0) {	# Kontu uname
	    local($vv)="$vmsuser\@sara.utu.fi";
	    if (!defined($uid2emailu{$vmsuser}) && ($vmsuser ne $unixuser)) {
		$uid2emailu{$vmsuser} = $vv;
		$uid2email{$vmsuser} = $vv;
	    }
	    if (!defined($email2uid{$vv})) {
		$email2uid{$vv} = $vmsuser;
	    }
	    if (!defined($realname2email{$realname})) {
		$realname2email{$realname} = $vv;
	    }
	}
	for $realname (@realnames) {
	    if (length($unixuser)>0) {	# UNIX uname
		if (!defined($realname2email{$realname})) {
		    $realname2email{$realname} = "$unixuser\@utu.fi";
		}
	    }
	    if (length($vmsuser)>0) {	# Kontu uname
		local($vv)="$vmsuser\@sara.utu.fi";
		if (!defined($uid2email{$vmsuser}) && ($vmsuser ne $unixuser)){
		    $uid2email{$vmsuser} = $vv;
		}
		if (!defined($email2uid{$vv})) {
		    $email2uid{$vv} = $vmsuser;
		}
		if (!defined($realname2email{$realname})) {
		    $realname2email{$realname} = $vv;
		}
	    }
	}
    }
    close($INPFILE);

}


{
#	local(REALNAMES,UID2EMAIL,EMAIL2UID);
    unlink("passwd.realnames");
    open(REALNAMES,"> passwd.realnames");
    unlink("passwd.uid2email");
    open(UID2EMAIL,"> passwd.uid2email");
    unlink("passwd.email2uid");
    open(EMAIL2UID,"> passwd.email2uid");
    local($key,$value);
    while(($key,$value) = each %realname2email) {
	if($key eq '' || $key =~ /^-/ || !($key =~ /\./)) {
	    ;
	} else {
	    printf REALNAMES "$key\t\t$value\n";
	}
    }
    while(($key,$value) = each %email2uid) {
	printf EMAIL2UID "$key\t\t$value\n";
    }
    while(($key,$value) = each %uid2email) {
	printf UID2EMAIL "$key\t\t$value\n";
    }

    close(REALNAMES);
    close(EMAIL2UID);
    close(UID2EMAIL);
    if( -f "$maildb/fullnames.exceptions") {
	system("/usr/bin/cat >>passwd.realnames $maildb/fullnames.exceptions");
    }
    system("sort passwd.realnames >$maildb/fullnames.castor");
    system("sort passwd.uid2email >$maildb/fullname-uids.castor");
    system($makendbm." $maildb/fullnames $maildb/fullnames.castor");
    system("/bin/cp  $maildb/fullnames.castor $saradir/fullnamealiases");
}
exit(0);

#
# Generic parser routines
#
sub parse_kayttajat {
  # Return an @array of elts much in password style:
  # First_names:Last_name:kontu_uname:kontu_group:unix_uname:unix_group:rest

	local ($fn) = $_[0];
	local ($INPFILE);
	local ($retval);
	open($INPFILE,"< $fn");
	local ($line);
	while ($line = <$INPFILE>) {
		chop($line);
		local($lastname,@namepart)=split(' ',substr($line,0,31));
		local($vmsuser)=substr($line,31,12);
		local($unixuser)=substr($line,44,8);
		local($vmsgroup)=substr($line,53,9);
		local($unixgroup)=substr($line,62,8);
		local($rest)=substr($line,79);
		$lastname  =~ s/,//;
		$vmsuser   =~ s/ //g;
		$vmsgroup  =~ s/ //g;
		$unixuser  =~ s/ //g;
		$unixgroup =~ s/ //g;
		$rest      =~ s/ //g;
		local($kayttajat)="$lastname:@namepart:$vmsuser:$vmsgroup:$unixuser:$unixgroup:$rest";
		@kayttajat=(@kayttajat,$retval);
	}
	close($INPFILE);
}

sub gen_realnames {
#	@realnames = & gen_realnames("$pwd[1] $pwd[0]");
	local(@realnames) = ();
	local($realname) = $_[0];
	local($scandname);
	local(@rn,@srn) = split(/[,\/><]/,$realname);
	$realname = $rn[0];		# Chop off extra comments
	$realname =~ tr/A-]/a-}/;	# All lowercase, including scandic names!
	$realname =~ s/\.//g;		# Chop off '.'sss
	$scandname = $realname;
	$realname =~ tr/{}|/aao/;	# Turn scandic name to its "stripped" version
	
	@rn = split(' ',$realname);	# Yield components of name
	@srn = split(' ',$scandname);	# Yield components of name
	if ($realname ne $scandname) {
	    # Scandic version is different, yield permutations
	    if ($#srn >= 2) {
		@realnames =(@realnames,join('.',@srn));
		@realnames =(@realnames,join('.',$srn[0],$srn[$#srn]));
		@realnames =(@realnames,join('.',$srn[0],$srn[1],$srn[$#srn]));
		@realnames =(@realnames,join('.',$srn[0],substr($srn[1],0,1),$srn[$#srn]));
	    } else {
	    	@realnames =(@realnames,join('.',@srn));
	    }
	}
	if ($#rn >= 2) {
	    @realnames =(@realnames,join('.',@rn));
	    @realnames =(@realnames,join('.',$rn[0],$rn[$#rn]));
	    @realnames =(@realnames,join('.',$rn[0],$rn[1],$rn[$#rn]));
	    @realnames =(@realnames,join('.',$rn[0],substr($rn[1],0,1),$rn[$#rn]));
	} else {
	    @realnames =(@realnames,join('.',@rn));
	}
	return @realnames;
}
