/*	Prototypes of ZMailer Scheduler component routines	*/
/*
 *	Copyright Matti Aarnio <mea@nic.funet.fi> 1995
 */

#ifndef __
# ifdef __STDC__
#  define __(x) x
# else
#  define __(x) ()
# endif
#endif

/* agenda.c */
extern time_t qipcretry;
extern void web_disentangle __((struct vertex *vp));
extern void reschedule __((struct vertex *vp, int factor, int index));
extern int doagenda __((void));
extern void fifoschedule __((struct web *wp));

/* conf.c */
extern char *qlogdir;
extern char *qcf_suffix;
extern char *qdefaultdir;
extern char *qoutputfile;
extern char *replhost;
extern char *replchannel;
extern int  nobody;
extern int  sweepinterval;

/* msgerror.c */
extern void msgerror __((struct vertex *vp, long offset, char *message));
extern void reporterrs __((struct ctlfile *cfpi));
extern char *mail_alloc __((u_int n));
extern int  mail_free __((char *s));

/* qprint.c */
extern void qprint __((int fd));

/* readconfig.c */
extern struct config_entry *rrcf_head;
extern struct config_entry *default_entry;
extern void   defaultconfigentry __((struct config_entry *ce, struct config_entry *defaults));
extern void   vtxprint __((struct vertex *vp));
extern struct config_entry *readconfig __((char *file));
extern struct config_entry *rereadconfig __((struct config_entry *head, char *file));

/* resources.c */
extern int  resources_query_nofiles  __((void));
extern void resources_maximize_nofiles __((void));
extern void resources_limit_nofiles __((int nfiles));
extern int  resources_query_pipesize __((int fildes));

/* scheduler.c */
extern int  transportmaxnofiles;
extern char *progname;
extern char *postoffice;
extern char *rendezvous;
extern char *pidfile;
extern char *mailshare;
extern char *log;
extern int  hungry_childs;
extern int  global_maxkids;
extern int  verbose;
extern int  querysocket;
extern struct ctlfile *slurp __((int fd, long ino));
extern int  vtxredo __((struct spblk *spl));
extern char *timestring __((void));
extern time_t now;
extern FILE *statuslog;

/* threads.c */
extern struct thread *thread_head, *thread_tail;
extern struct threadgroup *create_threadgroup __((struct config_entry *cep, struct web *wc, struct web *wh, int withhost));
extern void  delete_threadgroup __((struct threadgroup *thgp));
extern struct thread *create_thread __((struct threadgroup *thgrp, struct vertex *vtx));
extern void  delete_thread __((struct thread *thr));
extern void  thread_linkin __((struct vertex *cp, struct config_entry *cep, int cfgid));
extern struct web *web_findcreate __((int flag, u_char *s));
extern void        unweb __((int flag, struct web *wp));
extern int   thread_start __((struct thread *thr));
extern int   idle_cleanup __((void));
extern void  pick_next_vertex __((struct procinfo *proc));
extern void  thread_report __((FILE *));

/* transport.c */
extern struct procinfo *cpids;
extern int  numkids;
extern void feed_child      __((struct procinfo *cpidp));
extern int  start_child     __((struct vertex *vhead, struct web *channel, struct web *host));
extern SIGNAL_TYPE sig_chld __((int sig));
extern int mux __((time_t timeout));
extern void queryipcinit __((void));
#if defined(USE_BINMKDIR) || defined(USE_BINRMDIR)
extern int system __((char*));
#endif
extern SIGNAL_TYPE sig_chld __((int));

/* update.c */
extern void update __((int, char *));
extern void unctlfile __((struct ctlfile *cfp));
extern void deletemsg __((char *, struct ctlfile *));
extern char *saytime __((u_long, char *, int));
extern void expire __((struct vertex *, int));


/* Transport library */
extern int lockaddr __((int, long, char, char));
