/*
 *	ZMailer 2.99.16+ Scheduler "threads" routines
 *
 *	Copyright Matti Aarnio <mea@nic.funet.fi> 1995
 *
 *
 *	These "threads" are for book-keeping of information
 *	regarding schedulable recipient vertices
 */

#include "scheduler.h"

/*
   Each vertex arrives into SOME thread, which each belong of
   SOME thread-group, among which groups the transport channel
   programs started for any member thread can be shared among
   their members.
*/


struct threadgroup *thrg_root   = NULL;
struct thread      *thread_head = NULL;
struct thread      *thread_tail = NULL;


struct threadgroup *
create_threadgroup(cep)
struct config_entry *cep;
{
	struct threadgroup *thgp;

	/* Create a thread-group and link it into group-ring */

	thgp = (struct threadgroup*)malloc(sizeof(*thgp));
	if (!thgp) return NULL;
	memset(thgp,0,sizeof(*thgp));

	thgp->cep = cep;
	if (thrg_root == NULL) {
	  thrg_root = thgp;
	  thgp->next = thgp;
	  thgp->prev = thgp;
	} else {
	  thgp->next       = thrg_root->next;
	  thgp->prev       = thrg_root->next->prev;
	  thgp->prev->next = thgp;
	  thgp->next->prev = thgp;
	}

	return thgp;
}

void
delete_threadgroup(thgp)
struct threadgroup *thgp;
{
	struct threadgroup *tgp;

	/* Time to say good-bye to this group, delete it.
	   We shall not have any threads under us, nor
	   idle processes!					*/

	if (thgp->idleproc != NULL ||
	    thgp->threads > 0) abort();
	if (thrg_root == NULL) abort();

	/* Unlink this thread-group from the ring */
	tgp = thgp->next;
	thgp->prev->next = thgp->next;
	tgp->prev = thgp->prev;
	/* are we at the ring root pointer ? */
	if (thrg_root == thgp)
	  thrg_root = tgp;
	if (tgp == thgp) {
	  /* We are the only one! */
	  thrg_root = NULL;
	}
	free(thgp);
}

struct thread *
create_thread(thgrp)
{
	/* Create a thread-block, link in the group pointer,
	   and link the thread into thread-ring			*/

	struct thread *thr;
	thr = (struct thread *)malloc(sizeof(*thr));
	if (!thr) return NULL;

	memset(thr,0,sizeof(*thr));
	thr->thgrp = thgrp;
	thr->nextthg = thr;
	thr->prevthg = thr;

	if (thgrp->thread == NULL) {
	  thgrp->thread = thr;
	} else {
	  thr->nextthg = thgrp->thread->nextthg;
	  thr->prevthg = thgrp->thread->nextthg->prevthg;
	  thgrp->thread->nextthg->prevthg = thr;
	  thgrp->thread->nextthg = thr;
	}
	thgrp->threads += 1;
	return thr;
}



void
delete_thread(thr)
{
	/* Unlink this thread from thread-chain, and thread
	   group.  Decrement thread-group count		    */

	if (thr->jobs > 0) abort(); /* Delete only when no vertices */


	/* Unlink us from the thread-chain */

	if (thr->next)
	  thr->next->prev = thr->prev;
	if (thr->prev)
	  thr->prev->next = thr->next;

	if (thread_head == thr)
	  thread_head = thr->next;
	if (thread_tail == thr)
	  thread_tail = thr->prev;

	/* ... and now from thread-group-ring */
	thr->nextthg->prevthg = thr->prevthg;
	thr->prevthg->nextthg = thr->nextthg;

	if (thr->thgrp->thread == thr)
	  thr->thgrp->thread = thr->nextthg;

	/* Link possible process pointer into the idle chain */
	if (thr->proc) {
	  thr->proc->next      = thr->thgrp->idleproc;
	  thr->thgrp->idleproc = thr->proc;
	}

	thr->thgrp->threads -= 1;

	/* If threads count goes zero.. */
	if (thr->thgrp->threads == 0) {
	  thr->thgrp->thread = NULL;
	}

	free(thr);
}

void thread_linkin(vp,tp,cfgid)
struct vertex *vp;
struct config_entry *tp;
int cfgid;
{
	struct threadgroup *thg;
	struct thread *thr;
	int match = 0;

	if (thrg_root == NULL) {
	  thg = create_threadgroup(tp);
	}
	/*
	 *  Search for matching config-entry, AND matching channel,
	 *  AND matching host (depending how the thread-group formation
	 *  is allowed to happen..)
	 *
	 */
	for (thg = thrg_root; thg != NULL; thg = thg->next) {
	  if (thg->cep != tp)
	    continue;
	  /* Ok, thread config entries match, we may be it */
	  if (thg->thread &&
	      thg->thread->thread ) {
	  }
	}
}
