/*	Copyright (c) 1984, 1986, 1987, 1988, 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *		PROPRIETARY NOTICE (Combined)
 *
 * This source code is unpublished proprietary information
 * constituting, or derived under license from AT&T's UNIX(r) System V.
 * In addition, portions of such source code were derived from Berkeley
 * 4.3 BSD under license from the Regents of the University of
 * California.
 *
 *
 *
 *		Copyright Notice
 *
 * Notice of copyright on this source code product does not indicate
 * publication.
 *
 *	(c) 1986,1987,1988,1989  Sun Microsystems, Inc
 *	(c) 1983,1984,1985,1986,1987,1988,1989  AT&T.
 *		All rights reserved.
 *
 */

/*
 * Global defines and variables for resolver stub.
 */

#ifndef	_RESOLV_H
#define	_RESOLV_H

#pragma ident	"@(#)resolv.h	1.10	93/02/04 SMI"	/* SVr4.0 1.1	*/

#include <stdio.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Resolver configuration file.
 * Normally not present, but may contain the address of the
 * inital name server(s) to query and the domain search list.
 */

#ifndef	_PATH_RESCONF
#define	_PATH_RESCONF	"/etc/resolv.conf"
#endif

#define	ADDRSORT	1		/* enable the address-sorting option */
#define	MAXADDR		10		/* max # addresses to sort by */

#define	MAXNS		3		/* max # name servers we'll track */
#define	MAXDFLSRCH	3		/* # default domain levels to try */
#define	MAXDNSRCH	6		/* max # default domain levels to try */
#define	LOCALDOMAINPARTS 2		/* min levels in name that is "local" */

#define	RES_TIMEOUT	6		/* seconds between retries */

struct state {
	int	retrans;		/* retransmition time interval */
	int	retry;			/* number of times to retransmit */
	long	options;		/* option flags - see below. */
	int	nscount;		/* number of name servers */
	struct	sockaddr_in nsaddr_list[MAXNS];	/* address of name server */
#define	nsaddr	nsaddr_list[0]		/* for backward compatibility */
	u_short	id;			/* current packet id */
	char	defdname[MAXDNAME];	/* default domain */
	char	*dnsrch[MAXDNSRCH+1];	/* components of domain to search */
	int	ascount;		/* number of addresses */
	struct  in_addr sort_list[MAXADDR]; /* address sorting list */
};

/*
 * Resolver options
 */
#define	RES_INIT	0x0001		/* address initialized */
#define	RES_DEBUG	0x0002		/* print debug messages */
#define	RES_AAONLY	0x0004		/* authoritative answers only */
#define	RES_USEVC	0x0008		/* use virtual circuit */
#define	RES_PRIMARY	0x0010		/* query primary server only */
#define	RES_IGNTC	0x0020		/* ignore trucation errors */
#define	RES_RECURSE	0x0040		/* recursion desired */
#define	RES_DEFNAMES	0x0080		/* use default domain name */
#define	RES_STAYOPEN	0x0100		/* Keep TCP socket open */
#define	RES_DNSRCH	0x0200		/* search up local domain tree */

#define	RES_DEFAULT	(RES_RECURSE | RES_DEFNAMES | RES_DNSRCH)

extern struct state _res;

#ifdef __STDC__
extern char *p_cdname(char *, char *, FILE *);
extern char *p_rr(char *, char *, FILE *);
extern char *p_type(int);
extern char *p_class(int);
extern char *p_time(unsigned long);
#else
extern char *p_cdname(), *p_rr(), *p_type(), *p_class(), *p_time();
#endif	/* __STDC__ */

#ifdef	__cplusplus
}
#endif

#endif	/* _RESOLV_H */
