/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include <stdio.h>
#include "hostenv.h"
#include <sys/param.h>
#if	defined(BSD) || defined(sun)
#include <syslog.h>
#endif

/*VARARGS*/
void
warning(fmt, arg)
	char *fmt, *arg;
{
	static int isopen = 0;
	extern char *progname;

	if (progname != NULL)
		(void) fprintf(stderr, "%s: ", progname);
	fprintf(stderr, fmt, arg);
	fprintf(stderr, "\n");
#if	defined(BSD) || defined(sun)
	if (!isopen) {
#ifdef	LOG_MAIL
		openlog(progname, 0, LOG_MAIL);
#else	/* !LOG_MAIL */
		openlog(progname, 0);
#endif	/* LOG_MAIL */
		isopen = 1;
	}
	syslog(LOG_ERR, fmt, arg);
#else	/* SVID */
	isopen = isopen;	/* appease lint */
#endif	/* BSD */
}
 
