/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/* Information needed by the database search routines */

#include "splay.h"

extern struct sptree *spt_files, *spt_modcheck;

#define	DESC_FILEP	0	/* FILE * */
#define	DESC_NDBMP	1	/* DB * */

struct search_info {
	char		*file;
	unsigned char	*key;
	time_t		ttl;
	char		*subtype;
};

#ifndef	MALLOC_TRACE
extern unsigned int symbol();
#endif	/* !MALLOC_TRACE */



#ifndef	__
#ifdef __STDC__
#define __(x) x
#else
#define __(x) ()
#define const
#define volatile
#endif
#endif


/* lookups */
extern struct conscell	*search_bin	__((struct search_info	*sip));
extern struct conscell	*search_core	__((struct search_info	*sip));
extern struct conscell	*search_dbm	__((struct search_info	*sip));
extern struct conscell	*search_gdbm	__((struct search_info	*sip));
extern struct conscell	*search_header	__((struct search_info	*sip));
extern struct conscell	*search_hosts	__((struct search_info	*sip));
extern struct conscell	*search_ndbm	__((struct search_info	*sip));
extern struct conscell	*search_res	__((struct search_info	*sip));
extern struct conscell	*search_seq	__((struct search_info	*sip));
extern struct conscell	*search_yp	__((struct search_info	*sip));
/* closes	*/
extern void	close_core	__((struct search_info	*sip));
extern void	close_seq	__((struct search_info	*sip));
extern void	close_ndbm	__((struct search_info	*sip));
extern void	close_dbm	__((struct search_info	*sip));
extern void	close_gdbm	__((struct search_info	*sip));
extern void	close_header	__((struct search_info	*sip));
/* adds	*/
extern int	add_core	__((struct search_info *sip, char *value));
extern int	add_seq		__((struct search_info *sip, char *value));
extern int	add_ndbm	__((struct search_info *sip, char *value));
extern int	add_dbm		__((struct search_info *sip, char *value));
extern int	add_gdbm	__((struct search_info *sip, char *value));
extern int	add_header	__((struct search_info *sip, char *value));
/* removes	*/
extern int	remove_core	__((struct search_info	*sip));
extern int	remove_ndbm	__((struct search_info	*sip));
extern int	remove_dbm	__((struct search_info	*sip));
extern int	remove_gdbm	__((struct search_info	*sip));
extern int	remove_header	__((struct search_info	*sip));
/* prints	*/
extern void	print_core	__((struct search_info *sip, FILE *outfp));
extern void	print_hosts	__((struct search_info *sip, FILE *outfp));
extern void	print_seq	__((struct search_info *sip, FILE *outfp));
extern void	print_ndbm	__((struct search_info *sip, FILE *outfp));
extern void	print_dbm	__((struct search_info *sip, FILE *outfp));
extern void	print_gdbm	__((struct search_info *sip, FILE *outfp));
extern void	print_header	__((struct search_info *sip, FILE *outfp));
/* owners	*/
extern void	owner_core	__((struct search_info *sip, FILE *outfp));
extern void	owner_seq	__((struct search_info *sip, FILE *outfp));
extern void	owner_ndbm	__((struct search_info *sip, FILE *outfp));
extern void	owner_dbm	__((struct search_info *sip, FILE *outfp));
extern void	owner_gdbm	__((struct search_info *sip, FILE *outfp));
extern void	owner_header	__((struct search_info *sip, FILE *outfp));
/* modchecks	*/
extern int	modp_seq	__((struct search_info	*sip));
extern int	modp_ndbm	__((struct search_info	*sip));
extern int	modp_gdbm	__((struct search_info	*sip));
