


RPEM(1)             UNIX Programmer's Manual              RPEM(1)



NAME
     rpem - Rabin Privacy Enhanced Mail. Enciphers and deciphers
     messages using a public key encryption system.

SYNOPSIS
     rpem { -e -r recipient [ -p pubkeyfile ]
          [ -a {des|newdes|none} ] [ -b ] [ -n ]
          [ -m {ascii|binary} ] [ -v init vec hex ]
          [ -k msg key ASCII ]
         | -d [ -g ] }
          [ -s mykeyfile ] [ -u username ] [ -i in ] [ -D ] <in
     >out

OPTIONS
     -e   (encipher) means encipher.

     -d   (decipher) means decipher.

     -r   (recipient) specifies the user to whom the message is
          being sent.  (Applies only when enciphering.)  The
          username is used to lookup the public key component in
          the keyfile.  Multiple recipients can be specified,
          each with a separate -r option.

     -a   (algorithm) specifies the encryption algorithm used for
          the body of the message.  The default is DES (not
          available in exportable versions).  "newdes" specifies
          Robert Scott's algorithm.  (See Cryptologia, January
          1985.) Additional algorithms may be made available in
          the future.

     -b   (block mode) specifies that Electronic Code Book mode
          is used; that is, each block of the message is
          encrypted independently.  The default is Cipher Block
          Chaining, with a pseudo-randomly generated initializa-
          tion vector (initial block).

     -n   (no prompt) specifies that the program should not
          prompt for pseudo-random input from the keyboard.
          Instead, only various information obtainable from the
          running system, such as the date and time, are used to
          generate the message key and, if applicable, the ini-
          tialization vector.  The default is to both prompt the
          user and use runtime information.

     -m   (mode) specifies the mode of the input file--ASCII or
          binary.  Further options may be made available in the
          future.  The default is "ascii".  Note:  this option
          has no effect on Unix systems.

     -v   (vector) specifies the initialization vector (initial
          block) in hex when -b is not specified.  The value must
          be exactly one block long; e.g., 8 bytes (16 hex
          digits) for DES.  The default is for the program to
          generate an initialization vector pseudo-randomly.
          This option is used primarily to verify the correct
          operation of the program.

     -k   (key) specifies the message key, in ASCII.  The default
          is for rpem to generate the message key pseudo-
          randomly, from values obtained from the running system
          and possibly from a random string entered by the user.
          If DES is being used, the string must be no more than 8
          characters long, and the following manipulations are
          performed:  The high bit of each character is set to
          make the character odd parity.  The bottom bit of each
          character is then ignored.  (This is a standard treat-
          ment for DES ASCII keys.) The key is padded to 8 bytes
          with odd-parity zeros.  This option is used primarily
          to verify the correct implementation of the DES algo-
          rithm used in this program.

     -g   (garbled) means that the keys in keyfile are encrypted.
          If specified, the program looks for the environment
          variable RABIN PQ KEY.  If the variable is found, its
          value is used as the key to decipher the two primes.
          If -g is specified and RABIN PQ KEY is not found, the
          program will prompt for the decryption key.  -g is used
          only when deciphering.

     -s   (secret key) specifies the file containing the secret
          (or private) component of the Rabin key, in the format
          generated by "makepq".  This file is required for deci-
          pherment, and is also used for encipherment (to remind
          the recipient of your public key).  If -s is not speci-
          fied, the program looks for an environment variable
          named RABIN PQ FILE; if found, its value is used as the
          file name; otherwise, the name defaults to "~/.rabin-
          key" for Unix or "RABINKEY" for MS-DOS.

     -p   (public key) specifies the file containing the public
          components of Rabin keys, indexed by user name.  If -p
          is not specified, the program looks for an environment
          variable named RABIN MODULUS FILE; if found, its value
          is used as the file name; otherwise, the name defaults
          to "/usr/local/etc/rpubkeys" for Unix, or RPUBKEYS for
          MS-DOS.

     -u   (username) specifies your username.  For encipherment,
          the username is simply placed in the message header to
          inform the recipient of the sender's username.  For
          decipherment, the message header is searched for the
          username so that rpem will know which version of the
          message key to decrypt.

          Under Unix, this parameter defaults to
          <loginname>@<hostname>.  Under MS-DOS, the value of the
          environment variable USER NAME is used if found, else
          "me" is used.


     -i   (input) specifies input file.  Default is standard
          input.

     -D   (debug) enables debug output.

DESCRIPTION
     rpem implements a filter to encrypt and decrypt messages as
     part of a privacy-enhanced mail system.  Messages are
     encrypted using a traditional private key (symmetric) cipher
     with a message key generated pseudo-randomly, enciphered
     using the Rabin public key (asymmetric) system, and included
     with the ciphertext of the message.  Output from encryption
     and input to decryption are in RFC 1113 printable coded for-
     mat.

     In the Rabin system,  ciphertext = plaintext^2 mod p*q  (p,
     q are primes); the private component consists of p & q, and
     the public consists of p*q.

FILES
     makerkey creates public keys.

HISTORY
     Written by Mark Riordan, riordanmr@clvax1.cl.msu.edu, in
     April 1991.

     Other contributors:

     Arjen Lenstra   lenstra@flash.bellcore.com
     Wrote the multiple-precision integer package used here.

     Bennet Yee      bsy+@cs.cmu.edu
     Wrote the essential number theoretic routines used in
     decrypting the public key encrypted message key.

     Marc Ringuette  mnr+@cs.cmu.edu
     Wrote miscellaneous large integer routines, provided ideas.

     Phil Karn       karn@thumper.bellcore.edu
     Wrote (most of) the DES implementation used here.

     Michael Rabin   rabin@endor.harvard.edu
     Designed the public key algorithm used here.





































