/* msgchk.c - check for mail */
#ifndef	lint
static char ident[] = "@(#)$Id: msgchk.c,v 1.3 90/04/05 15:01:32 sources Exp $";
#endif	lint

#include "../h/mh.h"
#include <stdio.h>
#include "../zotnet/mts.h"
#include "../zotnet/tws.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>

/*  */

#ifndef	POP
#define	POPminc(a)	(a)
#else	POP
#define	POPminc(a)	0
#endif	POP

#ifndef	RPOP
#define	RPOPminc(a)	(a)
#else	RPOP
#define	RPOPminc(a)	0
#endif	RPOP

static struct swit  switches[] = {
#define	DATESW	0
    "date", 0,
#define	NDATESW	1
    "nodate", 0,

#define	NOTESW	2
    "notify type", 0,
#define	NNOTESW	3
    "nonotify type", 0,

#define	HOSTSW	4
    "host host", POPminc (-4),
#define	USERSW	5
    "user user", POPminc (-4),

#define	RPOPSW	6
    "rpop", RPOPminc (-4),
#define	NRPOPSW	7
    "norpop", RPOPminc (-6),

#define	HELPSW	8
    "help", 4,

    NULL, NULL
};

/*  */

#define	NT_NONE	0x0
#define	NT_MAIL	0x1
#define	NT_NMAI	0x2
#define	NT_ALL	(NT_MAIL | NT_NMAI)


#define	NONEOK	0x0
#define	UUCPOLD	0x1
#define	UUCPNEW	0x2
#define	UUCPOK	(UUCPOLD | UUCPNEW)
#define	MMDFOLD	0x4
#define	MMDFNEW	0x8
#define	MMDFOK	(MMDFOLD | MMDFNEW)


#ifdef	SYS5
struct passwd	*getpwuid(), *getpwnam();
#endif	SYS5

static int	donote(), checkmail(), remotemail();
/*  */

/* ARGSUSED */

main (argc, argv)
int     argc;
char   *argv[];
{
    int     datesw = 1,
	    notifysw = NT_ALL,
	    rpop = 1,
	    status = 0,
	    snoop = 0,
	    vecp = 0;
    char   *cp,
           *host = NULL,
            buf[80],
	  **ap,
          **argp,
	   *arguments[MAXARGS],
           *vec[50];
    struct passwd  *pw;

    invo_name = r1bindex (argv[0], '/');
    mts_init (invo_name);
#ifdef	POP
    if (pophost && *pophost)
	host = pophost;
    if ((cp = getenv ("MHPOPDEBUG")) && *cp)
	snoop++;
#endif	POP
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    (void) copyip (argv + 1, ap);
    argp = arguments;

/*  */

    while (cp = *argp++) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULLCP, "-%s unknown", cp);
		case HELPSW: 
		    (void) sprintf (buf, "%s [switches] [users ...]",
			    invo_name);
		    help (buf, switches);
		    done (1);

		case DATESW:
		    datesw++;
		    continue;
		case NDATESW:
		    datesw = 0;
		    continue;

		case NOTESW:
		    if (!(cp = *argp++) || *cp == '-')
			adios (NULLCP, "missing argument to %s", argp[-2]);
		    notifysw |= donote (cp, 1);
		    continue;
		case NNOTESW:
		    if (!(cp = *argp++) || *cp == '-')
			adios (NULLCP, "missing argument to %s", argp[-2]);
		    notifysw &= ~donote (cp, 0);
		    continue;

		case HOSTSW: 
		    if (!(host = *argp++) || *host == '-')
			adios (NULLCP, "missing argument to %s", argp[-2]);
		    continue;
		case USERSW: 
		    if (!(cp = *argp++) || *cp == '-')
			adios (NULLCP, "missing argument to %s", argp[-2]);
		    vec[vecp++] = cp;
		    continue;
		case RPOPSW: 
		    rpop++;
		    continue;
		case NRPOPSW: 
		    rpop = 0;
		    continue;
	    }
	vec[vecp++] = cp;
    }

/*  */

#ifdef	POP
    if (!host || !*host)
	host = NULL;
    if (!host || !rpop)
	(void) setuid (getuid ());
#endif	POP
    if (vecp == 0) {
#ifdef	POP
	if (host)
	    status = remotemail (host, NULLCP, rpop, notifysw, 1, snoop);
	else
#endif	POP
	    if ((pw = getpwuid (getuid ())) == NULL)
		adios (NULLCP, "you lose");
	    else
		status = checkmail (pw, datesw, notifysw, 1);
    }
    else {
	vec[vecp] = NULL;

	for (vecp = 0; cp = vec[vecp]; vecp++)
#ifdef	POP
	    if (host)
		status += remotemail (host, cp, rpop, notifysw, 0, snoop);
	    else
#endif	POP
		if (pw = getpwnam (cp))
		    status += checkmail (pw, datesw, notifysw, 0);
		else
		    advise (NULLCP, "no such user as %s", cp);
    }

    done (status);
}

/*  */

static struct swit ntswitches[] = {
#define	NALLSW	0
    "all", 0,
#define	NMAISW	1
    "mail", 0,
#define	NNMAISW	2
    "nomail", 0,

    NULL, NULL
};


static int donote (cp, ntflag)
register char   *cp;
int	ntflag;
{
    switch (smatch (cp, ntswitches)) {
	case AMBIGSW: 
	    ambigsw (cp, ntswitches);
	    done (1);
	case UNKWNSW: 
	    adios (NULLCP, "-%snotify %s unknown", ntflag ? "" : "no", cp);

	case NALLSW: 
	    return NT_ALL;
	case NMAISW: 
	    return NT_MAIL;
	case NNMAISW: 
	    return NT_NMAI;
    }
}

/*  */

#ifdef	MF
/* ARGSUSED */
#endif	MF

static int  checkmail (pw, datesw, notifysw, personal)
register struct passwd  *pw;
int	datesw,
	notifysw,
	personal;
{
    int     mf,
            status;
    char    buffer[BUFSIZ];
    struct stat st;

    (void) sprintf (buffer, "%s/%s",
	    mmdfldir[0] ? mmdfldir : pw -> pw_dir,
	    mmdflfil[0] ? mmdflfil : pw -> pw_name);
#ifndef	MF
    if (datesw) {
	st.st_size = 0;
	st.st_atime = st.st_mtime = 0;
    }
#endif	MF
    mf = (stat (buffer, &st) == NOTOK || st.st_size == 0) ? NONEOK
	: st.st_atime <= st.st_mtime ? MMDFNEW : MMDFOLD;

#ifdef	MF
    if (umincproc != NULL && *umincproc != NULL) {
	(void) sprintf (buffer, "%s/%s",
		uucpldir[0] ? uucpldir : pw -> pw_dir,
		uucplfil[0] ? uucplfil : pw -> pw_name);
	mf |= (stat (buffer, &st) == NOTOK || st.st_size == 0) ? NONEOK
	    : st.st_atime <= st.st_mtime ? UUCPNEW : UUCPOLD;
    }
#endif	MF

    if ((mf & UUCPOK) || (mf & MMDFOK)) {
	if (notifysw & NT_MAIL) {
	    printf (personal ? "You have " : "%s has ", pw -> pw_name);
	    if (mf & UUCPOK)
		printf ("%s old-style bell", mf & UUCPOLD ? "old" : "new");
	    if ((mf & UUCPOK) && (mf & MMDFOK))
		printf (" and ");
	    if (mf & MMDFOK)
		printf ("%s%s", mf & MMDFOLD ? "old" : "new",
			mf & UUCPOK ? " Internet" : "");
	    printf (" mail waiting");
	}
	else
	    notifysw = 0;

	status = 0;
    }
    else {
	if (notifysw & NT_NMAI)
	    printf (personal ? "You don't %s%s" : "%s doesn't %s",
		    personal ? "" : pw -> pw_name, "have any mail waiting");
	else
	    notifysw = 0;

	status = 1;
    }

#ifndef	MF
    if (notifysw)
	if (datesw && st.st_atime)
	    printf ("; last read on %s",
		    dasctime (dlocaltime ((long *) & st.st_atime), TW_NULL));
#endif	MF
    if (notifysw)
	printf ("\n");

    return status;
}

/*  */

#ifdef	POP
extern	char response[];


static int  remotemail (host, user, rpop, notifysw, personal, snoop)
register char   *host;
char   *user;
int	rpop,
	notifysw,
	personal,
	snoop;
{
    int     nmsgs,
            nbytes,
            status;
    char   *pass;

    if (rpop) {
	if (user == NULL)
	    user = getusr ();
	pass = getusr ();
    }
    else
	ruserpass (host, &user, &pass);

    if (pop_init (host, user, pass, snoop, rpop) == NOTOK
	    || pop_stat (&nmsgs, &nbytes) == NOTOK
	    || pop_quit () == NOTOK) {
	advise (NULLCP, "%s", response);
	return 1;
    }

    if (nmsgs) {
	if (notifysw & NT_MAIL) {
	    printf (personal ? "You have " : "%s has ", user);
	    printf ("%d message%s (%d bytes)",
		    nmsgs, nmsgs != 1 ? "s" : "", nbytes);
	}
	else
	    notifysw = 0;

	status = 0;
    }
    else {
	if (notifysw & NT_NMAI)
	    printf (personal ? "You don't %s%s" : "%s doesn't %s",
		    personal ? "" : user, "have any mail waiting");
	else
	    notifysw = 0;
	status = 1;
    }
    if (notifysw)
	printf (" on %s\n", host);

    return status;
}
#endif	POP
