# Print
#

proc Print_Init {} {
    Preferences_Add "Printing" \
"Use these items to control how Exmh prints mail messages.  In the print command, the variable \$file is replaced by the name of the file(s) so you can embed it into a pipeline.  See Frequently Asked Question #17 for tips about
alternate print commands that do formatting." {
	{print(cmd) printCmd {lpr $file} {Text print command}
"This command is used to print the current message.
The variable $file is replaced by the name of the file(s)
so you can embed it into a pipeline."} \
	{print(pscmd) psPrintCmd {lpr $file} {Postscript print command}
"This command is used to print postscript from the current message.
The variable $file is replaced by the name of the tmp file
that contains the postscript."} \
	{print(unixcmd) unixCmd {cat $file > /dev/null} {Arbitrary UNIX command}
"This command is used to run a UNIX command over the body of the message.
\$file is replaced with the name of the temporary file."} \
    }
}
proc Print {} {
    global exmh msg print mhProfile address
    set logvar {}
    set file {}
    Ftoc_Iterate line {
	set msgid [Ftoc_MsgNumber $line]
	lappend file $mhProfile(path)/$exmh(folder)/$msgid
    }
    set nprint [llength $file]
    if {$nprint == 0} {
	Exmh_Status "No messages selected for printing" red
	return
    }
    set plural s
    if {$nprint == 1} {
	set plural ""
    }
    Exmh_Status "Printing $nprint message$plural"

    # Because $print(cmd) embeds $file, extra levels of eval are required
    if {[catch {eval eval exec $print(cmd)} logvar]} {
	if [Exwin_Toplevel .printmsg "Print Messages"] {
	    Widget_Message .printmsg msg -aspect 1500 -relief raised 
	}
	.printmsg.msg configure -text \
"Messages generated when printing your message$plural:

$logvar
"

    }
}

proc Print_Postscript {} {
    global exmh msg mhProfile print
    if [catch {open $msg(path)} in] {
	Exmh_Status $in
	return
    }
    set file [Env_Tmp]/postscript.[pid]
    if [catch {open $file w 0600} out] {
	Exmh_Status $out
    }
    Exmh_Status "Postscript in $file"
    while {[gets $in line] >= 0} {
	if [regexp {^%!} $line match] {
	    puts $out $match
	    puts $out [read $in]
	    break
	}
    }
    close $in
    close $out
    # Because $print(cmd) embeds $file, extra levels of eval are required
    if {[catch {eval eval exec $print(pscmd)} logvar]} {
	if [Exwin_Toplevel .printmsg "Print Messages"] {
	    Widget_Message .printmsg msg -aspect 1500 -relief raised 
	}
	.printmsg.msg configure -text \
"Messages generated when printing your message:

$logvar
"

    }
}

proc Message_Apply { {body {}} } {
    global exmh msg mhProfile print exwin
    if [catch {open $msg(path)} in] {
	Exmh_Status $in
	return
    }
    if {[string compare $body body] == 0} {
	set file [Env_Tmp]/exmh.body.$msg(id).[pid]
	set what Body
	set print(cleanup) 1
	set print(redisplay) 0
	if [catch {open $file w 0600} out] {
	    Exmh_Status $out
	    close $in
	    return
	}
	while {[gets $in line] >= 0} {
	    if {[regexp -- {^ *$} $line] || [regexp -- {^-*$} $line]} {
		puts -nonewline $out [read $in]
		break
	    }
	}
	close $out
    } else {
	set file $msg(path)
	set what Message
	set print(cleanup) 0
	set print(redisplay) 1
    }
    close $in

    set f [frame $exwin(mtext).cmd -bd 2 -relief ridge]
    message $f.msg1 -text "$what in $file\n\$file gets replaced with that pathname" -aspect 1000
    pack $f.msg1 -side top -fill both -padx 10 -pady 10

    set e1 [frame $f.e1 -bd 2 -relief flat]
    label $e1.label -text "UNIX Command: "
    entry $e1.entry -width 20 -textvariable print(unixcmd)
    pack $e1.entry -side right -fill both -expand true
    pack $e1.label -side right
    pack $e1 -side top -fill both -padx 10 -pady 10

    set print(cancel) 0
    set b3 [frame $f.but3 -bd 10 -relief flat]
    button $b3.cancel -text "Cancel" -command {Message_ApplyCancel}
    button $b3.ok -text "OK" -command {Message_ApplyOk}
    Widget_BindEntryCmd $e1.entry <Return> {Message_ApplyOk}
    if {$print(cleanup)} {
	checkbutton $b3.nuke -text "Cleanup [Env_Tmp]" -variable print(cleanup)
    } else {
	checkbutton $b3.nuke -text "Redisplay msg" -variable print(redisplay)
    }
    pack $b3.cancel $b3.nuke $b3.ok -side left -padx 3
    pack $b3 -side top

    Widget_PlaceDialog $exwin(mtext) $f
    tkwait window $f

    if {$print(cancel)} {
	if {$print(cleanup)} {
	    catch {exec rm $file}
	}
	Exmh_Focus
	return
    }

    # Because $print(cmd) embeds $file, extra levels of eval are required
    set what Output
    if {[catch {eval eval exec $print(unixcmd)} logvar]} {
	set what Errors
    }
    if {[string length $logvar] > 0} {
	if [Exwin_Toplevel .unixmsg "Unix Messages"] {
	    Widget_Text .unixmsg 10 
	}
	.unixmsg.t delete 1.0 end
	.unixmsg.t insert 1.0 "$what generated by\n$print(unixcmd)\n\n"
	.unixmsg.t insert end $logvar
    }
    if {$print(redisplay)} {
	Msg_Redisplay $msg(path)
    }
    if {$print(cleanup)} {
	catch {exec rm $file}
    }
    Exmh_Focus
}
proc Message_ApplyCancel {} {
    global print exwin
    set print(cancel) 1
    destroy $exwin(mtext).cmd
}
proc Message_ApplyOk {} {
    global print exwin
    set print(cancel) 0
    destroy $exwin(mtext).cmd
}
