/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 */
/* See the file NOTICE for conditions of use and distribution. */

/* "default" System-dependent functions */

#ifndef OS_RESTARTING_SIGNAL
/*************************************************
*          Set up restarting signal              *
*************************************************/

/* This function has the same functionality as the ANSI C signal() function, 
except that it arranges that, if the signal happens during a system call, the 
system call gets restarted. Different versions of Unix have different defaults, 
and different ways of achieving this. If the functionality is not available, 
the signal should be set to be ignored. .*/

void os_restarting_signal(int sig, void (*handler)(int))
{
#ifdef	SA_RESTART
struct sigaction act;
act.sa_handler = handler;
sigemptyset(&(act.sa_mask));
act.sa_flags = SA_RESTART;
sigaction(sig, &act, NULL);
#else
signal(sig, SIG_IGN);
#endif
}
#endif	/* OS_RESTARTING_SIGNAL */


#ifdef STRERROR_FROM_ERRLIST
/*************************************************
*     Provide strerror() for non-ANSI libraries  *
*************************************************/

/* Some old-fashioned systems still around (e.g. SunOS4) don't have strerror() 
in their libraries, but can provide the same facility by this simple 
alternative function. */

char *strerror(int n)
{
if (n < 0 || n >= sys_nerr) return "unknown error number";
return sys_errlist[n];
}
#endif /* STRERROR_FROM_ERRLIST */


/* End of os.c */
