.TH EMIL 8 "19 December 1994"

.SH NAME

emil \- conversion filter for Internet messages

.SH SYNOPSIS

.B emil
.RB  "[\ " "-s"  
.IR  "Sender" "\ ]"
.RB  "[\ " "-r"
.IR  "Recipient" "\ ]"
.RB  "[\ " "-x"
.IR  "Recipient_host" "\ ]"
.RB  "[\ " "-l"
.IR  "Syslog_facility" "\ ]"
.RB  "[\ " "-i"
.IR  "Input_file" "\ ]"
.RB  "[\ " "-o"
.IR  "Output_file" "\ ]"
.RB  "[\ " "-e"
.IR  "Configuration_file" "\ ]"
.RB  "[\ " "-c"
.IR  "Charsets_file" "\ ]"
.RB  "[\ " "-B"
.IR  "Recipient_bin_encoding" "\ ]"
.RB  "[\ " "-C"
.IR  "Recipient_charset" "\ ]"
.RB  "[\ " "-F"
.IR  "Recipient_format" "\ ]"
.RB  "[\ " "-H"
.IR  "Recipient_header_encoding" "\ ]"
.RB  "[\ " "-S"
.IR  "Sender_charset" "\ ]"
.RB  "[\ " "-T"
.IR  "Recipient_text_encoding" "\ ]"
.RB  "[\ " "-h" "\ ]"
.RB  "[\ " "-f" "\ ]"
.RB  "[\ " "-p" "\ ]"
.RB  "[\ " "-g" "\ ]"

.SH DESCRIPTION

The message conversion filter
.BR  emil
is used to convert the encoding of enclosures and character set of an Internet 
message aswell as between the three message formats MIME, SUN Mailtool 
and plain old style RFC822. Emil loads the message and applies
the changes in encoding and formatting in core. There is 
.BR no 
spooling. 

Emil can be applied by sendmail, if specified as a delviery agent, and can also
invoke sendmail for it's output. When used like this, as a loop back
delivery agent, emil does not close the connection with the calling sendmail
until it returns an EX_OK from the called sendmail, as a safety measure.

Emil can also be used by a mail client program or as a prefix to a delivery 
agent like binmail when acting like a regular filter. Usage is mainly
limited by your imagination.

Conversion is controlled either by the combination of 
.IR Sender,
.IR Recipient
and
.IR "Recipient_host"
as specified in the configuration file 
MAINCF
or as specified by the command line options.

.SH OPTIONS

.LP
Options may appear in any order.
.RS
.TP 
.BI "\-s " Sender
Sender's mail address.
.TP 
.BI "\-r " Recipient
Recipient's mail address.
.TP
.BI "\-x " Recipient_host
Name of the recipient host or relay.
.TP
.BI "\-l " Syslog_facility
Pick one of: m - LOG_MAIL, d - LOG_DAEMON, 0-7 LOG_LOCAL[0-7].
Log level can be increased by specifying more than once. Log level
becomes: once - LOG_ERR,
twice - LOG_NOTICE, three times - LOG_INFO, and more - LOG_DEBUG.
.TP
.BI "\-i " Input_file
Path to file for use as input. Defaults to standard input.
.TP
.BI "\-o " Output_file
Path to file for use as output. Defaults to standard output.
.TP
.BI "\-e " Configuration_file
Path to file for use as configuration file. Defaults to 
MAINCF
\.
.TP
.BI "\-c " Charsets_file
Path to file for use as charsets file. Defaults to 
CHARFILE

.RE
Beware, when applying any of the next five options, there is no
recipient look up in the configuration file.
.RS
.TP
.BI "\-B " Recipient_binary_encoding
Recipient binary encoding. One of BAse64, BInhex or Uuencode.
This defaults to nothing, thus no binary encoding conversion if
omitted unless gotten from the configuration file.
.TP
.BI "\-C " Recipient_charset
Recipient charset according to RFC1345. 
.TP
.BI "\-F " Recipient_format
Recipient format. One of MIME, MAILTOOL or RFC822. Defaults to
RFC822.
.TP
.BI "\-H " Recipient_header_encoding
Recipient header encoding. One of 7bit, 8bit, BAse64 or Quoted-printable.
See also emil.cf(8).
.TP
.BI "\-T " Recipient_text_encoding
Recipient text encoding. One of 7bit, 8bit, BAse64, BInhex, Quoted-printable
or Uuencode.

.RE
Beware, when applying the Sender_charset option, there is no
sender look up in the configuration file.
.RS
.TP
.BI "\-S " Sender_charset
Sender charset according to RFC1345.


.TP
.BI "\-h "
Log in message header. This is for testing, not for production use.
Log level can be increased by specifying more than once. Log level
becomes: once - LOG_ERR,
twice - LOG_NOTICE, three times - LOG_INFO, and more - LOG_DEBUG.
.TP
.BI "\-f "
Don't put output on stdout, instead pipe
data into a invoked sendmail.
.TP
.BI "\-p "
Adds a pseudo route to sendmail when using the -f option. Instead
of calling sendmail with the recipient's address, call with
@EMIL:"recipient address". Used when sendmail is used to call
emil, to catch the visit to emil of the message.
.TP
.BI "\-g"
Test configuration file. Returns the matching group name based
on the provided recipient, sender and recipient host.
.SH EXAMPLES

To use emil as a simple filter:
.RS

%cat message.in | emil [OPTIONS] > message.out

or

%emil [OPTIONS] -i message.in -o  message.out

.RE
Using emil to call sendmail:
.RS

%emil -s Sender -r Recipient [OPTIONS] -f

.RE
Using emil with sendmail as a loop back delivery agent:
.RS

%emil -s Sender -r Recipient [OPTIONS] -f -p

Start by defining a mailer in sendmail.cf called emil:

.RS
Memil,  P=emilpath, F=DFMhur, A=emil -s $g -r $u -x $h -f -p
.RE

where emilpath is the absolute path to the emil program.

WARNING: Make sure that the sendmail invoked by emil will not invoke emil 
once again. If not, messages will loop. Do this by catching the route
@EMIL in sendmail.cf. For example like this, in the beginning of ruleset
0 in sendmail.cf:

.RS
CZEMIL
.RE
.RS
R$*<@$~Z$*>$*		$#emil$@$2$3$:$1<@$2$3>$4
.RE
.RS
R<@$=Z>:$*		$: $>3$2
.RE

Make sure that class Z is not in use, if so change Z to an available
class name.
.RE

.SH FILES

.PD 0
.TP 20
MAINCF
configuration file.

.TP
CHARFILE
file containing the character set conversion tables.

.SH AUTHOR

Martin Wendel (Martin.Wendel@udac.uu.se) and
Torbjorn Wictorin (Torbjorn.Wictorin@udac.uu.se)

.SH "SEE ALSO"

emil.cf(8)

.SH BUGS

None?




