#include "emil.h"
extern long memall;
void
safe_mchange(struct message *m, struct data *d)
{
  if (m == NULL || d == NULL)
    return;
  if (m->td == d)
    return;
  if (memcmp(m->td->contents + m->td->bodystart, 
	     d->contents,
	     m->td->bodyend - m->td->bodystart) == 0)
    return;
  if (m->td != m->sd)
    {
      free_data(m->td);
    }
  m->td = d;
  return;
}

void
free_data(struct data *d)
{
  /* Get rid of contents, leave the rest */
  if (d == NULL)
    return;
  fprintf(stderr, "* FREE_DATA: %d\n", d->size);
  fflush(stderr);
  if (d->contents != NULL)
    free(d->contents);
  memall -= d->size;
}
